/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ust.ui.views.memusage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.lttng2.ust.ui.views.memusage.Messages;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.lttng2.ust.core.analysis.memory.UstMemoryAnalysisModule;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.linuxtools.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.eclipse.swt.widgets.Composite;

public class MemoryUsageViewer
extends TmfCommonXLineChartViewer {
    private TmfStateSystemAnalysisModule fModule = null;
    private final Map<Integer, double[]> fYValues = new HashMap<Integer, double[]>();
    private final Map<Integer, Integer> fMemoryQuarks = new HashMap<Integer, Integer>();
    private final Map<Integer, String> fSeriesName = new HashMap<Integer, String>();
    private static final int BYTES_TO_KB = 1024;

    public MemoryUsageViewer(Composite parent) {
        super(parent, Messages.MemoryUsageViewer_Title, Messages.MemoryUsageViewer_XAxis, Messages.MemoryUsageViewer_YAxis);
    }

    protected void initializeDataSource() {
        if (this.getTrace() != null) {
            this.fModule = (TmfStateSystemAnalysisModule)this.getTrace().getAnalysisModuleOfClass(TmfStateSystemAnalysisModule.class, UstMemoryAnalysisModule.ID);
            if (this.fModule == null) {
                return;
            }
            this.fModule.schedule();
        }
    }

    protected void updateData(long start, long end, int nb, IProgressMonitor monitor) {
        try {
            if (this.getTrace() == null || this.fModule == null) {
                return;
            }
            ITmfStateSystem ss = this.fModule.getStateSystem();
            if (ss == null) {
                return;
            }
            double[] xvalues = this.getXAxis(start, end, nb);
            this.setXAxis(xvalues);
            List tidQuarks = ss.getSubAttributes(-1, false);
            long traceStart = this.getStartTime();
            long traceEnd = this.getEndTime();
            long offset = this.getTimeOffset();
            Iterator iterator = tidQuarks.iterator();
            while (iterator.hasNext()) {
                int quark = (Integer)iterator.next();
                this.fYValues.put(quark, new double[xvalues.length]);
                this.fMemoryQuarks.put(quark, ss.getQuarkRelative(quark, new String[]{"Memory"}));
                int procNameQuark = ss.getQuarkRelative(quark, new String[]{"Procname"});
                try {
                    ITmfStateValue procnameValue = ss.querySingleState(start, procNameQuark).getStateValue();
                    String procname = new String();
                    if (!procnameValue.isNull()) {
                        procname = procnameValue.unboxStr();
                    }
                    this.fSeriesName.put(quark, new String(String.valueOf(procname) + ' ' + '(' + ss.getAttributeName(quark) + ')').trim());
                }
                catch (TimeRangeException e) {
                    this.fSeriesName.put(quark, String.valueOf('(') + ss.getAttributeName(quark) + ')');
                }
            }
            double yvalue = 0.0;
            int i = 0;
            while (i < xvalues.length) {
                if (monitor.isCanceled()) {
                    return;
                }
                double x = xvalues[i];
                long time = (long)x + offset;
                time = time < traceStart ? traceStart : time;
                time = time > traceEnd ? traceEnd : time;
                Iterator iterator2 = tidQuarks.iterator();
                while (iterator2.hasNext()) {
                    int quark = (Integer)iterator2.next();
                    try {
                        this.fYValues.get((Object)Integer.valueOf((int)quark))[i] = yvalue = (double)(ss.querySingleState(time, this.fMemoryQuarks.get(quark).intValue()).getStateValue().unboxLong() / 1024L);
                    }
                    catch (TimeRangeException e) {
                        this.fYValues.get((Object)Integer.valueOf((int)quark))[i] = 0.0;
                    }
                }
                ++i;
            }
            Iterator iterator3 = tidQuarks.iterator();
            while (iterator3.hasNext()) {
                int quark = (Integer)iterator3.next();
                this.setSeries(this.fSeriesName.get(quark), this.fYValues.get(quark));
            }
            this.updateDisplay();
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | StateValueTypeException e) {
            Activator.logError((String)"Error updating the data of the Memory usage view", (Throwable)e);
        }
    }
}

