/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.handlers.AbstractSaveDataHandler;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;

public class PerfSaveStatsHandler
extends AbstractSaveDataHandler {
    public static String DATA_EXT = "stat";

    @Override
    public IPath saveData(String filename) {
        IPath newDataLoc = this.getNewDataLocation(filename, DATA_EXT);
        IPerfData statData = PerfPlugin.getDefault().getStatData();
        BufferedWriter writer = null;
        OutputStreamWriter osw = null;
        URI newDataLocURI = null;
        try {
            IRemoteFileProxy proxy = null;
            newDataLocURI = new URI(newDataLoc.toPortableString());
            proxy = RemoteProxyManager.getInstance().getFileProxy(newDataLocURI);
            IFileStore newDataFileStore = proxy.getResource(newDataLocURI.getPath());
            osw = new OutputStreamWriter(newDataFileStore.openOutputStream(0, null));
            writer = new BufferedWriter(osw);
            writer.write(statData.getPerfData());
            IFileInfo info = newDataFileStore.fetchInfo();
            info.setAttribute(2, true);
            newDataFileStore.putInfo(info, 1024, null);
            IPath iPath = newDataLoc;
            this.closeResource(writer);
            return iPath;
        }
        catch (IOException | URISyntaxException | CoreException e) {
            this.openErroDialog(Messages.PerfSaveStat_error_title, Messages.PerfSaveStat_error_msg, newDataLoc.lastSegment());
        }
        finally {
            this.closeResource(writer);
        }
        return null;
    }

    @Override
    public boolean verifyData() {
        IPerfData statData = PerfPlugin.getDefault().getStatData();
        return statData != null && statData.getPerfData() != null;
    }
}

