/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.launch;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.perf.PerfCore;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.SourceDisassemblyData;
import org.eclipse.linuxtools.internal.perf.StatData;
import org.eclipse.linuxtools.internal.perf.launch.Messages;
import org.eclipse.linuxtools.internal.perf.ui.SourceDisassemblyView;
import org.eclipse.linuxtools.internal.perf.ui.StatView;
import org.eclipse.linuxtools.tools.launch.core.factory.CdtSpawnerProcessFactory;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.osgi.framework.Version;

public class PerfLaunchConfigDelegate
extends AbstractCLaunchDelegate {
    protected String getPluginID() {
        return "org.eclipse.linuxtools.perf";
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!PerfCore.checkPerfInPath(null)) {
            Status status = new Status(4, "org.eclipse.linuxtools.perf", Messages.PerfLaunchConfigDelegate_perf_not_found);
            throw new CoreException((IStatus)status);
        }
        File wd = this.getWorkingDirectory(config);
        if (wd == null) {
            wd = new File(System.getProperty("user.home", "."));
        }
        IPath workingDir = Path.fromOSString((String)wd.toURI().getPath());
        PerfPlugin.getDefault().setWorkingDir(workingDir);
        if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowStat", false)) {
            this.showStat(config, launch);
        } else {
            IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
            String[] arguments = this.getProgramArgumentsArray(config);
            ArrayList<String> command = new ArrayList<String>();
            Version perfVersion = PerfCore.getPerfVersion(config);
            command.addAll(Arrays.asList(PerfCore.getRecordString(config, perfVersion)));
            command.add(exePath.toOSString());
            command.addAll(Arrays.asList(arguments));
            String[] commandArray = command.toArray(new String[0]);
            boolean usePty = config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
            try {
                Process process = CdtSpawnerProcessFactory.getFactory().exec(commandArray, this.getEnvironment(config), wd, usePty);
                DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(commandArray[0]));
                process.waitFor();
                PrintStream print = null;
                if (config.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true)) {
                    ConsolePlugin plugin = ConsolePlugin.getDefault();
                    IConsoleManager conMan = plugin.getConsoleManager();
                    IConsole[] existing = conMan.getConsoles();
                    IOConsole binaryOutCons = null;
                    IConsole[] iConsoleArray = existing;
                    int n = existing.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConsole x = iConsoleArray[n2];
                        if (x.getName().contains(this.renderProcessLabel(commandArray[0])) && x instanceof IOConsole) {
                            binaryOutCons = (IOConsole)x;
                        }
                        ++n2;
                    }
                    if (binaryOutCons == null && existing.length != 0 && existing[existing.length - 1] instanceof IOConsole) {
                        binaryOutCons = (IOConsole)existing[existing.length - 1];
                    }
                    if (binaryOutCons != null) {
                        IOConsoleOutputStream outputTo = binaryOutCons.newOutputStream();
                        print = new PrintStream((OutputStream)outputTo);
                        int i = 0;
                        while (i < commandArray.length) {
                            print.print(String.valueOf(commandArray[i]) + " ");
                            ++i;
                        }
                        print.println();
                        print.println(Messages.PerfLaunchConfigDelegate_analyzing);
                    }
                }
                PerfCore.report(config, this.getEnvironment(config), workingDir, monitor, null, print);
                PerfPlugin.getDefault().getPerfProfileData().toFile().setReadOnly();
                PerfCore.refreshView(this.renderProcessLabel(exePath.toOSString()));
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowSourceDisassembly", false)) {
                    this.showSourceDisassembly(workingDir);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void showSourceDisassembly(IPath workingDir) {
        String title = this.renderProcessLabel(workingDir + "perf.data");
        SourceDisassemblyData sdData = new SourceDisassemblyData(title, workingDir);
        sdData.parse();
        PerfPlugin.getDefault().setSourceDisassemblyData(sdData);
        SourceDisassemblyView.refreshView();
    }

    private void showStat(ILaunchConfiguration config, ILaunch launch) throws CoreException {
        IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
        String[] arguments = this.getProgramArgumentsArray(config);
        IPath workingDir = PerfPlugin.getDefault().getWorkingDir();
        int runCount = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.StatRunCount", 1);
        StringBuffer args = new StringBuffer();
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            args.append(arg);
            args.append(" ");
            ++n2;
        }
        Object[] titleArgs = new Object[]{exePath.toOSString(), args.toString(), String.valueOf(runCount)};
        String title = this.renderProcessLabel(MessageFormat.format(Messages.PerfLaunchConfigDelegate_stat_title, titleArgs));
        List configEvents = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default);
        String[] statEvents = new String[]{};
        if (!config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true)) {
            statEvents = configEvents == null ? statEvents : configEvents.toArray(new String[0]);
        }
        StatData sd = new StatData(title, workingDir, exePath.toOSString(), arguments, runCount, statEvents);
        sd.setLaunch(launch);
        sd.parse();
        PerfPlugin.getDefault().setStatData(sd);
        sd.updateStatData();
        StatView.refreshView();
    }
}

