/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.remote.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.perf.PerfCore;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.SourceDisassemblyData;
import org.eclipse.linuxtools.internal.perf.StatData;
import org.eclipse.linuxtools.internal.perf.launch.Messages;
import org.eclipse.linuxtools.internal.perf.ui.SourceDisassemblyView;
import org.eclipse.linuxtools.internal.perf.ui.StatView;
import org.eclipse.linuxtools.profiling.launch.ConfigUtils;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteConnection;
import org.eclipse.linuxtools.profiling.launch.RemoteConnectionException;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.framework.Version;

public class PerfLaunchConfigDelegate
extends AbstractCLaunchDelegate {
    private static String OUTPUT_STR = "--output=";
    private IPath binPath;
    private IPath workingDirPath;
    private IProject project;

    protected String getPluginID() {
        return "org.eclipse.linuxtools.perf";
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block26: {
            try {
                ConfigUtils configUtils = new ConfigUtils(config);
                this.project = configUtils.getProject();
                if (!PerfCore.checkPerfInPath(this.project)) {
                    Status status = new Status(4, "org.eclipse.linuxtools.perf", "Error: Perf was not found on PATH");
                    throw new CoreException((IStatus)status);
                }
                URI binURI = new URI(configUtils.getExecutablePath());
                this.binPath = Path.fromPortableString((String)binURI.toString());
                this.workingDirPath = Path.fromPortableString((String)Path.fromPortableString((String)binURI.toString()).removeLastSegments(2).toPortableString());
                PerfPlugin.getDefault().setWorkingDir(this.workingDirPath);
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowStat", false)) {
                    this.showStat(config, launch);
                    break block26;
                }
                URI exeURI = new URI(configUtils.getExecutablePath());
                String configWorkingDir = String.valueOf(configUtils.getWorkingDirectory()) + '/';
                RemoteConnection exeRC = new RemoteConnection(exeURI);
                String perfPathString = RuntimeProcessFactory.getFactory().whichCommand("perf", this.project);
                boolean copyExecutable = configUtils.getCopyExecutable();
                if (copyExecutable) {
                    URI copyExeURI = new URI(configUtils.getCopyFromExecutablePath());
                    RemoteConnection copyExeRC = new RemoteConnection(copyExeURI);
                    IRemoteFileProxy copyExeRFP = copyExeRC.getRmtFileProxy();
                    IFileStore copyExeFS = copyExeRFP.getResource(copyExeURI.getPath());
                    IRemoteFileProxy exeRFP = exeRC.getRmtFileProxy();
                    IFileStore exeFS = exeRFP.getResource(exeURI.getPath());
                    IFileInfo exeFI = exeFS.fetchInfo();
                    if (exeFI.isDirectory()) {
                        IPath copyExePath = Path.fromOSString((String)copyExeURI.getPath());
                        IPath newExePath = Path.fromOSString((String)exeURI.getPath()).append(copyExePath.lastSegment());
                        exeURI = new URI(exeURI.getScheme(), exeURI.getAuthority(), newExePath.toString(), exeURI.getQuery(), exeURI.getFragment());
                        exeFS = exeRFP.getResource(exeURI.getPath());
                    }
                    copyExeFS.copy(exeFS, 6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                IPath remoteBinFile = Path.fromOSString((String)exeURI.getPath());
                URI workingDirURI = new URI(RemoteProxyManager.getInstance().getRemoteProjectLocation(this.project));
                RemoteConnection workingDirRC = new RemoteConnection(workingDirURI);
                IRemoteFileProxy workingDirRFP = workingDirRC.getRmtFileProxy();
                IFileStore workingDir = workingDirRFP.getResource(workingDirURI.getPath());
                String[] arguments = this.getProgramArgumentsArray(config);
                ArrayList<String> command = new ArrayList<String>(4 + arguments.length);
                Version perfVersion = PerfCore.getPerfVersion(config);
                command.addAll(Arrays.asList(PerfCore.getRecordString(config, perfVersion)));
                command.add(remoteBinFile.toOSString());
                command.set(0, perfPathString);
                command.add(2, String.valueOf(OUTPUT_STR) + configWorkingDir + "perf.data");
                command.addAll(Arrays.asList(arguments));
                String[] commandArray = command.toArray(new String[command.size()]);
                Process pProxy = RuntimeProcessFactory.getFactory().exec(commandArray, this.getEnvironment(config), workingDir, this.project);
                MessageConsole console = new MessageConsole("Perf Console", null);
                console.activate();
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
                MessageConsoleStream stream = console.newMessageStream();
                if (pProxy != null) {
                    Throwable throwable = null;
                    Object var25_30 = null;
                    try (BufferedReader error = new BufferedReader(new InputStreamReader(pProxy.getErrorStream()));){
                        String err = error.readLine();
                        while (err != null) {
                            stream.println(err);
                            err = error.readLine();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                pProxy.destroy();
                PrintStream print = null;
                if (config.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true)) {
                    ConsolePlugin plugin = ConsolePlugin.getDefault();
                    IConsoleManager conMan = plugin.getConsoleManager();
                    IConsole[] existing = conMan.getConsoles();
                    IOConsole binaryOutCons = null;
                    IConsole[] iConsoleArray = existing;
                    int n = existing.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConsole x = iConsoleArray[n2];
                        if (x.getName().contains(this.renderProcessLabel(commandArray[0]))) {
                            binaryOutCons = (IOConsole)x;
                        }
                        ++n2;
                    }
                    if (binaryOutCons == null && existing.length != 0 && existing[existing.length - 1] instanceof IOConsole) {
                        binaryOutCons = (IOConsole)existing[existing.length - 1];
                    }
                    if (binaryOutCons != null) {
                        IOConsoleOutputStream outputTo = binaryOutCons.newOutputStream();
                        print = new PrintStream((OutputStream)outputTo);
                    }
                    int i = 0;
                    while (i < command.size()) {
                        print.print(String.valueOf((String)command.get(i)) + " ");
                        ++i;
                    }
                    print.println();
                    print.println("Analysing recorded perf.data, please wait...");
                }
                PerfCore.report(config, this.getEnvironment(config), Path.fromOSString((String)configWorkingDir), monitor, null, print);
                URI perfDataURI = null;
                IRemoteFileProxy proxy = null;
                perfDataURI = new URI(String.valueOf(RemoteProxyManager.getInstance().getRemoteProjectLocation(this.project)) + "perf.data");
                proxy = RemoteProxyManager.getInstance().getFileProxy(perfDataURI);
                IFileStore perfDataFileStore = proxy.getResource(perfDataURI.getPath());
                IFileInfo info = perfDataFileStore.fetchInfo();
                info.setAttribute(2, true);
                perfDataFileStore.putInfo(info, 1024, null);
                PerfCore.refreshView(this.renderProcessLabel(exeURI.getPath()));
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowSourceDisassembly", false)) {
                    this.showSourceDisassembly(Path.fromPortableString((String)(String.valueOf(workingDirURI.toString()) + '/')));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.abort(e.getLocalizedMessage(), null, 150);
            }
            catch (RemoteConnectionException e) {
                e.printStackTrace();
                this.abort(e.getLocalizedMessage(), null, 150);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                this.abort(e.getLocalizedMessage(), null, 150);
            }
        }
    }

    private void showSourceDisassembly(IPath workingDir) {
        String title = this.renderProcessLabel(String.valueOf(workingDir.toPortableString()) + "perf.data");
        SourceDisassemblyData sdData = new SourceDisassemblyData(title, workingDir, this.project);
        sdData.parse();
        PerfPlugin.getDefault().setSourceDisassemblyData(sdData);
        SourceDisassemblyView.refreshView();
    }

    private void showStat(ILaunchConfiguration config, ILaunch launch) throws CoreException {
        String[] arguments = this.getProgramArgumentsArray(config);
        int runCount = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.StatRunCount", 1);
        StringBuffer args = new StringBuffer();
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            args.append(arg);
            args.append(" ");
            ++n2;
        }
        URI binURI = null;
        try {
            binURI = new URI(this.binPath.toPortableString());
        }
        catch (URISyntaxException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgProxyError, (String)Messages.MsgProxyError);
        }
        Object[] titleArgs = new Object[]{binURI.getPath(), args.toString(), String.valueOf(runCount)};
        String title = this.renderProcessLabel(MessageFormat.format(Messages.PerfLaunchConfigDelegate_stat_title, titleArgs));
        List configEvents = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default);
        String[] statEvents = new String[]{};
        if (!config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true)) {
            statEvents = configEvents == null ? statEvents : configEvents.toArray(new String[0]);
        }
        StatData sd = new StatData(title, this.workingDirPath, binURI.getPath(), arguments, runCount, statEvents, this.project);
        sd.setLaunch(launch);
        sd.parse();
        PerfPlugin.getDefault().setStatData(sd);
        sd.updateStatData();
        StatView.refreshView();
    }
}

