/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts;

import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.listeners.ChartWithAxisMouseMoveListener;
import org.eclipse.linuxtools.systemtap.graphing.core.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.graphing.ui.charts.AbstractChartBuilder;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.swtchart.IAxis;
import org.swtchart.ISeries;
import org.swtchart.ITitle;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public abstract class AbstractChartWithAxisBuilder
extends AbstractChartBuilder {
    private PaintListener titleBoundsPaintListener;
    private double defaultMargin = 0.04;
    protected boolean xLineGrid = this.store.getBoolean("ShowXGridLines");
    protected boolean yLineGrid = this.store.getBoolean("ShowYGridLines");
    protected int xSeriesTicks = this.store.getInt("XSeriesTicks");
    protected int ySeriesTicks = this.store.getInt("YSeriesTicks");

    protected double getChartMarginXL() {
        return this.defaultMargin;
    }

    protected double getChartMarginXU() {
        return this.defaultMargin;
    }

    protected double getChartMarginYL() {
        return this.defaultMargin;
    }

    protected double getChartMarginYU() {
        return this.defaultMargin;
    }

    protected abstract ISeries createChartISeries(int var1);

    @Override
    protected void updateProperties(PropertyChangeEvent event) {
        super.updateProperties(event);
        String eventName = event.getProperty();
        if (eventName.equals("ShowXGridLines")) {
            this.xLineGrid = this.store.getBoolean("ShowXGridLines");
            this.buildXAxis();
        } else if (eventName.equals("ShowYGridLines")) {
            this.yLineGrid = this.store.getBoolean("ShowYGridLines");
            this.buildYAxis();
        } else if (eventName.equals("XSeriesTicks")) {
            this.xSeriesTicks = this.store.getInt("XSeriesTicks");
            this.buildXAxis();
        } else if (eventName.equals("YSeriesTicks")) {
            this.ySeriesTicks = this.store.getInt("YSeriesTicks");
            this.buildYAxis();
        }
    }

    public AbstractChartWithAxisBuilder(IAdapter adapter, Composite parent, int style, String title) {
        super(adapter, parent, style, title);
    }

    @Override
    protected void createChart() {
        super.createChart();
        this.applyTitleBoundsListener();
        this.chartMouseMoveListener = new ChartWithAxisMouseMoveListener(this.chart, this.chart.getPlotArea());
    }

    protected void applyTitleBoundsListener() {
        this.titleBoundsPaintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = AbstractChartWithAxisBuilder.this.chart.getPlotArea().getBounds();
                Control title = (Control)AbstractChartWithAxisBuilder.this.chart.getTitle();
                Rectangle titleBounds = title.getBounds();
                title.setLocation(new Point(bounds.x + (bounds.width - titleBounds.width) / 2, title.getLocation().y));
            }
        };
        this.chart.addPaintListener(this.titleBoundsPaintListener);
    }

    protected void removeTitleBoundsListener() {
        if (this.titleBoundsPaintListener != null) {
            this.chart.removePaintListener(this.titleBoundsPaintListener);
            this.titleBoundsPaintListener = null;
        }
    }

    @Override
    protected void buildXAxis() {
        String[] labels = this.adapter.getLabels();
        IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
        if (this.xLineGrid) {
            xAxis.getGrid().setStyle(LineStyle.SOLID);
        } else {
            xAxis.getGrid().setStyle(LineStyle.NONE);
        }
        xAxis.getTick().setForeground(BLACK);
        xAxis.getTick().setTickMarkStepHint(this.xSeriesTicks);
        ITitle xTitle = xAxis.getTitle();
        xTitle.setForeground(BLACK);
        if (labels.length > 0) {
            xTitle.setText(labels[0]);
        } else {
            xTitle.setText("");
        }
    }

    @Override
    protected void buildYAxis() {
        IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
        yAxis.getTitle().setText("");
        if (this.yLineGrid) {
            yAxis.getGrid().setStyle(LineStyle.SOLID);
        } else {
            yAxis.getGrid().setStyle(LineStyle.NONE);
        }
        yAxis.getTick().setForeground(BLACK);
        yAxis.getTick().setTickMarkStepHint(this.ySeriesTicks);
    }

    @Override
    protected void buildXSeries() {
        double minX;
        double maxX;
        Object[][] data = this.adapter.getData();
        if (data == null || data.length == 0) {
            return;
        }
        int start = 0;
        int len = Math.min(this.maxItems, data.length);
        int leny = data[0].length - 1;
        if (this.maxItems < data.length) {
            start = data.length - this.maxItems;
        }
        Double[] all_valx = new Double[len];
        Double[][] all_valy = new Double[leny][len];
        double maxY = maxX = Double.NEGATIVE_INFINITY;
        double minY = minX = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < leny + 1) {
                Double val = this.getDoubleOrNullValue(data[start + i][j]);
                if (j == 0) {
                    if (val == null) break;
                    all_valx[i] = val;
                    maxX = Math.max(val, maxX);
                    minX = Math.min(val, minX);
                } else if (val != null) {
                    all_valy[j - 1][i] = val;
                    maxY = Math.max(val, maxY);
                    minY = Math.min(val, minY);
                }
                ++j;
            }
            ++i;
        }
        ISeries[] allSeries = this.chart.getSeriesSet().getSeries();
        ISeries series = null;
        int i2 = 0;
        while (i2 < leny) {
            series = i2 >= allSeries.length ? this.createChartISeries(i2) : this.chart.getSeriesSet().getSeries()[i2];
            double[] valx = new double[len];
            double[] valy = new double[len];
            int len_trim = 0;
            int j = 0;
            while (j < len) {
                if (all_valx[j] != null && all_valy[i2][j] != null) {
                    valx[len_trim] = all_valx[j];
                    valy[len_trim] = all_valy[i2][j];
                    ++len_trim;
                }
                ++j;
            }
            double[] valx_trim = new double[len_trim];
            double[] valy_trim = new double[len_trim];
            int j2 = 0;
            while (j2 < len_trim) {
                valx_trim[j2] = valx[j2];
                valy_trim[j2] = valy[j2];
                ++j2;
            }
            series.setXSeries(valx_trim);
            series.setYSeries(valy_trim);
            ++i2;
        }
        if (series != null && series.getXSeries().length > 0) {
            this.applyRangeX(minX, maxX);
            this.applyRangeY(minY, maxY);
        }
        this.chart.redraw();
    }

    private void applyRangeX(double min, double max) {
        IAxis axis = this.chart.getAxisSet().getXAxis(0);
        double actualRange = max - min;
        double scaledRange = actualRange * this.scale;
        double marginL = scaledRange > 0.0 ? scaledRange * this.getChartMarginXL() : 1.0;
        double marginU = scaledRange > 0.0 ? scaledRange * this.getChartMarginXU() : 1.0;
        double lower = (actualRange - scaledRange) * this.scroll + min;
        axis.setRange(new Range(lower - marginL, lower + scaledRange + marginU));
    }

    protected void applyRangeY(double min, double max) {
        IAxis axis = this.chart.getAxisSet().getYAxis(0);
        double actualRange = max - min;
        double scaledRange = actualRange * this.scaleY;
        double marginL = scaledRange > 0.0 ? scaledRange * this.getChartMarginYL() : 1.0;
        double marginU = scaledRange > 0.0 ? scaledRange * this.getChartMarginYU() : 1.0;
        double lower = (actualRange - scaledRange) * this.scrollY + min;
        axis.setRange(new Range(lower - marginL, lower + scaledRange + marginU));
    }

    @Override
    public void updateDataSet() {
        this.buildXSeries();
        this.chartMouseMoveListener.update();
    }

    @Override
    protected void buildYSeries() {
    }
}

