/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphing.ui.datadisplay;

import java.text.MessageFormat;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.GraphingUIPlugin;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.Localization;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter.AvailableFilterTypes;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter.SelectFilterWizard;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IFilteredDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.filters.IDataSetFilter;
import org.eclipse.linuxtools.systemtap.structures.IFormattingStyles;
import org.eclipse.linuxtools.systemtap.structures.StringFormatter;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class DataGrid
implements IUpdateListener {
    private IFilteredDataSet filteredDataSet;
    private IFormattingStyles[] columnFormat;
    private Table table;
    private Point clickLocation;
    private IPreferenceStore prefs = GraphingUIPlugin.getDefault().getPreferenceStore();
    private boolean manualResize = !this.prefs.getBoolean("AutoResizeColumns");
    private Menu filterMenu;
    private MenuItem removeFiltersMenuItem;
    private MenuItem formatMenuItem;
    private IPropertyChangeListener propertyChangeListener;
    public static final int NONE = 0;
    public static final int FULL_UPDATE = 1;

    public DataGrid(Composite composite, IFilteredDataSet set) {
        this.filteredDataSet = set;
        this.clickLocation = new Point(-1, -1);
        this.createPartControl(composite);
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("MaxDataItems")) {
                    DataGrid.this.handleUpdateEvent();
                }
            }
        };
        this.prefs.addPropertyChangeListener(this.propertyChangeListener);
    }

    public Control getControl() {
        return this.table;
    }

    private void createPartControl(Composite parent) {
        this.table = new Table(parent, 65540);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.getVerticalBar().setVisible(true);
        String[] names = this.filteredDataSet.getTitles();
        TableColumn column = new TableColumn(this.table, 16384);
        column.setText(Localization.getString("DataGrid.Row"));
        column.pack();
        column.setMoveable(false);
        column.setResizable(false);
        this.columnFormat = new IFormattingStyles[names.length];
        int i = 0;
        while (i < names.length) {
            column = new TableColumn(this.table, 16384);
            column.setText(names[i]);
            column.pack();
            column.setMoveable(true);
            this.columnFormat[i] = new StringFormatter();
            ++i;
        }
        this.table.setMenu(this.initMenus());
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                ((DataGrid)DataGrid.this).clickLocation.x = event.x;
                ((DataGrid)DataGrid.this).clickLocation.y = event.y;
            }
        });
        this.handleUpdateEvent();
    }

    private Menu initMenus() {
        int i;
        Menu menu = new Menu((Decorations)this.table.getShell(), 8);
        menu.addMenuListener((MenuListener)new MainMenuListener());
        Menu formatMenu = new Menu(menu);
        this.formatMenuItem = new MenuItem(menu, 64);
        this.formatMenuItem.setText(Localization.getString("DataGrid.FormatAs"));
        this.formatMenuItem.setMenu(formatMenu);
        this.filterMenu = new Menu(menu);
        MenuItem item = new MenuItem(menu, 64);
        item.setText(Localization.getString("DataGrid.AddFilter"));
        item.addSelectionListener((SelectionListener)new AddFilterSelection());
        this.removeFiltersMenuItem = new MenuItem(menu, 64);
        this.removeFiltersMenuItem.setText(Localization.getString("DataGrid.RemoveFilter"));
        this.removeFiltersMenuItem.setMenu(this.filterMenu);
        IDataSetFilter[] filters = this.filteredDataSet.getFilters();
        if (filters != null && filters.length > 0) {
            i = 0;
            while (i < filters.length) {
                item = new MenuItem(this.filterMenu, 64);
                item.setText(AvailableFilterTypes.getFilterName(filters[i].getID()));
                item.setData((Object)filters[i]);
                item.addSelectionListener((SelectionListener)new RemoveFilterSelection());
                ++i;
            }
        } else {
            this.removeFiltersMenuItem.setEnabled(false);
        }
        item = new MenuItem(menu, 32);
        item.setText(Localization.getString("DataGrid.ManualyResize"));
        item.addSelectionListener((SelectionListener)new MenuManualyResizedSelection());
        i = 0;
        while (i < IFormattingStyles.FORMAT_TITLES.length) {
            item = new MenuItem(formatMenu, 16);
            item.setText(IFormattingStyles.FORMAT_TITLES[i]);
            item.addSelectionListener((SelectionListener)new MenuFormatSelection());
            ++i;
        }
        this.formatMenuItem.setEnabled(this.filteredDataSet.getRowCount() > 0);
        formatMenu.addMenuListener((MenuListener)new FormatMenuListener());
        return menu;
    }

    private int getSelectedColumn() {
        TableColumn[] cols = this.table.getColumns();
        int location = 0;
        int i = 0;
        while (i < cols.length) {
            if (this.clickLocation.x > location && this.clickLocation.x < (location += cols[i].getWidth())) {
                return i;
            }
            ++i;
        }
        return cols.length - 1;
    }

    public void handleUpdateEvent() {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int startLocation;
                if (DataGrid.this.table.isDisposed()) {
                    return;
                }
                int endLocation = DataGrid.this.filteredDataSet.getRowCount();
                int maxItems = DataGrid.this.prefs.getInt("MaxDataItems");
                int oldSelection = DataGrid.this.table.getSelectionIndex();
                DataGrid.this.table.removeAll();
                int i = startLocation = Math.max(endLocation - maxItems, 0);
                while (i < endLocation) {
                    TableItem item = new TableItem(DataGrid.this.table, 0);
                    Object[] os = DataGrid.this.filteredDataSet.getRow(i);
                    item.setText(0, Integer.toString(i + 1));
                    int j = 0;
                    while (j < os.length) {
                        if (os[j] != null) {
                            item.setText(j + 1, DataGrid.this.columnFormat[j].format(os[j].toString()));
                        }
                        ++j;
                    }
                    ++i;
                }
                if (oldSelection != -1) {
                    DataGrid.this.table.select(oldSelection);
                }
                TableColumn col = DataGrid.this.table.getColumn(0);
                col.pack();
                if (!DataGrid.this.manualResize) {
                    TableColumn[] cols = DataGrid.this.table.getColumns();
                    int i2 = 1;
                    while (i2 < cols.length) {
                        cols[i2].pack();
                        ++i2;
                    }
                }
                if (DataGrid.this.prefs.getBoolean("JumpNewTableEntry") && DataGrid.this.table.getItemCount() > 0) {
                    DataGrid.this.table.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DataGrid.this.table.showItem(DataGrid.this.table.getItem(DataGrid.this.table.getItemCount() - 1));
                        }
                    });
                }
                DataGrid.this.formatMenuItem.setEnabled(DataGrid.this.table.getItemCount() > 0);
            }
        });
    }

    public void dispose() {
        this.filteredDataSet = null;
        this.table.dispose();
        this.table = null;
        this.clickLocation = null;
        this.columnFormat = null;
        this.prefs.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    private class AddFilterSelection
    extends SelectionAdapter {
        private AddFilterSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            SelectFilterWizard wizard = new SelectFilterWizard(DataGrid.this.filteredDataSet.getTitles());
            IWorkbench workbench = PlatformUI.getWorkbench();
            wizard.init(workbench, null);
            WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.create();
            int result = dialog.open();
            if (result != 1) {
                IDataSetFilter filter = wizard.getFilter();
                DataGrid.this.removeFiltersMenuItem.setEnabled(true);
                DataGrid.this.filteredDataSet.addFilter(filter);
                DataGrid.this.table.removeAll();
                DataGrid.this.handleUpdateEvent();
                MenuItem item = new MenuItem(DataGrid.this.filterMenu, 64);
                item.setText(MessageFormat.format(Localization.getString("DataGrid.FilterLabel"), AvailableFilterTypes.getFilterName(filter.getID()), DataGrid.this.filteredDataSet.getTitles()[filter.getColumn()], filter.getInfo()));
                item.setData((Object)filter);
                item.addSelectionListener((SelectionListener)new RemoveFilterSelection());
            }
            wizard.dispose();
        }
    }

    private class FormatMenuListener
    extends MenuAdapter {
        private FormatMenuListener() {
        }

        public void menuShown(MenuEvent e) {
            MenuItem[] items = ((Menu)e.widget).getItems();
            boolean doubleValid = false;
            boolean longValid = false;
            int selectedCol = Math.max(1, DataGrid.this.getSelectedColumn());
            int i = 0;
            while (i < items.length) {
                items[i].setSelection(false);
                ++i;
            }
            items[DataGrid.this.columnFormat[selectedCol - 1].getFormat()].setSelection(true);
            items[0].setEnabled(true);
            items[1].setEnabled(true);
            String itemText = DataGrid.this.filteredDataSet.getRow(0)[selectedCol - 1].toString();
            try {
                Double.parseDouble(itemText);
                doubleValid = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                Long.parseLong(itemText);
                longValid = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            items[3].setEnabled(doubleValid);
            items[4].setEnabled(longValid);
            items[5].setEnabled(longValid);
            items[6].setEnabled(longValid);
            items[2].setEnabled(longValid);
        }
    }

    private class MainMenuListener
    extends MenuAdapter {
        private MainMenuListener() {
        }

        public void menuShown(MenuEvent e) {
            MenuItem item = ((Menu)e.widget).getItem(1);
            item.setSelection(DataGrid.this.manualResize);
        }
    }

    private class MenuFormatSelection
    extends SelectionAdapter {
        private MenuFormatSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            int format = 0;
            int column = Math.max(1, DataGrid.this.getSelectedColumn());
            int i = 0;
            while (i < IFormattingStyles.FORMAT_TITLES.length) {
                if (IFormattingStyles.FORMAT_TITLES[i].equals(((MenuItem)e.getSource()).getText())) {
                    format = i;
                }
                ++i;
            }
            Object[] data = DataGrid.this.filteredDataSet.getColumn(column - 1);
            DataGrid.this.columnFormat[column - 1].setFormat(format);
            i = 0;
            while (i < DataGrid.this.table.getItemCount()) {
                DataGrid.this.table.getItem(i).setText(column, DataGrid.this.columnFormat[column - 1].format(data[i].toString()));
                ++i;
            }
            DataGrid.this.table.redraw();
        }
    }

    private class MenuManualyResizedSelection
    extends SelectionAdapter {
        private MenuManualyResizedSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            DataGrid.this.manualResize = !DataGrid.this.manualResize;
        }
    }

    private class RemoveFilterSelection
    implements SelectionListener {
        private RemoveFilterSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            IDataSetFilter idsf = (IDataSetFilter)((MenuItem)e.widget).getData();
            e.widget.dispose();
            if (DataGrid.this.filterMenu.getItemCount() == 0) {
                DataGrid.this.removeFiltersMenuItem.setEnabled(false);
            }
            if (DataGrid.this.filteredDataSet.removeFilter(idsf)) {
                DataGrid.this.table.removeAll();
                DataGrid.this.handleUpdateEvent();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

