/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphing.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.graphing.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.graphing.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GraphComposite
extends Composite {
    private final Composite xControl;
    private final Composite yControl;
    private boolean sidebarVisible = false;
    private AbstractChartBuilder builder;
    private List<Button> checkOptions;
    private Composite checkOptionComp;

    public GraphComposite(Composite parent, int style, GraphData gd, IDataSet ds) {
        super(parent, style);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        this.setLayout((Layout)layout);
        this.checkOptions = new ArrayList<Button>();
        this.checkOptionComp = new Composite((Composite)this, style);
        this.checkOptionComp.setLayout((Layout)new RowLayout(512));
        FormData data = new FormData();
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        this.checkOptionComp.setLayoutData((Object)data);
        this.builder = GraphFactory.createGraph(this, style, gd, ds);
        this.xControl = GraphFactory.createGraphXControl(this, style);
        this.yControl = GraphFactory.createGraphYControl(this, style);
        if (this.xControl instanceof IUpdateListener) {
            this.builder.addUpdateListener((IUpdateListener)this.xControl);
        }
        if (this.yControl instanceof IUpdateListener) {
            this.builder.addUpdateListener((IUpdateListener)this.yControl);
        }
        this.configure(true);
        this.builder.build();
    }

    private void configure(boolean withSidebar) {
        this.sidebarVisible = withSidebar;
        for (Button b : this.checkOptions) {
            b.setVisible(withSidebar);
        }
        if (this.xControl != null) {
            this.xControl.setVisible(withSidebar);
        }
        if (this.yControl != null) {
            this.yControl.setVisible(withSidebar);
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = withSidebar ? new FormAttachment((Control)this.checkOptionComp, 0) : new FormAttachment(100, 0);
        data.bottom = withSidebar && this.xControl != null ? new FormAttachment((Control)this.xControl, 0) : new FormAttachment(100, 0);
        data.left = withSidebar && this.yControl != null ? new FormAttachment((Control)this.yControl, 0) : new FormAttachment(0, 0);
        this.builder.setLayoutData(data);
        this.layout(true, true);
    }

    public void addCheckOption(String title, SelectionListener listener) {
        Button b = new Button(this.checkOptionComp, 32);
        b.setText(title);
        b.addSelectionListener(listener);
        this.checkOptions.add(b);
        b.setSelection(true);
        this.configure(this.sidebarVisible);
    }

    public AbstractChartBuilder getCanvas() {
        return this.builder;
    }

    public void setLegendVisible(boolean visible) {
        this.builder.getChart().getLegend().setVisible(visible);
        this.builder.handleUpdateEvent();
    }
}

