/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog;

import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.linuxtools.internal.systemtap.ui.consolelog.actions.CloseStapConsoleAction;
import org.eclipse.linuxtools.internal.systemtap.ui.consolelog.actions.SaveLogAction;
import org.eclipse.linuxtools.internal.systemtap.ui.consolelog.actions.StopScriptAction;
import org.eclipse.linuxtools.systemtap.structures.process.SystemTapRuntimeProcessFactory;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;

public class ScriptConsolePageParticipant
implements IConsolePageParticipant,
IDebugContextListener {
    private IPageBookViewPage fPage;
    private IConsoleView fView;
    private ScriptConsole fConsole;

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void init(IPageBookViewPage page, IConsole iConsole) {
        if (!(iConsole instanceof ScriptConsole)) {
            return;
        }
        this.fPage = page;
        this.fConsole = (ScriptConsole)iConsole;
        this.fView = (IConsoleView)this.fPage.getSite().getPage().findView("org.eclipse.ui.console.ConsoleView");
        StopScriptAction stopScriptAction = new StopScriptAction(this.fConsole);
        CloseStapConsoleAction closeConsoleAction = new CloseStapConsoleAction(this.fConsole);
        SaveLogAction saveLogAction = new SaveLogAction(this.fConsole);
        IToolBarManager manager = this.fPage.getSite().getActionBars().getToolBarManager();
        manager.appendToGroup("launchGroup", (IAction)stopScriptAction);
        manager.appendToGroup("launchGroup", (IAction)closeConsoleAction);
        manager.appendToGroup("outputGroup", (IAction)saveLogAction);
        DebugUITools.getDebugContextManager().getContextService(this.fPage.getSite().getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.fPage.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this);
        this.fConsole = null;
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public void debugContextChanged(DebugContextEvent event) {
        IProcess process;
        if ((event.getFlags() & 1) > 0 && this.fView != null && this.fConsole != null && (process = DebugUITools.getCurrentProcess()) instanceof SystemTapRuntimeProcessFactory.SystemTapRuntimeProcess && ((SystemTapRuntimeProcessFactory.SystemTapRuntimeProcess)process).matchesProcess(this.fConsole.getProcess())) {
            this.fView.display((IConsole)this.fConsole);
        }
    }
}

