/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;

public final class STPMetadataSingleton {
    public static String[] NO_MATCHES = new String[0];
    private static STPMetadataSingleton instance = null;

    private STPMetadataSingleton() {
    }

    public static STPMetadataSingleton getInstance() {
        if (instance == null) {
            instance = new STPMetadataSingleton();
        }
        return instance;
    }

    public void waitForInitialization() {
        TapsetLibrary.waitForInitialization();
    }

    public String[] getFunctionCompletions(String prefix) {
        TreeNode node = TapsetLibrary.getFunctions();
        return this.getMatchingChildren(node, prefix);
    }

    public String[] getProbeCompletions(String prefix) {
        LinkedList<String> matches = new LinkedList<String>();
        String groupName = this.extractProbeGroupName(prefix);
        TreeNode[] treeNodeArray = TapsetLibrary.getProbeCategoryNodes();
        int n = treeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode node = treeNodeArray[n2];
            if (node != null) {
                TreeNode groupNode = node.getChildByName(groupName);
                if (groupNode != null) {
                    node = groupNode;
                }
                matches.addAll(Arrays.asList(this.getMatchingChildren(node, prefix)));
            }
            ++n2;
        }
        return !matches.isEmpty() ? matches.toArray(new String[matches.size()]) : NO_MATCHES;
    }

    public String[] getProbeVariableCompletions(String probe, String prefix) {
        TreeNode node = TapsetLibrary.getProbeAliases();
        if (node == null) {
            return NO_MATCHES;
        }
        if ((node = node.getChildByName(this.extractProbeGroupName(probe))) == null) {
            return NO_MATCHES;
        }
        if ((node = node.getChildByName(probe)) == null) {
            return NO_MATCHES;
        }
        return this.getMatchingChildren(node, prefix);
    }

    private String[] getMatchingChildren(TreeNode node, String prefix) {
        ArrayList<String> matches = new ArrayList<String>();
        int n = node.getChildCount();
        int i = 0;
        while (i < n) {
            if (node.getChildAt(i).toString().startsWith(prefix)) {
                matches.add(node.getChildAt(i).toString());
            }
            ++i;
        }
        return matches.toArray(new String[0]);
    }

    private String extractProbeGroupName(String probeName) {
        int dotIndex = probeName.indexOf(46);
        int parenIndex = probeName.indexOf(40);
        if (dotIndex > 0 && parenIndex > 0) {
            return probeName.substring(0, Math.min(dotIndex, parenIndex));
        }
        if (dotIndex > 0) {
            return probeName.substring(0, dotIndex);
        }
        if (parenIndex > 0) {
            return probeName.substring(0, parenIndex);
        }
        return probeName;
    }
}

