/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import java.text.MessageFormat;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.SharedParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TreeTapsetParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.ProbeNodeData;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.ProbevarNodeData;
import org.eclipse.linuxtools.systemtap.structures.TreeDefinitionNode;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;

public final class ProbeParser
extends TreeTapsetParser {
    public static final String PROBE_REGEX = "(?s)(?<!\\w)probe\\s+{0}\\s*\\+?=";
    private static final String TAPSET_PROBE_REGEX = "probe {0} \\+?=";
    private TreeNode probes;
    private TreeNode statics;
    private TreeNode aliases;
    private static ProbeParser parser = null;

    public static ProbeParser getInstance() {
        if (parser != null) {
            return parser;
        }
        parser = new ProbeParser();
        return parser;
    }

    private ProbeParser() {
        super("Probe Parser");
    }

    @Override
    public synchronized TreeNode getTree() {
        return this.probes;
    }

    @Override
    public void dispose() {
        this.probes.dispose();
        this.statics.dispose();
        this.aliases.dispose();
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.reset();
        this.addStaticProbes();
        if (this.isCancelRequested()) {
            return new Status(8, "org.eclipse.linuxtools.systemtap.ui.ide", "");
        }
        this.addProbeAliases();
        this.constructRootTree();
        this.fireUpdateEvent();
        return new Status(!this.isCancelRequested() ? 0 : 8, "org.eclipse.linuxtools.systemtap.ui.ide", "");
    }

    private void reset() {
        this.probes = new TreeNode(null, false);
        this.statics = new TreeNode((Object)Messages.ProbeParser_staticProbes, false);
        this.aliases = new TreeNode((Object)Messages.ProbeParser_aliasProbes, false);
    }

    private void constructRootTree() {
        this.statics.sortTree();
        this.aliases.sortTree();
        this.probes.add(this.statics);
        this.probes.add(this.aliases);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addStaticProbes() {
        String probeDump = this.runStap(new String[]{"--dump-probe-types"}, null, false);
        if (probeDump == null) {
            return;
        }
        TreeNode group = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            block9: {
                Scanner st = new Scanner(probeDump);
                try {
                }
                finally {
                    if (!st.hasNextLine()) break block9;
                }
            }
            return;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addProbeAliases() {
        String probeDump = this.runStap(new String[]{"-L"}, "**", false);
        if (probeDump == null) {
            return;
        }
        TreeNode group = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            block9: {
                Scanner st = new Scanner(probeDump);
                try {
                }
                finally {
                    if (!st.hasNextLine()) break block9;
                }
            }
            return;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private TreeNode addOrFindProbeGroup(String groupName, TreeNode groupNode, TreeNode category) {
        if (groupNode == null || !groupNode.toString().equals(groupName)) {
            groupNode = category.getChildByName(groupName);
        }
        if (groupNode == null) {
            groupNode = new TreeNode((Object)groupName, true);
            category.add(groupNode);
        }
        return groupNode;
    }

    private String extractProbeGroupName(String probeName) {
        int dotIndex = probeName.indexOf(46);
        int parenIndex = probeName.indexOf(40);
        if (dotIndex > 0 && parenIndex > 0) {
            return probeName.substring(0, Math.min(dotIndex, parenIndex));
        }
        if (dotIndex > 0) {
            return probeName.substring(0, dotIndex);
        }
        if (parenIndex > 0) {
            return probeName.substring(0, parenIndex);
        }
        return probeName;
    }

    private TreeNode makeStaticProbeNode(String probeName) {
        return new TreeNode((Object)new ProbeNodeData(probeName), probeName, true);
    }

    private TreeNode makeProbeAliasNode(String probeName) {
        return new TreeDefinitionNode((Object)new ProbeNodeData(probeName), probeName, this.findDefinitionOf(probeName), true);
    }

    private boolean isStaticProbeGroup(String groupName) {
        return this.statics.getChildByName(groupName) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findDefinitionOf(String probeName) {
        SharedParser sparser = SharedParser.getInstance();
        String tapsetContents = sparser.getTapsetContents();
        if (tapsetContents == null) {
            return null;
        }
        Matcher probeMatcher = Pattern.compile(MessageFormat.format(TAPSET_PROBE_REGEX, Pattern.quote(probeName))).matcher(tapsetContents);
        if (!probeMatcher.find()) {
            return null;
        }
        int fileLocIndex = tapsetContents.substring(0, probeMatcher.start()).lastIndexOf("# file");
        Throwable throwable = null;
        Object var7_8 = null;
        try (Scanner scanner = new Scanner(tapsetContents.substring(fileLocIndex));){
            Matcher fileMatcher = sparser.filePattern.matcher(scanner.nextLine());
            return fileMatcher.matches() ? fileMatcher.group(1) : null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private void addAllVarNodesToProbeNode(StringTokenizer varTokenizer, TreeNode probeNode) {
        StringBuilder prev = new StringBuilder("");
        while (varTokenizer.hasMoreTokens()) {
            String token = varTokenizer.nextToken();
            if (token.contains(":") && prev.length() > 0) {
                prev.setLength(prev.length() - 1);
                this.addVarNodeToProbeNode(prev.toString(), probeNode);
                prev.setLength(0);
            }
            prev.append(String.valueOf(token) + " ");
        }
        if (prev.length() > 0) {
            prev.setLength(prev.length() - 1);
            this.addVarNodeToProbeNode(prev.toString(), probeNode);
        }
    }

    private void addVarNodeToProbeNode(String info, TreeNode probeNode) {
        probeNode.add(new TreeNode((Object)new ProbevarNodeData(info), info, false));
    }
}

