/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.views;

import java.util.List;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.ProbeAliasAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.ProbeParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.ProbeNodeData;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.ProbevarNodeData;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.BrowserView;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ProbeAliasBrowserView
extends BrowserView {
    public static final String ID = "org.eclipse.linuxtools.internal.systemtap.ui.ide.views.ProbeAliasBrowserView";

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProbeParser.getInstance().addListener(this.viewUpdater);
        this.refresh();
        this.makeActions();
    }

    @Override
    protected Image getEntryImage(TreeNode treeObj) {
        if (treeObj.getData() instanceof ProbevarNodeData) {
            List<String> varTypes = ((ProbevarNodeData)treeObj.getData()).getTypes();
            if (varTypes.get(varTypes.size() - 1).endsWith("*")) {
                return IDEPlugin.getImageDescriptor("icons/vars/var_long.gif").createImage();
            }
            if (varTypes.contains("struct")) {
                return IDEPlugin.getImageDescriptor("icons/vars/var_struct.gif").createImage();
            }
            if (varTypes.contains("string")) {
                return IDEPlugin.getImageDescriptor("icons/vars/var_str.gif").createImage();
            }
            if (varTypes.contains("unknown")) {
                return IDEPlugin.getImageDescriptor("icons/vars/var_unk.gif").createImage();
            }
            return IDEPlugin.getImageDescriptor("icons/vars/var_long.gif").createImage();
        }
        if (treeObj.getData() instanceof ProbeNodeData) {
            return IDEPlugin.getImageDescriptor("icons/misc/probe_obj.gif").createImage();
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    @Override
    public void refresh() {
        this.tree = TapsetLibrary.getProbes();
        if (this.tree != null) {
            this.viewer.setInput((Object)this.tree);
        }
    }

    private void makeActions() {
        this.doubleClickAction = new ProbeAliasAction(this.getSite().getWorkbenchWindow(), this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this.doubleClickAction);
        this.registerContextMenu("probePopup");
    }

    @Override
    public void dispose() {
        super.dispose();
        ProbeParser.getInstance().removeListener(this.viewUpdater);
    }
}

