/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.ui.module;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.linuxtools.tmf.analysis.xml.core.stateprovider.XmlStateSystemModule;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModule;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisRequirement;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class TmfAnalysisModuleHelperXml
implements IAnalysisModuleHelper {
    private final File fSourceFile;
    private final Element fSourceElement;
    private final XmlAnalysisModuleType fType;

    public TmfAnalysisModuleHelperXml(File xmlFile, Element node, XmlAnalysisModuleType type) {
        this.fSourceFile = xmlFile;
        this.fSourceElement = node;
        this.fType = type;
    }

    public String getId() {
        return this.fSourceElement.getAttribute("id");
    }

    public String getName() {
        List labels;
        String name = null;
        List head = XmlUtils.getChildElements((Element)this.fSourceElement, (String)"head");
        if (head.size() == 1 && !(labels = XmlUtils.getChildElements((Element)((Element)head.get(0)), (String)"label")).isEmpty()) {
            name = ((Element)labels.get(0)).getAttribute("value");
        }
        if (name == null) {
            name = this.getId();
        }
        return name;
    }

    public boolean isAutomatic() {
        return false;
    }

    public String getHelpText() {
        return new String();
    }

    public String getHelpText(@NonNull ITmfTrace trace) {
        return "";
    }

    public String getIcon() {
        return null;
    }

    public Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    public boolean appliesToTraceType(Class<? extends ITmfTrace> traceClass) {
        List head = XmlUtils.getChildElements((Element)this.fSourceElement, (String)"head");
        if (head.size() != 1) {
            return true;
        }
        List elements = XmlUtils.getChildElements((Element)((Element)head.get(0)), (String)"traceType");
        if (elements.isEmpty()) {
            return true;
        }
        for (Element element : elements) {
            String traceTypeId = element.getAttribute("id");
            TraceTypeHelper helper = TmfTraceType.getTraceType((String)traceTypeId);
            if (helper == null || !helper.getTrace().getClass().isAssignableFrom(traceClass)) continue;
            return true;
        }
        return false;
    }

    public Iterable<Class<? extends ITmfTrace>> getValidTraceTypes() {
        return Collections.EMPTY_SET;
    }

    public Iterable<TmfAnalysisRequirement> getAnalysisRequirements() {
        return Collections.EMPTY_SET;
    }

    public IAnalysisModule newModule(ITmfTrace trace) throws TmfAnalysisException {
        String analysisid = this.getId();
        XmlStateSystemModule module = null;
        switch (this.fType) {
            case STATE_SYSTEM: {
                XmlStateSystemModule ssModule = module = new XmlStateSystemModule();
                module.setId(analysisid);
                ssModule.setXmlFile((IPath)new Path(this.fSourceFile.getAbsolutePath()));
                ssModule.setAutomatic(true);
                break;
            }
        }
        if (module != null) {
            module.setTrace(trace);
            TmfAnalysisManager.analysisModuleCreated((IAnalysisModule)module);
        }
        return module;
    }

    public static enum XmlAnalysisModuleType {
        STATE_SYSTEM;

    }
}

