/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem.mipmap;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.mipmap.AvgMipmapFeature;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.mipmap.ITmfMipmapFeature;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.mipmap.MaxMipmapFeature;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.mipmap.MinMipmapFeature;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.mipmap.TmfMipmapFeature;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public abstract class AbstractTmfMipmapStateProvider
extends AbstractTmfStateProvider {
    public static final int MAX = 2;
    public static final int MIN = 4;
    public static final int AVG = 8;
    public static final String MAX_STRING = "max";
    public static final String MIN_STRING = "min";
    public static final String AVG_STRING = "avg";
    private Map<Integer, Set<ITmfMipmapFeature>> featureMap = new HashMap<Integer, Set<ITmfMipmapFeature>>();

    public AbstractTmfMipmapStateProvider(ITmfTrace trace, Class<? extends ITmfEvent> eventType, String id) {
        super(trace, eventType, id);
    }

    @Override
    public void dispose() {
        this.waitForEmptyQueue();
        for (Set<ITmfMipmapFeature> features : this.featureMap.values()) {
            for (ITmfMipmapFeature feature : features) {
                feature.updateAndCloseMipmap();
            }
        }
        super.dispose();
    }

    public void modifyMipmapAttribute(long ts, ITmfStateValue value, int baseQuark, int mipmapFeatureBits, int resolution) throws TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        this.ss.modifyAttribute(ts, value, baseQuark);
        if (value.getType() == ITmfStateValue.Type.LONG || value.getType() == ITmfStateValue.Type.INTEGER || value.getType() == ITmfStateValue.Type.DOUBLE || value.isNull()) {
            Set<ITmfMipmapFeature> features = this.getFeatureSet(baseQuark, ts, value, mipmapFeatureBits, resolution);
            for (ITmfMipmapFeature mf : features) {
                mf.updateMipmap(value, ts);
            }
        }
    }

    private Set<ITmfMipmapFeature> getFeatureSet(int baseQuark, long ts, ITmfStateValue value, int mipmapFeatureBits, int resolution) {
        Set<ITmfMipmapFeature> features = this.featureMap.get(baseQuark);
        if (features != null) {
            return features;
        }
        features = new LinkedHashSet<ITmfMipmapFeature>();
        if (value.isNull()) {
            return features;
        }
        this.featureMap.put(baseQuark, features);
        if (resolution > 1) {
            try {
                TmfMipmapFeature mf;
                int featureQuark;
                if ((mipmapFeatureBits & 2) != 0) {
                    featureQuark = this.ss.getQuarkRelativeAndAdd(baseQuark, new String[]{MAX_STRING});
                    this.ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueInt((int)0), featureQuark);
                    mf = new MaxMipmapFeature(baseQuark, featureQuark, resolution, this.ss);
                    features.add(mf);
                }
                if ((mipmapFeatureBits & 4) != 0) {
                    featureQuark = this.ss.getQuarkRelativeAndAdd(baseQuark, new String[]{MIN_STRING});
                    this.ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueInt((int)0), featureQuark);
                    mf = new MinMipmapFeature(baseQuark, featureQuark, resolution, this.ss);
                    features.add(mf);
                }
                if ((mipmapFeatureBits & 8) != 0) {
                    featureQuark = this.ss.getQuarkRelativeAndAdd(baseQuark, new String[]{AVG_STRING});
                    this.ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueInt((int)0), featureQuark);
                    mf = new AvgMipmapFeature(baseQuark, featureQuark, resolution, this.ss);
                    features.add(mf);
                }
            }
            catch (TimeRangeException e) {
                e.printStackTrace();
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
            catch (StateValueTypeException e) {
                e.printStackTrace();
            }
        }
        return features;
    }
}

