/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.parsers.custom;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEventType;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomEventContent;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class CustomEvent
extends TmfEvent {
    protected static final String TIMESTAMP_INPUT_FORMAT_KEY = "CE_TS_I_F";
    protected static final String NO_MESSAGE = "";
    private ITmfTimestamp customEventTimestamp;
    private ITmfEventField customEventContent;
    private ITmfEventType customEventType;
    protected CustomTraceDefinition fDefinition;
    protected Map<String, String> fData;
    private TmfEventField[] fColumnData;

    public CustomEvent(CustomTraceDefinition definition) {
        this.fDefinition = definition;
        this.fData = new HashMap<String, String>();
    }

    public CustomEvent(CustomTraceDefinition definition, TmfEvent other) {
        super(other);
        this.fDefinition = definition;
        this.fData = new HashMap<String, String>();
        this.customEventTimestamp = other.getTimestamp();
        this.customEventContent = other.getContent();
        this.customEventType = other.getType();
    }

    public CustomEvent(CustomTraceDefinition definition, ITmfTrace parentTrace, ITmfTimestamp timestamp, String source, TmfEventType type, String reference) {
        super(parentTrace, null, source, null, null, reference);
        this.fDefinition = definition;
        this.fData = new HashMap<String, String>();
        this.customEventTimestamp = timestamp;
        this.customEventContent = null;
        this.customEventType = type;
    }

    @Override
    public ITmfTimestamp getTimestamp() {
        if (this.fData != null) {
            this.processData();
        }
        return this.customEventTimestamp;
    }

    @Override
    public ITmfEventField getContent() {
        return this.customEventContent;
    }

    @Override
    public ITmfEventType getType() {
        return this.customEventType;
    }

    protected void setTimestamp(ITmfTimestamp timestamp) {
        this.customEventTimestamp = timestamp;
    }

    protected void setContent(ITmfEventField content) {
        this.customEventContent = content;
    }

    protected void setType(ITmfEventType type) {
        this.customEventType = type;
    }

    public String[] getEventStrings() {
        if (this.fData != null) {
            this.processData();
        }
        String[] entries = new String[this.fColumnData.length];
        int i = 0;
        while (i < this.fColumnData.length) {
            entries[i] = this.fColumnData[i].getValue().toString();
            ++i;
        }
        return entries;
    }

    private void processData() {
        String timestampString = this.fData.get(CustomTraceDefinition.TAG_TIMESTAMP);
        String timestampInputFormat = this.fData.get(TIMESTAMP_INPUT_FORMAT_KEY);
        TmfTimestamp timestamp = null;
        if (timestampInputFormat != null && timestampString != null) {
            TmfTimestampFormat timestampFormat = new TmfTimestampFormat(timestampInputFormat);
            try {
                long time = timestampFormat.parseValue(timestampString);
                timestamp = new TmfTimestamp(time, -9);
                this.setTimestamp(timestamp);
            }
            catch (ParseException e) {
                this.setTimestamp(TmfTimestamp.ZERO);
            }
        } else {
            this.setTimestamp(TmfTimestamp.ZERO);
        }
        int i = 0;
        this.fColumnData = new TmfEventField[this.fDefinition.outputs.size()];
        for (CustomTraceDefinition.OutputColumn outputColumn : this.fDefinition.outputs) {
            String value = this.fData.get(outputColumn.name);
            if (outputColumn.name.equals(CustomTraceDefinition.TAG_TIMESTAMP) && timestamp != null) {
                TmfTimestampFormat timestampFormat = new TmfTimestampFormat(this.fDefinition.timeStampOutputFormat);
                this.fColumnData[i++] = new TmfEventField(outputColumn.name, timestampFormat.format(timestamp.getValue()), null);
                continue;
            }
            this.fColumnData[i++] = new TmfEventField(outputColumn.name, value != null ? value : NO_MESSAGE, null);
        }
        CustomEventContent curContent = (CustomEventContent)this.getContent();
        this.setContent(new CustomEventContent(curContent.getName(), curContent.getValue(), this.fColumnData));
        this.fData = null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fDefinition == null ? 0 : this.fDefinition.hashCode());
        result = 31 * result + (this.customEventTimestamp == null ? 0 : this.customEventTimestamp.hashCode());
        result = 31 * result + (this.customEventContent == null ? 0 : this.customEventContent.hashCode());
        result = 31 * result + (this.customEventType == null ? 0 : this.customEventType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CustomEvent)) {
            return false;
        }
        CustomEvent other = (CustomEvent)obj;
        if (this.fDefinition == null ? other.fDefinition != null : !this.fDefinition.equals(other.fDefinition)) {
            return false;
        }
        if (this.customEventTimestamp == null ? other.customEventTimestamp != null : !this.customEventTimestamp.equals(other.customEventTimestamp)) {
            return false;
        }
        if (this.customEventContent == null ? other.customEventContent != null : !this.customEventContent.equals(other.customEventContent)) {
            return false;
        }
        return !(this.customEventType == null ? other.customEventType != null : !this.customEventType.equals(other.customEventType));
    }
}

