/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.synchronization;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.tmf.core.component.TmfComponent;
import org.eclipse.linuxtools.tmf.core.event.matching.TmfNetworkEventMatching;
import org.eclipse.linuxtools.tmf.core.synchronization.SyncAlgorithmFullyIncremental;
import org.eclipse.linuxtools.tmf.core.synchronization.SynchronizationAlgorithm;
import org.eclipse.linuxtools.tmf.core.synchronization.SynchronizationBackend;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public abstract class SynchronizationManager
extends TmfComponent {
    public static SynchronizationAlgorithm synchronizeTraces(File syncFile, Collection<ITmfTrace> traces, boolean doSync) {
        SynchronizationAlgorithm syncAlgo;
        if (doSync) {
            syncAlgo = SynchronizationManager.synchronize(syncFile, traces, new SyncAlgorithmFullyIncremental());
        } else {
            syncAlgo = SynchronizationManager.openExisting(syncFile);
            if (syncAlgo == null) {
                syncAlgo = new SyncAlgorithmFullyIncremental();
            }
        }
        return syncAlgo;
    }

    public static SynchronizationAlgorithm synchronizeTraces(File syncFile, Collection<ITmfTrace> traces, SynchronizationAlgorithm algo, boolean doSync) {
        SynchronizationAlgorithm syncAlgo;
        if (doSync) {
            syncAlgo = SynchronizationManager.synchronize(syncFile, traces, algo);
        } else {
            syncAlgo = SynchronizationManager.openExisting(syncFile);
            if (syncAlgo == null || syncAlgo.getClass() != algo.getClass()) {
                syncAlgo = algo != null ? algo : new SyncAlgorithmFullyIncremental();
            }
        }
        return syncAlgo;
    }

    private static SynchronizationAlgorithm openExisting(File syncFile) {
        if (syncFile != null && syncFile.exists()) {
            try {
                SynchronizationBackend syncBackend = new SynchronizationBackend(syncFile);
                SynchronizationAlgorithm algo = syncBackend.openExistingSync();
                return algo;
            }
            catch (IOException e) {
                Activator.logInfo("Problem opening existing trace synchronization file", e);
            }
        }
        return null;
    }

    private static SynchronizationAlgorithm synchronize(File syncFile, Collection<ITmfTrace> traces, SynchronizationAlgorithm syncAlgo) {
        TmfNetworkEventMatching matching = new TmfNetworkEventMatching(traces, syncAlgo);
        matching.matchEvents();
        try {
            SynchronizationBackend syncBackend = new SynchronizationBackend(syncFile, false);
            syncBackend.saveSync(syncAlgo);
        }
        catch (IOException e) {
            Activator.logError("Error while saving trace synchronization file", e);
        }
        return syncAlgo;
    }
}

