/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.timestamp;

import java.nio.ByteBuffer;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampDelta;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampFormat;

public class TmfTimestamp
implements ITmfTimestamp {
    public static final ITmfTimestamp BIG_BANG = new TmfTimestamp(Long.MIN_VALUE, Integer.MAX_VALUE, 0);
    public static final ITmfTimestamp BIG_CRUNCH = new TmfTimestamp(Long.MAX_VALUE, Integer.MAX_VALUE, 0);
    public static final ITmfTimestamp PROJECT_IS_FUNDED = BIG_BANG;
    public static final ITmfTimestamp PROJECT_IS_CANNED = BIG_CRUNCH;
    public static final ITmfTimestamp ZERO = new TmfTimestamp(0L, 0, 0);
    private final long fValue;
    private final int fScale;
    private final int fPrecision;
    private static final long[] scalingFactors = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public TmfTimestamp() {
        this(0L, 0, 0);
    }

    public TmfTimestamp(long value) {
        this(value, 0, 0);
    }

    public TmfTimestamp(long value, int scale) {
        this(value, scale, 0);
    }

    public TmfTimestamp(long value, int scale, int precision) {
        this.fValue = value;
        this.fScale = scale;
        this.fPrecision = Math.abs(precision);
    }

    public TmfTimestamp(ITmfTimestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        this.fValue = timestamp.getValue();
        this.fScale = timestamp.getScale();
        this.fPrecision = timestamp.getPrecision();
    }

    public TmfTimestamp(ITmfTimestamp timestamp, long newvalue) {
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        this.fValue = newvalue;
        this.fScale = timestamp.getScale();
        this.fPrecision = timestamp.getPrecision();
    }

    public TmfTimestamp(ByteBuffer bufferIn) {
        this(bufferIn.getLong(), bufferIn.getInt(), bufferIn.getInt());
    }

    @Override
    public long getValue() {
        return this.fValue;
    }

    @Override
    public int getScale() {
        return this.fScale;
    }

    @Override
    public int getPrecision() {
        return this.fPrecision;
    }

    @Override
    public ITmfTimestamp normalize(long offset, int scale) {
        long value = this.fValue;
        int precision = this.fPrecision;
        if (this.fScale == scale && offset == 0L) {
            return this;
        }
        if (this.equals(BIG_BANG) || this.equals(BIG_CRUNCH)) {
            return this;
        }
        if (this.fScale != scale) {
            int scaleDiff = Math.abs(this.fScale - scale);
            if (scaleDiff >= scalingFactors.length) {
                throw new ArithmeticException("Scaling exception");
            }
            long scalingFactor = scalingFactors[scaleDiff];
            if (scale < this.fScale) {
                value *= scalingFactor;
                precision = (int)((long)precision * scalingFactor);
            } else {
                value /= scalingFactor;
                precision = (int)((long)precision / scalingFactor);
            }
        }
        value = offset < 0L ? (value < Long.MIN_VALUE - offset ? Long.MIN_VALUE : value + offset) : (value > Long.MAX_VALUE - offset ? Long.MAX_VALUE : value + offset);
        return new TmfTimestamp(value, scale, precision);
    }

    @Override
    public int compareTo(ITmfTimestamp ts, boolean withinPrecision) {
        long delta;
        block10: {
            if (ts == null) {
                return 1;
            }
            if (this == ts || this.fValue == ts.getValue() && this.fScale == ts.getScale()) {
                return 0;
            }
            if (this.fValue == BIG_BANG.getValue() && this.fScale == BIG_BANG.getScale() || ts.getValue() == BIG_CRUNCH.getValue() && ts.getScale() == BIG_CRUNCH.getScale()) {
                return -1;
            }
            if (this.fValue == BIG_CRUNCH.getValue() && this.fScale == BIG_CRUNCH.getScale() || ts.getValue() == BIG_BANG.getValue() && ts.getScale() == BIG_BANG.getScale()) {
                return 1;
            }
            try {
                ITmfTimestamp nts = ts.normalize(0L, this.fScale);
                delta = this.fValue - nts.getValue();
                if (delta != 0L && (!withinPrecision || Math.abs(delta) > (long)(this.fPrecision + nts.getPrecision()))) break block10;
                return 0;
            }
            catch (ArithmeticException e) {
                long value = ts.getValue();
                if (this.fValue == 0L && value == 0L) {
                    return 0;
                }
                if (this.fValue < 0L && value >= 0L) {
                    return -1;
                }
                if (this.fValue >= 0L && value < 0L) {
                    return 1;
                }
                int scale = ts.getScale();
                return this.fScale > scale ? (this.fValue >= 0L ? 1 : -1) : (this.fValue >= 0L ? -1 : 1);
            }
        }
        return delta > 0L ? 1 : -1;
    }

    @Override
    public ITmfTimestamp getDelta(ITmfTimestamp ts) {
        ITmfTimestamp nts = ts.normalize(0L, this.fScale);
        long value = this.fValue - nts.getValue();
        return new TmfTimestampDelta(value, this.fScale, this.fPrecision + nts.getPrecision());
    }

    @Override
    public boolean intersects(TmfTimeRange range) {
        return this.compareTo(range.getStartTime()) >= 0 && this.compareTo(range.getEndTime()) <= 0;
    }

    @Override
    public int compareTo(ITmfTimestamp ts) {
        return this.compareTo(ts, false);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.fValue ^ this.fValue >>> 32);
        result = 31 * result + this.fScale;
        result = 31 * result + this.fPrecision;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TmfTimestamp)) {
            return false;
        }
        TmfTimestamp ts = (TmfTimestamp)other;
        return this.compareTo(ts, false) == 0;
    }

    public String toString() {
        return this.toString(TmfTimestampFormat.getDefaulTimeFormat());
    }

    @Override
    public String toString(TmfTimestampFormat format) {
        try {
            ITmfTimestamp ts = this.normalize(0L, -9);
            return format.format(ts.getValue());
        }
        catch (ArithmeticException e) {
            return format.format(0L);
        }
    }

    public void serialize(ByteBuffer bufferOut) {
        bufferOut.putLong(this.fValue);
        bufferOut.putInt(this.fScale);
        bufferOut.putInt(this.fPrecision);
    }
}

