/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.m2e.editor.xml.PomTemplateContext;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertExpressionProposal
implements ICompletionProposal,
ICompletionProposalExtension5 {
    private static final Logger log = LoggerFactory.getLogger(InsertExpressionProposal.class);
    private MavenProject project;
    private String key;
    private Region region;
    private int len = 0;

    public InsertExpressionProposal(Region region, String key, MavenProject mvnproject) {
        assert (this.project != null);
        this.region = region;
        this.key = key;
        this.project = mvnproject;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        InputSource source;
        InputLocation location;
        Model mdl;
        if (this.project == null) {
            return null;
        }
        String value = PomTemplateContext.simpleInterpolate(this.project, "${" + this.key + "}");
        MavenProject mavprj = this.project;
        String loc = null;
        if (mavprj != null && (mdl = mavprj.getModel()).getProperties() != null && mdl.getProperties().containsKey(this.key) && mdl.getLocation((Object)"properties") != null && (location = mdl.getLocation((Object)"properties").getLocation((Object)this.key)) != null && (source = location.getSource()) != null) {
            loc = source.getModelId();
        }
        StringBuffer buff = new StringBuffer();
        buff.append("<html>");
        if (value != null) {
            buff.append(NLS.bind((String)Messages.InsertExpressionProposal_hint1, (Object)value));
        }
        if (loc != null) {
            buff.append(NLS.bind((String)Messages.InsertExpressionProposal_hint2, loc));
        }
        buff.append("</html>");
        return buff.toString();
    }

    public void apply(IDocument document) {
        int offset = this.region.getOffset();
        String replace = "${" + this.key + "}";
        try {
            document.replace(offset, this.region.getLength(), replace);
            this.len = replace.length();
        }
        catch (BadLocationException e) {
            log.error("Cannot apply proposal", (Throwable)e);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.region.getOffset() + this.len, 0);
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return "${" + this.key + "}";
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

