/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.inspections.collections.ICollectionExtractor;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="hash_set_values")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
public class HashSetValuesQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IObject hashSet;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String array_attribute;
    @Argument(isMandatory=false)
    public String key_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        int tableObjectId;
        IInstance map;
        CollectionUtil.Info info = null;
        if (this.collection != null && this.hashSet.getClazz().doesExtend(this.collection)) {
            if (this.array_attribute == null || this.key_attribute == null) {
                String msg = Messages.HashSetValuesQuery_ErrorMsg_MissingArgument;
                throw new SnapshotException(msg);
            }
            info = new CollectionUtil.Info(this.collection, null, this.array_attribute, this.key_attribute, null);
        } else {
            info = CollectionUtil.getInfo(this.hashSet);
            if (info == null || !info.isMap() || !info.getClassName().contains("Set")) {
                throw new IllegalArgumentException(MessageUtil.format((String)Messages.HashSetValuesQuery_ErrorMsg_NotAHashSet, (Object[])new Object[]{this.hashSet.getDisplayName()}));
            }
        }
        ArrayInt hashEntries = new ArrayInt();
        String arrayField = info.getBackingArrayField();
        if (arrayField == null) {
            ICollectionExtractor ex = info.getCollectionExtractor();
            if (ex != null) {
                int[] entries = ex.extractEntries(this.hashSet.getObjectId(), info, this.snapshot, listener);
                String valueField = info.getEntryKeyField();
                if (valueField != null) {
                    ArrayInt ret = new ArrayInt();
                    if (valueField.endsWith("[]")) {
                        valueField = valueField.replaceFirst("\\[\\]$", "");
                        int[] nArray = entries;
                        int n = entries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int entryId = nArray[n2];
                            IInstance entry = (IInstance)this.snapshot.getObject(entryId);
                            Object f = entry.resolveValue(valueField);
                            if (f instanceof IObjectArray) {
                                IObjectArray valarr = (IObjectArray)f;
                                int n3 = valarr.getLength();
                                int s = 10;
                                int i = 0;
                                while (i < n3) {
                                    s = Math.min(s, n3 - i);
                                    long[] b = valarr.getReferenceArray(i, s);
                                    int j = 0;
                                    while (j < s) {
                                        if (b[j] != 0L) {
                                            int valueId = this.snapshot.mapAddressToId(b[j]);
                                            ret.add(valueId);
                                        }
                                        ++j;
                                    }
                                    i += s;
                                }
                            }
                            ++n2;
                        }
                    } else {
                        int[] nArray = entries;
                        int n = entries.length;
                        int n4 = 0;
                        while (n4 < n) {
                            int entryId = nArray[n4];
                            IInstance entry = (IInstance)this.snapshot.getObject(entryId);
                            Object f = entry.resolveValue(valueField);
                            if (f instanceof IInstance) {
                                ret.add(((IInstance)f).getObjectId());
                            }
                            ++n4;
                        }
                    }
                    entries = ret.toArray();
                }
                return new ObjectListResult.Outbound(this.snapshot, entries);
            }
            return null;
        }
        int p = arrayField.lastIndexOf(46);
        IInstance iInstance = map = p < 0 ? (IInstance)this.hashSet : (IInstance)this.hashSet.resolveValue(arrayField.substring(0, p));
        if (map != null) {
            Field table = map.getField(p < 0 ? arrayField : arrayField.substring(p + 1));
            if (table == null) {
                return null;
            }
            Object tableValue = table.getValue();
            if (tableValue == null) {
                return null;
            }
            tableObjectId = ((ObjectReference)tableValue).getObjectId();
        } else {
            IObjectArray back = info.getBackingArray(this.hashSet);
            if (back == null) {
                return null;
            }
            tableObjectId = back.getObjectId();
        }
        BitField seen = new BitField(this.snapshot.getSnapshotInfo().getNumberOfObjects());
        ArrayInt extra = new ArrayInt();
        int[] outbounds = this.snapshot.getOutboundReferentIds(tableObjectId);
        int ii = 0;
        while (ii < outbounds.length && !listener.isCanceled()) {
            this.collectEntry(hashEntries, outbounds[ii], seen, extra, info, listener);
            ++ii;
        }
        return new ObjectListResult.Outbound(this.snapshot, hashEntries.toArray());
    }

    private void collectEntry(ArrayInt hashEntries, int entryId, BitField seen, ArrayInt extra, CollectionUtil.Info info, IProgressListener listener) throws SnapshotException {
        if (seen.get(entryId)) {
            return;
        }
        extra.clear();
        extra.add(entryId);
        seen.set(entryId);
        int k = 0;
        block0: while (k < extra.size()) {
            entryId = extra.get(k);
            while (entryId >= 0) {
                Field key;
                if (this.snapshot.isClass(entryId)) break;
                IInstance entry = (IInstance)this.snapshot.getObject(entryId);
                entryId = -1;
                Field next = entry.getField("next");
                if (next != null) {
                    if (next.getValue() != null) {
                        entryId = ((ObjectReference)next.getValue()).getObjectId();
                        seen.set(entryId);
                    }
                } else {
                    entryId = info.resolveNextSameField(this.snapshot, entry.getObjectId(), seen, extra);
                }
                if ((key = entry.getField(info.getEntryKeyField())) != null) {
                    hashEntries.add(((ObjectReference)key.getValue()).getObjectId());
                } else {
                    int[] nArray = this.snapshot.getOutboundReferentIds(entry.getObjectId());
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i = nArray[n2];
                        if (i != entryId && i != entry.getClazz().getObjectId() && i != this.hashSet.getObjectId() && !seen.get(i)) {
                            hashEntries.add(i);
                            seen.set(i);
                        }
                        ++n2;
                    }
                }
                if (listener.isCanceled()) break block0;
            }
            ++k;
        }
    }
}

