/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.ibmvm.acquire.IBMDumpProvider;
import org.eclipse.mat.ibmvm.acquire.Messages;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IBMSystemDumpProvider
extends IBMDumpProvider {
    IBMSystemDumpProvider() {
    }

    String dumpName() {
        return "core.YYmmdd.HHMMSS.%pid%.seq.dmp";
    }

    int files() {
        return 1;
    }

    long averageFileSize(Collection<File> files) {
        long l = 0L;
        int i = 0;
        for (File f : files) {
            if (!f.isFile() || !f.getName().endsWith(".dmp")) continue;
            l += f.length();
            ++i;
        }
        if (i > 0) {
            return l / (long)i;
        }
        return 100000000L;
    }

    File jextract(File preferredDump, boolean compress, List<File> dumps, File udir, File home, IProgressListener listener) throws IOException, InterruptedException, SnapshotException {
        Process p;
        int exitCode;
        StringBuilder errorBuf;
        File result;
        File jextract;
        boolean zip;
        File dump;
        block19: {
            dump = dumps.get(0);
            String encoding = System.getProperty("file.encoding", "UTF-8");
            String encodingOpt = "-J-Dfile.encoding=" + encoding;
            preferredDump = this.mergeFileNames(preferredDump, dump);
            if (compress && !preferredDump.getName().endsWith(".zip")) {
                preferredDump = new File(String.valueOf(preferredDump.getPath()) + ".zip");
            }
            listener.beginTask(MessageFormat.format(Messages.getString("IBMSystemDumpProvider.FormattingDump"), dump, preferredDump), -1);
            zip = preferredDump.getName().endsWith(".zip");
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            if (home != null) {
                File homebin = new File(home, "bin");
                jextract = new File(homebin, "jextract");
            } else {
                jextract = new File("jextract");
            }
            if (zip) {
                pb.command(jextract.getAbsolutePath(), encodingOpt, dump.getAbsolutePath(), preferredDump.getAbsolutePath());
                result = preferredDump;
            } else {
                if (dump.renameTo(preferredDump)) {
                    dump = preferredDump;
                }
                String metafileName = String.valueOf(dump.getAbsolutePath()) + ".xml";
                result = dump.getName().endsWith(".dmp") ? dump : new File(metafileName);
                pb.command(jextract.getAbsolutePath(), encodingOpt, dump.getAbsolutePath(), "-nozip", metafileName);
            }
            pb.redirectErrorStream(true);
            pb.directory(udir);
            errorBuf = new StringBuilder();
            exitCode = 0;
            p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream(), encoding));
            while (true) {
                while (br.ready()) {
                    int t = br.read();
                    if (t < 0) break;
                    if (t == 46) {
                        listener.worked(1);
                    }
                    errorBuf.append((char)t);
                }
                listener.subTask("\n" + errorBuf.toString());
                if (listener.isCanceled()) {
                    p.destroy();
                    return null;
                }
                try {
                    p.exitValue();
                    break block19;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
            finally {
                br.close();
            }
        }
        exitCode = p.waitFor();
        if (exitCode != 0) {
            throw new SnapshotException(MessageFormat.format(Messages.getString("IBMSystemDumpProvider.ReturnCode"), jextract.getAbsolutePath(), exitCode, errorBuf.toString()));
        }
        if (!result.canRead()) {
            throw new FileNotFoundException(MessageFormat.format(Messages.getString("IBMSystemDumpProvider.ReturnCode"), result.getPath(), errorBuf.toString()));
        }
        if (zip) {
            dump.delete();
        }
        listener.done();
        return result;
    }
}

