/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.refined;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.report.internal.ReportPlugin;
import org.eclipse.mat.util.MessageUtil;
import org.osgi.framework.Bundle;

public class TotalsRow {
    private static final URL SUM = FileLocator.find((Bundle)ReportPlugin.getDefault().getBundle(), (IPath)new Path("$nl$/META-INF/icons/misc/sum.gif"), null);
    private static final URL SUM_PLUS = FileLocator.find((Bundle)ReportPlugin.getDefault().getBundle(), (IPath)new Path("$nl$/META-INF/icons/misc/sum_plus.gif"), null);
    private static final NumberFormat fmt = DecimalFormat.getInstance();
    private Double[] totals;
    private int filteredItems;
    private int numberOfItems;
    private int visibleItems;

    public int getVisibleItems() {
        return this.visibleItems;
    }

    public void setVisibleItems(int visibleItems) {
        this.visibleItems = visibleItems;
    }

    public int getFilteredItems() {
        return this.filteredItems;
    }

    void setFilteredItems(int filteredItems) {
        this.filteredItems = filteredItems;
    }

    public int getNumberOfItems() {
        return this.numberOfItems;
    }

    void setNumberOfItems(int numberOfItems) {
        this.numberOfItems = numberOfItems;
    }

    void setTotals(Double[] totals) {
        this.totals = totals;
    }

    public URL getIcon() {
        URL url = this.visibleItems < this.numberOfItems ? SUM_PLUS : SUM;
        return url;
    }

    public boolean isVisible() {
        return this.numberOfItems > 1 || this.filteredItems > 0 || this.visibleItems < this.numberOfItems;
    }

    public String getLabel(int columnIndex) {
        if (columnIndex == 0) {
            return this.getFirstItemText();
        }
        if (this.totals == null) {
            return "";
        }
        if (columnIndex < 1 || columnIndex >= this.totals.length) {
            return "";
        }
        if (this.totals[columnIndex] == null) {
            return "";
        }
        return fmt.format(this.totals[columnIndex].doubleValue());
    }

    private String getFirstItemText() {
        boolean hasMore = this.numberOfItems > this.visibleItems;
        boolean hasTotals = this.totals != null && this.totals[0] != null;
        boolean hasFiltered = this.filteredItems > 0;
        String msg = null;
        msg = hasMore ? MessageUtil.format(Messages.TotalsRow_Label_TotalVisible, this.visibleItems, this.numberOfItems, this.numberOfItems - this.visibleItems) : MessageUtil.format(Messages.TotalsRow_Label_Total, this.numberOfItems);
        if (hasTotals) {
            msg = String.valueOf(msg) + " / " + fmt.format(this.totals[0].doubleValue());
        }
        if (hasFiltered) {
            msg = String.valueOf(msg) + MessageUtil.format(" " + Messages.TotalsRow_Label_Filtered, this.filteredItems);
        }
        return msg;
    }
}

