/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.internal.io.java;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.modisco.java.discoverer.internal.IModelReader;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;
import org.eclipse.modisco.java.discoverer.internal.Messages;
import org.eclipse.modisco.java.discoverer.internal.io.java.JDTVisitor;
import org.eclipse.modisco.java.discoverer.internal.io.java.JDTVisitorUtils;
import org.eclipse.modisco.java.discoverer.internal.io.java.MethodRedefinitionManager;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.BindingManager;
import org.eclipse.modisco.java.discoverer.internal.io.library.LibraryReader;
import org.eclipse.modisco.kdm.source.extension.discovery.ISourceRegionNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaReader
implements IModelReader {
    private static final int FILE_BUFFER_SIZE = 100;
    private boolean incremental = false;
    private boolean deepAnalysis = true;
    private final JavaFactory factory;
    private Model resultModel;
    private BindingManager globalBindings;
    private Map<String, Object> options;
    private String excludedElementsRegEx;
    private String includedElementsRegEx;
    private ISourceRegionNotifier<?> abstractRegionDiscoverer;
    private boolean logJavaAnalysisWarnings;

    public JavaReader(JavaFactory factory, Map<String, Object> options, ISourceRegionNotifier<?> abstractRegionDiscoverer) {
        this.factory = factory;
        this.abstractRegionDiscoverer = abstractRegionDiscoverer;
        if (options != null) {
            this.setOptions(options);
        } else {
            this.setOptions(new HashMap<String, Object>());
        }
    }

    public void setDeepAnalysis(boolean deepAnalysis) {
        this.deepAnalysis = deepAnalysis;
    }

    public boolean isDeepAnalysis() {
        return this.deepAnalysis;
    }

    public void setIncludedElementsRegEx(String includedElementsRegEx) {
        this.includedElementsRegEx = includedElementsRegEx;
    }

    public String getIncludedElementsRegEx() {
        return this.includedElementsRegEx;
    }

    public void setExcludedElementsRegEx(String excludedElementsRegEx) {
        this.excludedElementsRegEx = excludedElementsRegEx;
    }

    public String getExcludedElementsRegEx() {
        return this.excludedElementsRegEx;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    @Override
    public void readModel(Object source, Model resultModel1, IProgressMonitor monitor) {
        this.readModel(source, resultModel1, this.getBindingManager(), monitor);
    }

    @Override
    public void readModel(Object source, Model resultModel1, BindingManager bindingManager, IProgressMonitor monitor) {
        block11: {
            if (source == null) {
                return;
            }
            this.setResultModel(resultModel1);
            this.setGlobalBindings(bindingManager);
            if (this.incremental) {
                this.getGlobalBindings().enableIncrementalDiscovering(this.getResultModel());
            } else {
                this.getGlobalBindings().disableIncrementalDiscovering();
            }
            JDTVisitorUtils.initializePrimitiveTypes(this.factory, resultModel1, this.getGlobalBindings());
            try {
                if (source instanceof IJavaProject) {
                    IPackageFragment[] packageFolder;
                    IJavaProject javaProject = (IJavaProject)source;
                    if (resultModel1.getName() == null || resultModel1.getName().length() == 0) {
                        resultModel1.setName(javaProject.getElementName());
                    }
                    IPackageFragment[] iPackageFragmentArray = packageFolder = javaProject.getPackageFragments();
                    int n = packageFolder.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragment parent = iPackageFragmentArray[n2];
                        if (parent.getCompilationUnits().length > 0 && !this.ignorePackage(parent)) {
                            monitor.subTask(String.valueOf(Messages.JavaReader_discoveringTask) + parent.getElementName());
                            this.parsePackage(javaProject, resultModel1, parent, monitor);
                        }
                        if (monitor.isCanceled()) {
                            return;
                        }
                        ++n2;
                    }
                    break block11;
                }
                if (source instanceof ITypeRoot) {
                    this.parseTypeRoot((ITypeRoot)source);
                    break block11;
                }
                throw new IllegalArgumentException("Java reader can not handle source object : " + source.toString());
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
        }
    }

    protected boolean isElementExcluded(String qualifiedName) {
        if (this.excludedElementsRegEx != null && this.excludedElementsRegEx.length() > 0) {
            return qualifiedName.matches(this.excludedElementsRegEx);
        }
        return false;
    }

    protected boolean isElementIncluded(String qualifiedName) {
        if (this.includedElementsRegEx != null && this.includedElementsRegEx.length() > 0) {
            return qualifiedName.matches(this.includedElementsRegEx);
        }
        return true;
    }

    protected boolean ignorePackage(IPackageFragment aPackage) throws JavaModelException {
        if (this.isElementExcluded(aPackage.getElementName())) {
            return true;
        }
        if (this.isElementIncluded(aPackage.getElementName())) {
            return false;
        }
        boolean noSubElementToAnalyse = true;
        ICompilationUnit[] iCompilationUnitArray = aPackage.getCompilationUnits();
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            IType[] iTypeArray = cu.getTypes();
            int n3 = iTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IType t = iTypeArray[n4];
                String qualifedName = t.getFullyQualifiedName();
                if (!this.isElementExcluded(qualifedName) && this.isElementIncluded(qualifedName)) {
                    noSubElementToAnalyse = false;
                }
                ++n4;
            }
            ++n2;
        }
        return noSubElementToAnalyse;
    }

    protected void parseTypeRoot(ITypeRoot source) {
        CompilationUnit parsedCompilationUnit = JavaReader.parseCompilationUnit(source);
        String fileContent = null;
        String filePath = null;
        try {
            if (source instanceof ICompilationUnit) {
                IFile theIFile = ResourcesPlugin.getWorkspace().getRoot().getFile(parsedCompilationUnit.getJavaElement().getPath());
                fileContent = JavaReader.getContent(theIFile).toString();
                IProject project = source.getJavaProject().getProject();
                filePath = JavaReader.getRelativePath(project, parsedCompilationUnit);
            } else {
                fileContent = LibraryReader.getFileContent((IClassFile)source);
                filePath = LibraryReader.getPath((IClassFile)source);
            }
            this.visitCompilationUnit(this.getResultModel(), parsedCompilationUnit, filePath, fileContent);
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
        }
    }

    protected void parsePackage(IJavaProject javaProject, Model resultModel1, IPackageFragment parent, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit[] children;
        boolean analyseAllPackage = !this.isElementExcluded(parent.getElementName()) && this.isElementIncluded(parent.getElementName());
        ICompilationUnit[] iCompilationUnitArray = children = parent.getCompilationUnits();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            boolean isExcluded = false;
            IType[] iTypeArray = cu.getTypes();
            int n3 = iTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IType t = iTypeArray[n4];
                if (this.isElementExcluded(t.getFullyQualifiedName()) || !analyseAllPackage && !this.isElementIncluded(t.getFullyQualifiedName())) {
                    isExcluded = true;
                    break;
                }
                ++n4;
            }
            if (!isExcluded) {
                this.parseTypeRoot((ITypeRoot)cu);
            }
            if (monitor.isCanceled()) {
                return;
            }
            ++n2;
        }
        if (this.incremental) {
            this.reset();
        }
    }

    protected void visitCompilationUnit(Model resultModel1, CompilationUnit parsedCompilationUnit, String filePath, String fileContent) {
        JDTVisitor jdtVisitor = new JDTVisitor(this.factory, resultModel1, this.getGlobalBindings(), filePath, fileContent, this.getGlobalBindings().isIncrementalDiscovering(), this.deepAnalysis, this.logJavaAnalysisWarnings);
        parsedCompilationUnit.accept((ASTVisitor)jdtVisitor);
        if (this.abstractRegionDiscoverer != null) {
            for (ASTNode key : jdtVisitor.getBijectiveMap().getKeys()) {
                int startPosition = key.getStartPosition();
                int endPosition = startPosition + key.getLength();
                int startLine = parsedCompilationUnit.getLineNumber(startPosition);
                int endLine = parsedCompilationUnit.getLineNumber(endPosition);
                this.abstractRegionDiscoverer.notifySourceRegionVisited(filePath, startPosition, endPosition, startLine, endLine, (EObject)jdtVisitor.getBijectiveMap().getValue(key));
            }
        }
    }

    protected static CompilationUnit parseCompilationUnit(ITypeRoot source) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(source);
        CompilationUnit parsedCompilationUnit = (CompilationUnit)parser.createAST(null);
        return parsedCompilationUnit;
    }

    protected void resolveMethodRedefinition(Model resultModel1) {
        MethodRedefinitionManager.resolveMethodRedefinitions(resultModel1, this.factory);
    }

    protected void finalResolveBindings(Model resultModel1) {
        this.getGlobalBindings().resolveBindings(resultModel1);
    }

    public static String getRelativePath(IProject aProject, CompilationUnit parsedCompilationUnit) {
        String filePathString;
        IPath filepath;
        IPath projectpath = aProject.getFullPath();
        if (projectpath.isPrefixOf(filepath = parsedCompilationUnit.getJavaElement().getPath())) {
            filepath = filepath.removeFirstSegments(projectpath.segmentCount());
        }
        if (!(filePathString = filepath.toOSString()).startsWith(File.separator)) {
            filePathString = String.valueOf(File.separator) + filePathString;
        }
        return filePathString;
    }

    public static StringBuilder getContent(IFile anIFile) throws CoreException, IOException {
        int read;
        InputStream is = anIFile.getContents();
        StringBuilder cuText = new StringBuilder();
        InputStreamReader r = new InputStreamReader(is);
        char[] chars = new char[100];
        while ((read = r.read(chars)) != -1) {
            if (read == 100) {
                cuText.append(chars);
                continue;
            }
            cuText.append(chars, 0, read);
        }
        is.close();
        return cuText;
    }

    protected void reset() {
        this.getGlobalBindings().resolveBindings(this.getResultModel());
        this.setGlobalBindings(this.getBindingManager());
    }

    protected BindingManager getBindingManager() {
        BindingManager bindingManager = new BindingManager(this.factory);
        if (this.incremental) {
            bindingManager.enableIncrementalDiscovering(this.getResultModel());
        }
        return bindingManager;
    }

    @Override
    public void terminate(IProgressMonitor monitor) {
        monitor.subTask(Messages.JavaReader_bindingsTask);
        this.finalResolveBindings(this.getResultModel());
        monitor.subTask(Messages.JavaReader_redefinitionsTask);
        this.resolveMethodRedefinition(this.getResultModel());
    }

    protected void setResultModel(Model resultModel) {
        this.resultModel = resultModel;
    }

    public Model getResultModel() {
        return this.resultModel;
    }

    public void setGlobalBindings(BindingManager globalBindings) {
        this.globalBindings = globalBindings;
    }

    public BindingManager getGlobalBindings() {
        return this.globalBindings;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setAbstractRegionDiscoverer(ISourceRegionNotifier<?> abstractRegionDiscoverer) {
        this.abstractRegionDiscoverer = abstractRegionDiscoverer;
    }
}

