/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.ReviewerResult;
import com.google.gerrit.reviewdb.PatchLineComment;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.Messages;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbandonRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.AddReviewersRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.core.operations.PublishRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.RebaseRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.RefreshConfigRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.RestoreRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.SaveDraftRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.SubmitRequest;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class GerritOperationFactory {
    private final IRepositoryManager repositoryManager;

    public GerritOperationFactory(IRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public GerritOperation<PatchLineComment> createSaveDraftOperation(ITask review, SaveDraftRequest request) {
        return new GerritOperation<PatchLineComment>(Messages.GerritOperationFactory_Saving_Draft, this.getClient(review), request);
    }

    public GerritOperation<ChangeDetail> createAbandonOperation(ITask review, AbandonRequest request) {
        return new GerritOperation<ChangeDetail>(Messages.GerritOperationFactory_Abandoning_Change, this.getClient(review), request);
    }

    public GerritOperation<ReviewerResult> createAddReviewersOperation(ITask review, AddReviewersRequest request) {
        return new GerritOperation<ReviewerResult>(Messages.GerritOperationFactory_Adding_Reviewers, this.getClient(review), request);
    }

    public GerritOperation<Object> createPublishOperation(ITask review, PublishRequest request) {
        return new GerritOperation<Object>(Messages.GerritOperationFactory_Publishing_Change, this.getClient(review), request);
    }

    public GerritOperation<GerritConfiguration> createRefreshConfigOperation(ITask review, RefreshConfigRequest request) {
        return new GerritOperation<GerritConfiguration>(Messages.GerritOperationFactory_Refreshing_Configuration, this.getClient(review), request);
    }

    public GerritOperation<ChangeDetail> createRebaseOperation(ITask review, RebaseRequest request) {
        return new GerritOperation<ChangeDetail>(Messages.GerritOperationFactory_Rebasing_Change, this.getClient(review), request);
    }

    public GerritOperation<ChangeDetail> createRestoreOperation(ITask review, RestoreRequest request) {
        return new GerritOperation<ChangeDetail>(Messages.GerritOperationFactory_Restoring_Change, this.getClient(review), request);
    }

    public GerritOperation<ChangeDetail> createSubmitOperation(ITask review, SubmitRequest request) {
        return new GerritOperation<ChangeDetail>(Messages.GerritOperationFactory_Submitting_Change, this.getClient(review), request);
    }

    public GerritClient getClient(ITask review) {
        TaskRepository repository = this.repositoryManager.getRepository(review.getConnectorKind(), review.getRepositoryUrl());
        GerritConnector connector = (GerritConnector)this.repositoryManager.getRepositoryConnector(repository.getConnectorKind());
        GerritClient client = connector.getClient(repository);
        return client;
    }
}

