/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki.core;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.osgi.OsgiServiceLocator;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.DocBookDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.RecordingDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.Template;
import org.eclipse.mylyn.wikitext.tests.TestUtil;

public class MediaWikiLanguageTest
extends TestCase {
    private MarkupParser parser;
    private MediaWikiLanguage markupLanguage;
    private Locale locale;

    public void setUp() {
        this.locale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        this.markupLanguage = new MediaWikiLanguage();
        this.parser = new MarkupParser((MarkupLanguage)this.markupLanguage);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        Locale.setDefault(this.locale);
    }

    public void testDiscoverable() {
        MarkupLanguage language = OsgiServiceLocator.getApplicableInstance().getMarkupLanguage("MediaWiki");
        MediaWikiLanguageTest.assertNotNull((Object)language);
        MediaWikiLanguageTest.assertTrue((boolean)(language instanceof MediaWikiLanguage));
    }

    public void testIsDetectingRawHyperlinks() {
        MediaWikiLanguageTest.assertTrue((boolean)this.getMarkupLanguage().isDetectingRawHyperlinks());
    }

    protected MediaWikiLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void testParagraph() {
        String html = this.parser.parseToHtml("first para<br/>\nfirst para line2\n\nsecond para\n\nthird para");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>first para<br/>\\s*first para line2</p><p>second para</p><p>third para</p></body>").matcher(html).find());
    }

    public void testNowiki() {
        String html = this.parser.parseToHtml("'''<nowiki>no <!-- markup here</nowiki>'''");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p><b>no &lt;!-- markup here</b></p></body>").matcher(html).find());
    }

    public void testNoWiki_325022() {
        String html = this.parser.parseToHtml("//<nowiki>[</nowiki>username<nowiki>[</nowiki>:password]@]host<nowiki>[</nowiki>:port]");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<p>//[username[:password]@]host[:port]</p>"));
    }

    public void testBoldItalic() {
        String html = this.parser.parseToHtml("normal '''''bold italic text''''' normal");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <b><i>bold italic text</i></b> normal</p></body>").matcher(html).find());
    }

    public void testBold() {
        String html = this.parser.parseToHtml("normal '''bold text''' normal");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <b>bold text</b> normal</p></body>").matcher(html).find());
    }

    public void testBoldImmediatelyFollowingTag() {
        String html = this.parser.parseToHtml("normal<br>'''bold text''' normal");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal<br/><b>bold text</b> normal</p></body>").matcher(html).find());
    }

    public void testBold_single_character_bug369921() {
        String html = this.parser.parseToHtml("'''aa''' bb '''cc'''");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p><b>aa</b> bb <b>cc</b></p></body>").matcher(html).find());
        html = this.parser.parseToHtml("'''a''' b '''c'''");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p><b>a</b> b <b>c</b></p></body>").matcher(html).find());
    }

    public void testBold_adjacentText_bug369921() {
        String html = this.parser.parseToHtml("'''aa'''bb");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p><b>aa</b>bb</p></body>").matcher(html).find());
    }

    public void testBoldWithWhitespace() {
        String html = this.parser.parseToHtml("normal ''' bold text''' normal");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>normal <b> bold text</b> normal</p></body>"));
        html = this.parser.parseToHtml("normal '''bold text ''' normal");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>normal <b>bold text </b> normal</p></body>"));
        html = this.parser.parseToHtml("normal ''' bold text ''' normal");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>normal <b> bold text </b> normal</p></body>"));
    }

    public void testItalic() {
        String html = this.parser.parseToHtml("normal ''italic text'' normal");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <i>italic text</i> normal</p></body>").matcher(html).find());
    }

    public void testItalicWithWhitespace() {
        String html = this.parser.parseToHtml("normal '' italic text'' normal");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>normal <i> italic text</i> normal</p></body>"));
        html = this.parser.parseToHtml("normal ''italic text '' normal");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>normal <i>italic text </i> normal</p></body>"));
        html = this.parser.parseToHtml("normal '' italic text '' normal");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>normal <i> italic text </i> normal</p></body>"));
    }

    public void testHeadings() {
        int x = 1;
        while (x <= 6) {
            String[] headingMarkupSamples;
            String delimiter = this.repeat(x, "=");
            String[] stringArray = headingMarkupSamples = new String[]{String.valueOf(delimiter) + "heading text" + delimiter, String.valueOf(delimiter) + "heading text" + delimiter + "  ", String.valueOf(delimiter) + "heading text" + delimiter + " \t "};
            int n = headingMarkupSamples.length;
            int n2 = 0;
            while (n2 < n) {
                String headingMarkup = stringArray[n2];
                String html = this.parser.parseToHtml(String.valueOf(headingMarkup) + "\nfirst para<br/>\nfirst para line2\n\nsecond para\n\nthird para");
                TestUtil.println(html);
                MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><h" + x + " id=\"[^\"]+\">heading text</h" + x + "><p>first para<br/>\\s*first para line2</p><p>second para</p><p>third para</p></body>", 8).matcher(html).find());
                ++n2;
            }
            ++x;
        }
    }

    public void testHeadingWithStyles_bug355713() {
        String html = this.parser.parseToHtml("== '''bold''' ''italic'' <u>underlined</u> <s>strikethrough</s> ==");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<h2.*?><b>bold</b> <i>italic</i> <u>underlined</u> <s>strikethrough</s></h2>").matcher(html).find());
    }

    public void testHeadingsWithPara() {
        String html = this.parser.parseToHtml("\n== H1 ==\n\npa\n\n=== H3 ===\n\nabc");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><h2 id=\"H1\">H1</h2><p>pa</p><h3 id=\"H3\">H3</h3><p>abc</p></body>"));
    }

    private String repeat(int i, String string) {
        StringBuilder buf = new StringBuilder(string.length() * i);
        int x = 0;
        while (x < i) {
            buf.append(string);
            ++x;
        }
        return buf.toString();
    }

    public void testHorizontalRule() {
        String html = this.parser.parseToHtml("an hr ---- foo");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("hr <hr/> foo"));
    }

    public void testHorizontalRule2() {
        String html = this.parser.parseToHtml("Mediawiki should render:\n----\nAs a \"horizontal rule\".");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("render\\:\\s*<hr/>\\s*As a").matcher(html).find());
    }

    public void testListUnordered() throws IOException {
        String html = this.parser.parseToHtml("* a list\n* with two lines");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<ul>"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<li>a list</li>"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<li>with two lines</li>"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("</ul>"));
    }

    public void testListOrdered() throws IOException {
        String html = this.parser.parseToHtml("# a list\n# with two lines");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<ol>"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<li>a list</li>"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<li>with two lines</li>"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("</ol>"));
    }

    public void testListOrderedWithContinuation() throws IOException {
        String html = this.parser.parseToHtml("# a list\n## a nested item\n### another nested item\n#: continued\n# another item");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><ol><li>a list<ol><li>a nested item<ol><li>another nested item</li></ol>continued</li></ol></li><li>another item</li></ol></body>"));
    }

    public void testListOrderedWithContinuationToDocBook() throws IOException {
        StringWriter out = new StringWriter();
        this.parser.setBuilder((DocumentBuilder)new DocBookDocumentBuilder((Writer)out));
        this.parser.parse("# a list\n## a nested item\n### another nested item\n#: continued\n# another item");
        String docbook = out.toString();
        TestUtil.println("DocBook: \n" + docbook);
        MediaWikiLanguageTest.assertTrue((boolean)docbook.contains("<orderedlist><listitem><para>a list</para><orderedlist><listitem><para>a nested item</para><orderedlist><listitem><para>another nested item</para></listitem></orderedlist><para>continued</para></listitem></orderedlist></listitem><listitem><para>another item</para></listitem></orderedlist>"));
    }

    public void testListNested() throws IOException {
        String html = this.parser.parseToHtml("# a list\n## nested\n## nested2\n# level1\n\npara");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<ol>"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<li>a list"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<li>nested"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("</ol>"));
    }

    public void testListMixed() throws IOException {
        String html = this.parser.parseToHtml("# first\n* second");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<ol><li>first</li></ol><ul><li>second</li></ul>"));
    }

    public void testListNestedMixed() throws IOException {
        String html = this.parser.parseToHtml("# a list\n#* nested\n#* nested2\n# level1\n\npara");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<ol><li>a list<ul><li>nested</li><li>nested2</li></ul></li><li>level1</li></ol>"));
    }

    public void testDefinitionList() {
        String html = this.parser.parseToHtml(";Definition\n:item1\n:item2\na para");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><dl><dt>Definition</dt><dd>item1</dd><dd>item2</dd></dl><p>a para</p></body>"));
    }

    public void testDefinitionList2() {
        String html = this.parser.parseToHtml(";Definition : item1\n:item2\na para");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><dl><dt>Definition</dt><dd>item1</dd><dd>item2</dd></dl><p>a para</p></body>"));
    }

    public void testDefinitionList3() {
        String html = this.parser.parseToHtml(";Definition [http://www.foobar.com Foo Bar] : Foo Bar test 123\n;Definition 2 [http://www.foobarbaz.com Foo Bar Baz] : another definition\na para");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("</head><body><dl><dt>Definition <a href=\"http://www.foobar.com\">Foo Bar</a></dt><dd>Foo Bar test 123</dd><dt>Definition 2 <a href=\"http://www.foobarbaz.com\">Foo Bar Baz</a></dt><dd>another definition</dd></dl><p>a para</p></body>"));
    }

    public void testIndented() {
        String html = this.parser.parseToHtml("::Indented\na para");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><dl><dd><dl><dd>Indented</dd></dl></dd></dl><p>a para</p></body>"));
    }

    public void testPreformatted() {
        String html = this.parser.parseToHtml("normal para\n preformatted\n more pre\nnormal para");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal para</p><pre>preformatted\\s+more pre\\s+</pre><p>normal para</p></body>").matcher(html).find());
    }

    public void testPreformattedWithTag() {
        String html = this.parser.parseToHtml("normal para\n<pre style=\"overflow:scroll\" class=\"TEST\">preformatted\n more pre\n</pre>normal para");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal para</p><pre class=\"TEST\" style=\"overflow:scroll\">preformatted\\s+more pre\\s+</pre><p>normal para</p></body>").matcher(html).find());
    }

    public void testPreformattedWithTagStartEndOnSameLine() {
        String html = this.parser.parseToHtml("normal para\n<pre>preformatted</pre>normal para");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal para</p><pre>preformatted\\s+</pre><p>normal para</p></body>").matcher(html).find());
    }

    public void testPreformattedWithTagStartEndOnSameLine3() {
        String html = this.parser.parseToHtml("normal para\n<pre>preformatted</pre>\nnormal para");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal para</p><pre>preformatted\\s+</pre><p>normal para</p></body>").matcher(html).find());
    }

    public void testPreformattedWithTagStartEndOnSameLine2() {
        String html = this.parser.parseToHtml("example:\n\n<pre><a href=\"show_bug.cgi\\?id\\=(.+?)\">.+?<span class=\"summary\">(.+?)</span></pre>\n\nIf");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>example:</p><pre>" + Pattern.quote("&lt;a href=\"show_bug.cgi\\?id\\=(.+?)\"&gt;.+?&lt;span class=\"summary\"&gt;(.+?)&lt;/span&gt;") + "\\s+</pre><p>If</p></body>").matcher(html).find());
    }

    public void testPreformattedSource_bug349724() {
        String html = this.parser.parseToHtml("normal para\n<source lang=\"javascript\">preformatted\n more pre\n</source>normal para");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<p>normal para</p><pre class=\"source-javascript\">preformatted\\s+more pre\\s+</pre><p>normal para</p>").matcher(html).find());
    }

    public void testPreformattedWithTagAndMarkup() {
        String html = this.parser.parseToHtml("example:\n\n<pre>a block\nWith '''Bold text''' or ''Italic text'' style\nIs not converted</pre>\n\nIf");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>example:</p><pre>a block\\s+With '''Bold text''' or ''Italic text'' style\\s+Is not converted\\s+</pre><p>If</p></body>").matcher(html).find());
    }

    public void testPreformattedWithMarkup() {
        String html = this.parser.parseToHtml("normal para\n preformatted\n with '''Bold text''' or ''Italic text'' style\n more pre\nnormal para");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal para</p><pre>preformatted\\s+with <b>Bold text</b> or <i>Italic text</i> style\\s+more pre\\s+</pre><p>normal para</p></body>").matcher(html).find());
    }

    public void testPreformattedWithFont() {
        String html = this.parser.parseToHtml("normal para\n preformatted\n with <font color=\"red\">some red color</font>\n more pre\nnormal para");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal para</p><pre>preformatted\\s+with <font color=\"red\">some red color</font>\\s+more pre\\s+</pre><p>normal para</p></body>").matcher(html).find());
    }

    public void testHtmlTags() {
        String html = this.parser.parseToHtml("normal para <b id=\"foo\">test heading</b>");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<p>normal para <b id=\"foo\">test heading</b></p>"));
    }

    public void testHtmlComment() {
        String html = this.parser.parseToHtml("normal para <!-- test comment --> normal *foo*");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>normal para  normal *foo*</p></body>"));
    }

    public void testHtmlCommentEmpty() {
        String html = this.parser.parseToHtml("normal para <!-- --> normal *foo*");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>normal para  normal *foo*</p></body>"));
    }

    public void testHtmlCommentOnSameLineAsAnotherCommentWhitespaceSeparator() {
        String html = this.parser.parseToHtml("normal para <!-- --> <!-- --> normal");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>normal para   normal</p></body>"));
    }

    public void testHtmlCommentOnSameLineAsAnotherComment() {
        String html = this.parser.parseToHtml("normal para <!-- -->b<!-- --> normal");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>normal para b normal</p></body>"));
    }

    public void testHtmlCodeWithNestedFormatting() {
        String html = this.parser.parseToHtml("<code>NonItalic=''Italic''</code>");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<p><code>NonItalic=<i>Italic</i></code></p>"));
    }

    public void testLinkInternalPageReference() {
        String html = this.parser.parseToHtml("a [[Main Page]] reference to the Main Page");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"/wiki/Main_Page\" title=\"Main Page\">Main Page</a> reference to the Main Page</p></body>"));
    }

    public void testLinkInternalPageAnchorReference() {
        String html = this.parser.parseToHtml("a [[#Some link|alt text]] reference to an internal anchor");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"#Some_link\">alt text</a> reference to an internal anchor</p></body>"));
    }

    public void testLinkInternalPageReferenceWithAltText() {
        String html = this.parser.parseToHtml("a [[Main Page|alternative text]] reference to the Main Page");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"/wiki/Main_Page\" title=\"Main Page\">alternative text</a> reference to the Main Page</p></body>"));
    }

    public void testLinkInternalPageReferenceWithAltText2() {
        String html = this.parser.parseToHtml("[[Orion/Server_API/Preference API| Preference API]]");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<p><a href=\"/wiki/Orion/Server_API/Preference_API\" title=\"Orion/Server_API/Preference API\">Preference API</a></p>"));
    }

    public void testLinkInternalPageReferenceWithAltTextInTables() {
        String html = this.parser.parseToHtml("{|\n| [[Orion/Server_API/Preference API| Preference API]]\n|}");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<td><a href=\"/wiki/Orion/Server_API/Preference_API\" title=\"Orion/Server_API/Preference API\">Preference API</a></td>"));
    }

    public void testLinkInternalCategoryReference() {
        String html = this.parser.parseToHtml("a [[:Category:Help]] reference to the Main Page");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"Category:Help\" title=\"Category:Help\">Category:Help</a> reference to the Main Page</p></body>"));
    }

    public void testHyperlinkImplied() {
        String html = this.parser.parseToHtml("a http://example.com hyperlink");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">http://example.com</a> hyperlink</p></body>"));
    }

    public void testHyperlinkInternal() {
        String html = this.parser.parseToHtml("Also see the [[Mylyn_FAQ#Installation_Troubleshooting | Installation FAQ]].");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<p>Also see the <a href=\"/wiki/Mylyn_FAQ#Installation_Troubleshooting\" title=\"Mylyn_FAQ#Installation_Troubleshooting\">Installation FAQ</a>.</p>"));
    }

    public void testHyperlinkQualifiedInternal() {
        this.markupLanguage.setInternalLinkPattern("http://wiki.eclipse.org/Mylyn/{0}");
        String html = this.parser.parseToHtml("Also see the [[Mylyn/FAQ#Installation_Troubleshooting | Installation FAQ]].");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<p>Also see the <a href=\"http://wiki.eclipse.org/Mylyn/FAQ#Installation_Troubleshooting\" title=\"Mylyn/FAQ#Installation_Troubleshooting\">Installation FAQ</a>.</p>"));
    }

    public void testHyperlinkInternalPiped() {
        String html = this.parser.parseToHtml("[[MoDisco/QueryManager|create a query set]]");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<a href=\"/wiki/MoDisco/QueryManager\" title=\"MoDisco/QueryManager\">create a query set</a>"));
    }

    public void testHyperlinkInternalWithSpaces() {
        this.markupLanguage.setInternalLinkPattern("http://wiki.eclipse.org/{0}");
        String html = this.parser.parseToHtml("Also see the [[Mylyn/User Guide]].");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<p>Also see the <a href=\"http://wiki.eclipse.org/Mylyn/User_Guide\" title=\"Mylyn/User Guide\">Mylyn/User Guide</a>.</p>"));
    }

    public void testHyperlinkExternal() {
        String html = this.parser.parseToHtml("a [http://example.com] hyperlink");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">http://example.com</a> hyperlink</p></body>"));
    }

    public void testHyperlinkExternalWithAltText() {
        String html = this.parser.parseToHtml("a [http://example.com|Example] hyperlink");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">Example</a> hyperlink</p></body>"));
    }

    public void testHyperlinkExternalWithAltText2() {
        String html = this.parser.parseToHtml("a [http://example.com Example Title] hyperlink");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">Example Title</a> hyperlink</p></body>"));
    }

    public void testImage() {
        String html = this.parser.parseToHtml("a [[Image:foo.png]] image");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <img border=\"0\" src=\"foo.png\"/> image</p></body>"));
    }

    public void testImageWithAltText() {
        String html = this.parser.parseToHtml("a [[Image:foo.png|Example]] image");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <img title=\"Example\" alt=\"Example\" border=\"0\" src=\"foo.png\"/> image</p></body>"));
    }

    public void testImageWithAltText2() {
        String html = this.parser.parseToHtml("a [[Image:foo.png|Alt Text|Caption]] image");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<img alt=\"Alt Text\" title=\"Caption\" border=\"0\" src=\"foo.png\"/>"));
    }

    public void testImageWithAltTextAndOptions() {
        String html = this.parser.parseToHtml("a [[Image:foo.png|100px|center|Example]] image");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <img width=\"100\" align=\"middle\" title=\"Example\" alt=\"Example\" border=\"0\" src=\"foo.png\"/> image</p></body>"));
    }

    public void testImageWithAltTextAndHeightWidth() {
        String html = this.parser.parseToHtml("a [[Image:foo.png|100x220px]] image");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <img height=\"220\" width=\"100\" border=\"0\" src=\"foo.png\"/> image</p></body>"));
    }

    public void testImageWithAltTextAndWidth() {
        String html = this.parser.parseToHtml("a [[Image:foo.png|100px]] image");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <img width=\"100\" border=\"0\" src=\"foo.png\"/> image</p></body>"));
    }

    public void testImageWithLinkInCaption() {
        String html = this.parser.parseToHtml("[[Image:IFF Logo.JPG|left|the logo|Official logo of the [[International Floorball Federation]], floorball's governing body.]]");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<img align=\"left\" alt=\"the logo\" title=\"Official logo of the [[International Floorball Federation]], floorball's governing body.\" border=\"0\" src=\"IFF_Logo.JPG\"/>"));
    }

    public void testImageWithLinkInCaptionThumbnail() {
        String html = this.parser.parseToHtml("[[Image:IFF Logo.JPG|thumb|left|the logo|Official logo of the [[International Floorball Federation]], floorball's governing body.]]");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<div class=\"thumb left\"><div class=\"thumbinner\"><a href=\"IFF_Logo.JPG\" class=\"image\"><img class=\"thumbimage\" align=\"left\" alt=\"the logo\" border=\"0\" src=\"IFF_Logo.JPG\"/></a><div class=\"thumbcaption\">Official logo of the <a href=\"/wiki/International_Floorball_Federation\" title=\"International Floorball Federation\">International Floorball Federation</a>, floorball's governing body.</div></div></div>"));
    }

    public void testImageWithTitle() {
        String html = this.parser.parseToHtml("text text text text text text\n[[Image:Westminstpalace.jpg|150px|alt=A large clock tower and other buildings line a great river.|The Palace of Westminster]]");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<img width=\"150\" alt=\"A large clock tower and other buildings line a great river.\" title=\"The Palace of Westminster\" border=\"0\" src=\"Westminstpalace.jpg\"/>"));
    }

    public void testImageSimple() {
        String html = this.parser.parseToHtml("[[Image:ImportFedoraGit.png]]");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<img border=\"0\" src=\"ImportFedoraGit.png\"/>"));
    }

    public void testImageWithLeadingWhitespace() {
        String html = this.parser.parseToHtml("[[Image: SomeImage.png]]");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<img border=\"0\" src=\"SomeImage.png\"/>"));
    }

    public void testImageFile() {
        String html = this.parser.parseToHtml("a [[File:foo.png]] image");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <img border=\"0\" src=\"foo.png\"/> image</p></body>"));
    }

    public void testImageFile_Negative() {
        String html = this.parser.parseToHtml("a [[FilImage:foo.png]] image");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertFalse((boolean)html.contains("<img"));
    }

    public void testImage_Lower() {
        String html = this.parser.parseToHtml("a [[image:foo.png]] image");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <img border=\"0\" src=\"foo.png\"/> image</p></body>"));
    }

    public void testImageFile_Lower() {
        String html = this.parser.parseToHtml("a [[file:foo.png]] image");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <img border=\"0\" src=\"foo.png\"/> image</p></body>"));
    }

    public void testTable() {
        String html = this.parser.parseToHtml("{|\n|Orange\n|Apple\n|-\n|Bread\n|Pie\n|-\n|Butter\n|Ice cream \n|}");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><table><tr><td>Orange</td><td>Apple</td></tr><tr><td>Bread</td><td>Pie</td></tr><tr><td>Butter</td><td>Ice cream </td></tr></table></body>"));
    }

    public void testTable2() {
        String html = this.parser.parseToHtml("{|\n|  Orange    ||   Apple   ||   more\n|-\n|   Bread    ||   Pie     ||   more\n|-\n|   Butter   || Ice cream ||  and more\n|}\n");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><table><tr><td>Orange</td><td>Apple</td><td>more</td></tr><tr><td>Bread</td><td>Pie</td><td>more</td></tr><tr><td>Butter</td><td>Ice cream</td><td>and more</td></tr></table></body>"));
    }

    public void testTableWithBlankLine() {
        String html = this.parser.parseToHtml("{|\n|Orange\n|Apple\n|-\n|Bread\n\nMore bread\n|Pie\n|-\n|Butter\n|Ice cream \n|}");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><table><tr><td>Orange</td><td>Apple</td></tr><tr><td>Bread<p>More bread</p></td><td>Pie</td></tr><tr><td>Butter</td><td>Ice cream </td></tr></table></body>"));
    }

    public void testTableHeadings() {
        String html = this.parser.parseToHtml("{|\n!  Fruit    !!   Quantity   !!  Price\n|-\n|   Apple    ||   lb     ||   0.99\n|}\n");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><table><tr><th>Fruit</th><th>Quantity</th><th>Price</th></tr><tr><td>Apple</td><td>lb</td><td>0.99</td></tr></table></body>"));
    }

    public void testTableHeadingsMixed() {
        String html = this.parser.parseToHtml("{|\n! headerCell || normalCell\n|-\n| normalCell2 !! headerCell2\n|}");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><table><tr><th>headerCell</th><td>normalCell</td></tr><tr><td>normalCell2</td><th>headerCell2</th></tr></table></body>"));
    }

    public void testTableLexicalOffsets() {
        RecordingDocumentBuilder builder = new RecordingDocumentBuilder();
        this.parser.setBuilder((DocumentBuilder)builder);
        TestUtil.println("{|\n|  Orange    ||   Apple   ||   more\n|-\n|   Bread    ||   Pie     ||   more\n|-\n|   Butter   || Ice cream ||  and more\n|}\n");
        this.parser.parse("{|\n|  Orange    ||   Apple   ||   more\n|-\n|   Bread    ||   Pie     ||   more\n|-\n|   Butter   || Ice cream ||  and more\n|}\n");
        TestUtil.println("Events: \n" + (Object)((Object)builder));
        for (RecordingDocumentBuilder.Event event : builder.getEvents()) {
            if (event.text == null) continue;
            int start = event.locator.getDocumentOffset();
            int end = event.locator.getLineSegmentEndOffset() + event.locator.getLineDocumentOffset();
            MediaWikiLanguageTest.assertEquals((int)event.text.length(), (int)(end - start));
            MediaWikiLanguageTest.assertTrue((end >= start ? 1 : 0) != 0);
            MediaWikiLanguageTest.assertEquals((String)"{|\n|  Orange    ||   Apple   ||   more\n|-\n|   Bread    ||   Pie     ||   more\n|-\n|   Butter   || Ice cream ||  and more\n|}\n".substring(start, end), (String)event.text);
        }
    }

    public void testTableIncomplete() {
        RecordingDocumentBuilder builder = new RecordingDocumentBuilder();
        this.parser.setBuilder((DocumentBuilder)builder);
        TestUtil.println("{|\n|  Orange    ||   Apple   ||   more\n|-\n|   Bread    ||   Pie     ||   more\n|-\n|   Butter   || Ice cream ||  and more\n| \n");
        this.parser.parse("{|\n|  Orange    ||   Apple   ||   more\n|-\n|   Bread    ||   Pie     ||   more\n|-\n|   Butter   || Ice cream ||  and more\n| \n");
        TestUtil.println("Events: \n" + (Object)((Object)builder));
        for (RecordingDocumentBuilder.Event event : builder.getEvents()) {
            if (event.text == null) continue;
            int start = event.locator.getDocumentOffset();
            int end = event.locator.getLineSegmentEndOffset() + event.locator.getLineDocumentOffset();
            MediaWikiLanguageTest.assertEquals((int)event.text.length(), (int)(end - start));
            MediaWikiLanguageTest.assertTrue((end >= start ? 1 : 0) != 0);
            MediaWikiLanguageTest.assertEquals((String)"{|\n|  Orange    ||   Apple   ||   more\n|-\n|   Bread    ||   Pie     ||   more\n|-\n|   Butter   || Ice cream ||  and more\n| \n".substring(start, end), (String)event.text);
        }
    }

    public void testTableIncomplete2() {
        RecordingDocumentBuilder builder = new RecordingDocumentBuilder();
        this.parser.setBuilder((DocumentBuilder)builder);
        TestUtil.println("{|\n| foo |\n|}");
        this.parser.parse("{|\n| foo |\n|}");
        TestUtil.println("Events: \n" + (Object)((Object)builder));
        for (RecordingDocumentBuilder.Event event : builder.getEvents()) {
            if (event.text == null) continue;
            int start = event.locator.getDocumentOffset();
            int end = event.locator.getLineSegmentEndOffset() + event.locator.getLineDocumentOffset();
            MediaWikiLanguageTest.assertEquals((int)event.text.length(), (int)(end - start));
            MediaWikiLanguageTest.assertTrue((end >= start ? 1 : 0) != 0);
            MediaWikiLanguageTest.assertEquals((String)"{|\n| foo |\n|}".substring(start, end), (String)event.text);
        }
    }

    public void testTableWithSyntax() {
        RecordingDocumentBuilder builder = new RecordingDocumentBuilder();
        this.parser.setBuilder((DocumentBuilder)builder);
        String content = "{|\n| <nowiki>'''''bold italic'''''</nowiki> || '''''bold italic''''' ||\n|}";
        TestUtil.println(content);
        this.parser.parse(content);
        TestUtil.println("Events: \n" + (Object)((Object)builder));
        for (RecordingDocumentBuilder.Event event : builder.getEvents()) {
            if (event.text == null) continue;
            int start = event.locator.getDocumentOffset();
            int end = event.locator.getLineSegmentEndOffset() + event.locator.getLineDocumentOffset();
            MediaWikiLanguageTest.assertTrue((end >= start ? 1 : 0) != 0);
        }
    }

    public void testTableOptions() {
        String html = this.parser.parseToHtml("{| border=\"1\"\n|- style=\"font-style:italic;color:green;\"\n| colspan=\"2\" | Orange || valign=\"top\" | Apple\n|}");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<table border=\"1\"><tr style=\"font-style:italic;color:green;\">"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<td colspan=\"2\">Orange</td>"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<td valign=\"top\">Apple</td>"));
    }

    public void testTableOptions_CssClass() {
        String html = this.parser.parseToHtml("{|class=\"foo\"\n|Some text\n|}");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<table class=\"foo\"><tr><td>Some text</td></tr></table>"));
    }

    public void testTableWithParagraphs() {
        StringBuilder sb = new StringBuilder();
        sb.append("{|border=\"1\"\n");
        sb.append("|\n");
        sb.append("A paragraph with '''Bold text''' in a cell.\n");
        sb.append("|\n");
        sb.append("A cell ''containing'' more...\n");
        sb.append("\n");
        sb.append("Than one paragraph.\n");
        sb.append("|}\n");
        String html = this.parser.parseToHtml(sb.toString());
        TestUtil.println("HTML: \n" + html);
        Pattern pattern = Pattern.compile("<table border=\"1\">\\s*<tr>\\s*<td>\\s*<p>\\s*A paragraph with \\s*<b>\\s*Bold text\\s*</b>\\s* in a cell.\\s*</p>\\s*</td>\\s*<td>\\s*<p>\\s*A cell \\s*<i>\\s*containing\\s*</i>\\s* more...\\s*</p>\\s*<p>\\s*Than one paragraph.\\s*</p>\\s*</td>\\s*</tr>\\s*</table>");
        this.assertContainsPattern(html, pattern);
    }

    public void testTableWithLongerText() {
        StringBuilder sb = new StringBuilder();
        sb.append("{|border=\"1\"\n");
        sb.append("|Sxto mesto kusoks ti sam, \n");
        sb.append("Da skandalis studentis bezopasostif tut, \n");
        sb.append("dost takai vcxera na mne\n");
        sb.append("Mai na zxen problem zembulbas, \n");
        sb.append("dost vozduh dusxijm kai te. \n");
        sb.append("\n");
        sb.append("Oliv slozxju informacias bi bez\n");
        sb.append("om gde detes komnat,\n");
        sb.append("To divaj neskolk pridijt ili\n");
        sb.append("Ktor zapalka bezopasostif es tot. \n");
        sb.append("|\n");
        sb.append("* Sxto mesto kusoks ti sam\n");
        sb.append("* Vi edat zaspatit zapomnitlubovijm sol\n");
        sb.append("* dost takai vcxera na mne\n");
        sb.append("|}\n");
        String html = this.parser.parseToHtml(sb.toString());
        TestUtil.println("HTML: \n" + html);
        Pattern pattern = Pattern.compile("<table border=\"1\">\\s*<tr>\\s*<td>\\s*Sxto mesto kusoks ti sam,\\s*<p>\\s*Da skandalis studentis bezopasostif tut,\\s+dost takai vcxera na mne\\s+Mai na zxen problem zembulbas,\\s+dost vozduh dusxijm kai te.\\s*</p>\\s*<p>\\s*Oliv slozxju informacias bi bez\\s*om gde detes komnat,\\s*To divaj neskolk pridijt ili\\s*Ktor zapalka bezopasostif es tot.\\s*</p>\\s*</td>\\s*<td>\\s*<ul>\\s*<li>\\s*Sxto mesto kusoks ti sam\\s*</li>\\s*<li>\\s*Vi edat zaspatit zapomnitlubovijm sol\\s*</li>\\s*<li>\\s*dost takai vcxera na mne\\s*</li>\\s*</ul>\\s*</td>\\s*</tr>\\s*</table>");
        this.assertContainsPattern(html, pattern);
    }

    public void testTableWithCodeInCellAndOptions() {
        StringBuilder sb = new StringBuilder();
        sb.append("{|border=\"1\"\n");
        sb.append("|\n");
        sb.append("  some\n");
        sb.append("|\n");
        sb.append("  code\n");
        sb.append("  multiline\n");
        sb.append("|style=\"background-color:#FFFF00;\"|\n");
        sb.append("  this is code in an highlighted cell\n");
        sb.append("|}\n");
        String html = this.parser.parseToHtml(sb.toString());
        TestUtil.println("HTML: \n" + html);
        Pattern pattern = Pattern.compile("<table border=\"1\">\\s*<tr>\\s*<td>\\s*<pre>\\s*some\n</pre>\\s*</td>\\s*<td>\\s*<pre>\\s*code\n multiline\n</pre>\\s*</td>\\s*<td style=\"background-color:#FFFF00;\">\\s*<pre>\\s*this is code in an highlighted cell\n</pre>\\s*</td>\\s*</tr>\\s*</table>");
        this.assertContainsPattern(html, pattern);
    }

    public void testTableWithExplicitFirstRowAndRowSpan() {
        StringBuilder sb = new StringBuilder();
        sb.append("{|border=\"1\"\n");
        sb.append("|-\n");
        sb.append("!colspan=\"6\"|XYZ uv\n");
        sb.append("|-\n");
        sb.append("|rowspan=\"2\"|X1 & X2\n");
        sb.append("|y1\n");
        sb.append("|y2\n");
        sb.append("|y3\n");
        sb.append("|colspan=\"2\"|Z9\n");
        sb.append("|-\n");
        sb.append("|z8\n");
        sb.append("|colspan=\"2\"|T6\n");
        sb.append("|u4\n");
        sb.append("|U6\n");
        sb.append("|}\n");
        String html = this.parser.parseToHtml(sb.toString());
        TestUtil.println("HTML: \n" + html);
        Pattern pattern = Pattern.compile("<table border=\"1\">\\s*<tr>\\s*<th colspan=\"6\">\\s*XYZ uv\\s*</th>\\s*</tr>\\s*<tr>\\s*<td rowspan=\"2\">\\s*X1 &amp; X2\\s*</td>\\s*<td>\\s*y1\\s*</td>\\s*<td>\\s*y2\\s*</td>\\s*<td>\\s*y3\\s*</td>\\s*<td colspan=\"2\">\\s*Z9\\s*</td>\\s*</tr>\\s*<tr>\\s*<td>\\s*z8\\s*</td>\\s*<td colspan=\"2\">\\s*T6\\s*</td>\\s*<td>\\s*u4\\s*</td>\\s*<td>\\s*U6\\s*</td>\\s*</tr>\\s*</table>");
        this.assertContainsPattern(html, pattern);
    }

    public void testTableNested() {
        StringBuilder sb = new StringBuilder();
        sb.append("{|\n");
        sb.append("| f ||\n");
        sb.append("{| border=\"1\"\n");
        sb.append("| a\n");
        sb.append("| b\n");
        sb.append("|}\n");
        sb.append("| ,\n");
        sb.append("|\n");
        sb.append("{| border=\"1\"\n");
        sb.append("| c\n");
        sb.append("| d\n");
        sb.append("|}\n");
        sb.append("|}\n");
        String html = this.parser.parseToHtml(sb.toString());
        TestUtil.println("HTML: \n" + html);
        Pattern pattern = Pattern.compile("<table>\\s*<tr>\\s*<td>\\s*f\\s*<table border=\"1\">\\s*<tr>\\s*<td>\\s*a\\s*</td>\\s*<td>\\s*b\\s*</td>\\s*</tr>\\s*</table>\\s*</td>\\s*<td>\\s*,\\s*</td>\\s*<td>\\s*<table border=\"1\">\\s*<tr>\\s*<td>\\s*c\\s*</td>\\s*<td>\\s*d\\s*</td>\\s*</tr>\\s*</table>\\s*</td>\\s*</tr>\\s*</table>");
        this.assertContainsPattern(html, pattern);
    }

    public void testTableNestedMalformed() {
        StringBuilder sb = new StringBuilder();
        sb.append("{| \n");
        sb.append("| first table first cell\n");
        sb.append("{| \n");
        sb.append("| second table first cell\n");
        sb.append("|}\n");
        sb.append("| first table first cell\n");
        String html = this.parser.parseToHtml(sb.toString());
        TestUtil.println("HTML: \n" + html);
        String expected = "<table><tr><td>first table first cell<table><tr><td>second table first cell</td></tr></table></td><td>first table first cell</td></tr></table>";
        MediaWikiLanguageTest.assertTrue((boolean)html.contains(expected));
    }

    public void testTableNestedMultiple() {
        StringBuilder sb = new StringBuilder();
        sb.append("{| style=\"background-color:red;\"\n");
        sb.append("! AAA !! AAAAAAAA !! AA\n");
        sb.append("|-\n");
        sb.append("| a\n");
        sb.append("| aaaaa\n");
        sb.append("| aaa\n");
        sb.append("{| style=\"background-color:green;\"\n");
        sb.append("! B \n");
        sb.append("| bbbb\n");
        sb.append("|-\n");
        sb.append("! BBB\n");
        sb.append("| bb\n");
        sb.append("|-\n");
        sb.append("! BBBBB\n");
        sb.append("| bb\n");
        sb.append("|}\n");
        sb.append("|-\n");
        sb.append("| aaaa\n");
        sb.append("{| style=\"background-color:yellow;\"\n");
        sb.append("! BBBBB !! BBB\n");
        sb.append("|-\n");
        sb.append("| bbbbb\n");
        sb.append("| bbb\n");
        sb.append("|-\n");
        sb.append("| bb\n");
        sb.append("{| style=\"background-color:blue;\"\n");
        sb.append("! CCC !! CCCCC !! CCCCC\n");
        sb.append("|-\n");
        sb.append("| cc\n");
        sb.append("| ccccc\n");
        sb.append("| ccc\n");
        sb.append("|-\n");
        sb.append("| c\n");
        sb.append("| cccc\n");
        sb.append("| ccc\n");
        sb.append("|}\n");
        sb.append("| bbbbb\n");
        sb.append("|-\n");
        sb.append("| bbbb\n");
        sb.append("| bb\n");
        sb.append("|}\n");
        sb.append("| aaaaaaa\n");
        sb.append("| aa\n");
        sb.append("|-\n");
        sb.append("| aaa\n");
        sb.append("| aaaaaaaa\n");
        sb.append("| aaaa\n");
        sb.append("|}\n");
        String html = this.parser.parseToHtml(sb.toString());
        TestUtil.println("HTML: \n" + html);
        String expected = "<table style=\"background-color:red;\"><tr><th>AAA</th><th>AAAAAAAA</th><th>AA</th></tr><tr><td>a</td><td>aaaaa</td><td>aaa<table style=\"background-color:green;\"><tr><th>B </th><td>bbbb</td></tr><tr><th>BBB</th><td>bb</td></tr><tr><th>BBBBB</th><td>bb</td></tr></table></td></tr><tr><td>aaaa<table style=\"background-color:yellow;\"><tr><th>BBBBB</th><th>BBB</th></tr><tr><td>bbbbb</td><td>bbb</td></tr><tr><td>bb<table style=\"background-color:blue;\"><tr><th>CCC</th><th>CCCCC</th><th>CCCCC</th></tr><tr><td>cc</td><td>ccccc</td><td>ccc</td></tr><tr><td>c</td><td>cccc</td><td>ccc</td></tr></table></td><td>bbbbb</td></tr><tr><td>bbbb</td><td>bb</td></tr></table></td><td>aaaaaaa</td><td>aa</td></tr><tr><td>aaa</td><td>aaaaaaaa</td><td>aaaa</td></tr></table>";
        MediaWikiLanguageTest.assertTrue((boolean)html.contains(expected));
    }

    public void testTableLeadingSpaces() {
        StringBuilder sb = new StringBuilder();
        sb.append("{| \n");
        sb.append(" ! lorem\n");
        sb.append(" ! ipsum\n");
        sb.append(" |-\n");
        sb.append(" | dolor\n");
        sb.append(" | amtis\n");
        sb.append(" |}\n");
        String html = this.parser.parseToHtml(sb.toString());
        TestUtil.println("HTML: \n" + html);
        String expected = "<table><tr><th>lorem</th><th>ipsum</th></tr><tr><td>dolor</td><td>amtis</td></tr></table>";
        MediaWikiLanguageTest.assertTrue((boolean)html.contains(expected));
    }

    public void testTableLeadingSpacesInContext() {
        StringBuilder sb = new StringBuilder();
        sb.append("aaa\n");
        sb.append("  {| border=\"1\" \n");
        sb.append(" ! other !! test !! table\n");
        sb.append("   |-\n");
        sb.append("     | with\n");
        sb.append("       | some\n");
        sb.append("         | cells\n");
        sb.append("|-\n");
        sb.append("  | and || a || line\n");
        sb.append(" |}\n");
        sb.append(" bbb");
        String html = this.parser.parseToHtml(sb.toString());
        TestUtil.println("HTML: \n" + html);
        String expected = "<p>aaa</p><table border=\"1\"><tr><th>other</th><th>test</th><th>table</th></tr><tr><td>with</td><td>some</td><td>cells</td></tr><tr><td>and</td><td>a</td><td>line</td></tr></table><pre>bbb\n</pre>";
        MediaWikiLanguageTest.assertTrue((boolean)html.contains(expected));
    }

    public void testTableLeadingSpacesNestedMalformed() {
        StringBuilder sb = new StringBuilder();
        sb.append("{| \n");
        sb.append(" | first table first cell\n");
        sb.append("{| \n");
        sb.append(" | second table first cell\n");
        sb.append(" |}\n");
        sb.append(" | first table first cell\n");
        String html = this.parser.parseToHtml(sb.toString());
        TestUtil.println("HTML: \n" + html);
        String expected = "<table><tr><td>first table first cell<table><tr><td>second table first cell</td></tr></table></td><td>first table first cell</td></tr></table>";
        MediaWikiLanguageTest.assertTrue((boolean)html.contains(expected));
    }

    public void testEntityReference() {
        String tests = "&Agrave; &Aacute; &Acirc; &Atilde; &Auml; &Aring; &AElig; &Ccedil; &Egrave; &Eacute; &Ecirc; &Euml; &Igrave; &Iacute; &Icirc; &Iuml; &Ntilde; &Ograve; &Oacute; &Ocirc; &Otilde; &Ouml; &Oslash; &Ugrave; &Uacute; &Ucirc; &Uuml; &szlig; &agrave; &aacute; &acirc; &atilde; &auml; &aring; &aelig; &ccedil; &egrave; &eacute; &ecirc; &euml; &igrave; &iacute; &icirc; &iuml; &ntilde; &ograve; &oacute; &ocirc; &oelig; &otilde; &ouml; &oslash; &ugrave; &uacute; &ucirc; &uuml; &yuml; &iquest; &iexcl; &sect; &para; &dagger; &Dagger; &bull; &ndash; &mdash; &lsaquo; &rsaquo; &laquo; &raquo; &lsquo; &rsquo; &ldquo; &rdquo; &trade; &copy; &reg; &cent; &euro; &yen; &pound; &curren; &#8304; &sup1; &sup2; &sup3; &#8308; &int; &sum; &prod; &radic; &minus; &plusmn; &infin; &asymp; &prop; &equiv; &ne; &le; &ge; &times; &middot; &divide; &part; &prime; &Prime; &nabla; &permil; &deg; &there4; &alefsym; &oslash; &isin; &notin; &cap; &cup; &sub; &sup; &sube; &supe; &not; &and; &or; &exist; &forall;  &rArr; &lArr; &dArr; &uArr; &hArr; &rarr; &darr; &uarr; &larr; &harr; &mdash; &ndash;";
        String[] allEntities = tests.split("\\s+");
        MediaWikiLanguageTest.assertTrue((allEntities.length > 100 ? 1 : 0) != 0);
        String[] stringArray = allEntities;
        int n = allEntities.length;
        int n2 = 0;
        while (n2 < n) {
            String testEntity = stringArray[n2];
            MediaWikiLanguageTest.assertTrue((boolean)testEntity.startsWith("&"));
            MediaWikiLanguageTest.assertTrue((boolean)testEntity.endsWith(";"));
            String html = this.parser.parseToHtml(testEntity);
            MediaWikiLanguageTest.assertTrue((String)(String.valueOf(testEntity) + " in " + html), (boolean)html.contains(testEntity));
            html = this.parser.parseToHtml(String.valueOf(testEntity) + " trailing text");
            MediaWikiLanguageTest.assertTrue((String)(String.valueOf(testEntity) + " in " + html), (boolean)html.contains(testEntity));
            html = this.parser.parseToHtml(String.valueOf(testEntity) + "trailing text");
            MediaWikiLanguageTest.assertTrue((String)(String.valueOf(testEntity) + " in " + html), (boolean)html.contains(testEntity));
            html = this.parser.parseToHtml("leading text " + testEntity);
            MediaWikiLanguageTest.assertTrue((String)(String.valueOf(testEntity) + " in " + html), (boolean)html.contains(testEntity));
            html = this.parser.parseToHtml("leading text" + testEntity);
            MediaWikiLanguageTest.assertTrue((String)(String.valueOf(testEntity) + " in " + html), (boolean)html.contains(testEntity));
            ++n2;
        }
    }

    public void testTemplateEnDash() {
        String html = this.parser.parseToHtml("A{{ndash}}B");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A&nbsp;&ndash; B</p></body>"));
        html = this.parser.parseToHtml("A{{endash}}B");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A&nbsp;&ndash; B</p></body>"));
    }

    public void testTemplateEmDash() {
        String html = this.parser.parseToHtml("A{{mdash}}B");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A&nbsp;&mdash; B</p></body>"));
        html = this.parser.parseToHtml("A{{emdash}}B");
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A&nbsp;&mdash; B</p></body>"));
    }

    public void testTemplateCurrentMonth() {
        String html = this.parser.parseToHtml("{{CURRENTMONTH}}");
        TestUtil.println(html);
        this.assertContainsPattern(html, Pattern.compile("<p>[01]\\d</p>"));
    }

    public void testTemplateCurrentMonthName() {
        String html = this.parser.parseToHtml("{{CURRENTMONTHNAME}}");
        TestUtil.println(html);
        this.assertContainsPattern(html, Pattern.compile("<p>(January|February|March|April|May|June|July|August|September|October|November|December)</p>"));
    }

    public void testTemplateCurrentMonthNameAbbrev() {
        String html = this.parser.parseToHtml("{{CURRENTMONTHABBREV}}");
        TestUtil.println(html);
        this.assertContainsPattern(html, Pattern.compile("<p>(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)</p>"));
    }

    public void testTemplateCurrentDay() {
        String html = this.parser.parseToHtml("{{CURRENTDAY}}");
        TestUtil.println(html);
        this.assertContainsPattern(html, Pattern.compile("<p>[0123]\\d</p>"));
    }

    public void testTemplateCurrentDOW() {
        String html = this.parser.parseToHtml("{{CURRENTDOW}}");
        TestUtil.println(html);
        this.assertContainsPattern(html, Pattern.compile("<p>\\d</p>"));
    }

    public void testTemplateCurrentDayName() {
        String html = this.parser.parseToHtml("{{CURRENTDAYNAME}}");
        TestUtil.println(html);
        this.assertContainsPattern(html, Pattern.compile("<p>(Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday)</p>"));
    }

    public void testTemplateCurrentTime() {
        String html = this.parser.parseToHtml("{{CURRENTTIME}}");
        TestUtil.println(html);
        this.assertContainsPattern(html, Pattern.compile("<p>[012]\\d:[0-5]\\d</p>"));
    }

    public void testTemplateCurrentHour() {
        String html = this.parser.parseToHtml("{{CURRENTHOUR}}");
        TestUtil.println(html);
        this.assertContainsPattern(html, Pattern.compile("<p>[012]\\d</p>"));
    }

    public void testTemplateCurrentWeek() {
        String html = this.parser.parseToHtml("{{CURRENTWEEK}}");
        TestUtil.println(html);
        this.assertContainsPattern(html, Pattern.compile("<p>[0-5]\\d</p>"));
    }

    public void testTemplateUnmatched() {
        String html = this.parser.parseToHtml("a{{ABogusTemplateName}}");
        TestUtil.println(html);
        this.assertContainsPattern(html, Pattern.compile("<p>a</p>"));
        html = this.parser.parseToHtml("a{{#foo}}");
        TestUtil.println(html);
        this.assertContainsPattern(html, Pattern.compile("<p>a</p>"));
    }

    public void testTemplateCurrentTimestamp() {
        String html = this.parser.parseToHtml("{{CURRENTTIMESTAMP}}");
        TestUtil.println(html);
        this.assertContainsPattern(html, Pattern.compile("<p>\\d{14}</p>"));
    }

    private void assertContainsPattern(String html, Pattern pattern) {
        if (!pattern.matcher(html).find()) {
            MediaWikiLanguageTest.fail((String)("Expected " + pattern + " but got " + html));
        }
    }

    public void testDefinitionListIndenting() {
        String markup = ": one\n: two\n\n: three\nfour\n:five";
        String html = this.parser.parseToHtml(markup);
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><dl><dd>one</dd><dd>two</dd></dl><dl><dd>three</dd></dl><p>four</p><dl><dd>five</dd></dl></body>"));
    }

    public void testParagraphBreaksOnPreformatted() {
        String markup = "a normal para\n preformatted\n p\nnormal\n";
        String html = this.parser.parseToHtml(markup);
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>a normal para</p><pre>preformatted\\s+p\\s+</pre><p>normal</p></body>", 8).matcher(html).find());
    }

    public void testParagraphBreaksOnHeading() {
        String markup = "a normal para\n= h1 =\nnormal\n";
        String html = this.parser.parseToHtml(markup);
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a normal para</p><h1 id=\"h1\">h1</h1><p>normal</p></body>"));
    }

    public void testComputeOutline() throws IOException {
        OutlineParser outlineParser = new OutlineParser();
        outlineParser.setMarkupLanguage((MarkupLanguage)new MediaWikiLanguage());
        OutlineItem outline = outlineParser.parse(this.readFully("sample.mediawiki"));
        LinkedHashSet<String> topLevelLabels = new LinkedHashSet<String>();
        LinkedHashSet<String> topLevelIds = new LinkedHashSet<String>();
        List children = outline.getChildren();
        for (OutlineItem item : children) {
            topLevelLabels.add(item.getLabel());
            topLevelIds.add(item.getId());
        }
        MediaWikiLanguageTest.assertEquals((int)children.size(), (int)topLevelIds.size());
        MediaWikiLanguageTest.assertEquals((int)children.size(), (int)topLevelLabels.size());
        MediaWikiLanguageTest.assertTrue((String)("Top-level labels: " + topLevelLabels), (boolean)topLevelLabels.contains("Task-Focused UI"));
    }

    public void testCloneTemplateExcludes() {
        this.markupLanguage.setTemplateExcludes("*foo");
        MediaWikiLanguage copy = (MediaWikiLanguage)this.markupLanguage.clone();
        MediaWikiLanguageTest.assertEquals((String)this.markupLanguage.getTemplateExcludes(), (String)copy.getTemplateExcludes());
    }

    public void testTemplateExcludes() {
        this.markupLanguage.setTemplateExcludes("one, two, four_five");
        this.markupLanguage.setTemplates(Arrays.asList(new Template("one", "1"), new Template("two", "2"), new Template("three", "3"), new Template("four_five", "45")));
        String html = this.parser.parseToHtml("a{{one}} and {{two}} and {{three}} and {{four_five}}");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<p>a and  and 3 and </p>"));
    }

    public void testTemplateExcludesComplexNames() {
        this.markupLanguage.setTemplateExcludes("#eclipseproject:technology.linux-distros");
        this.markupLanguage.setTemplates(Arrays.asList(new Template("#eclipseproject:technology.linux-distros", "! Not excluded - !")));
        String html = this.parser.parseToHtml("foo {{#eclipseproject:technology.linux-distros}} bar");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<p>foo  bar</p>"));
    }

    public void testTemplateExcludesRegEx() {
        this.markupLanguage.setTemplateExcludes("*eclipseproject*, Linux_Tools");
        this.markupLanguage.setTemplates(Arrays.asList(new Template("Linux_Tools", "!Not excluded - Linux_Tools!"), new Template("#eclipseproject:technology.linux-distros", "!Not excluded - eclipseproject!")));
        String html = this.parser.parseToHtml("foo {{#eclipseproject:technology.linux-distros}} bar {{Linux_Tools}} baz");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<p>foo  bar  baz</p>"));
    }

    public void testTableOfContents() throws IOException {
        String html = this.parser.parseToHtml("= Table Of Contents =\n\n__TOC__\n\n= Top Header =\n\nsome text\n\n== Subhead ==\n\n== Subhead2 ==\n\n= Top Header 2 =\n\n== Subhead 3 ==\n\n=== Subhead 4 ===");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<a href=\"#Subhead2\">"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<h2 id=\"Subhead2\">"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("href=\"#Subhead_4\""));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<h3 id=\"Subhead_4\">"));
    }

    public void testTableOfContents_WithTextFollowingTOC() throws IOException {
        String html = this.parser.parseToHtml("= Table Of Contents =\n\nfoo\n__TOC__ bar\n\n= Top Header =\n\nsome text\n\n== Subhead ==\n\n== Subhead2 ==\n\n= Top Header 2 =\n\n== Subhead 3 ==\n\n=== Subhead 4 ===");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<a href=\"#Subhead2\">"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<h2 id=\"Subhead2\">"));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("href=\"#Subhead_4\""));
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<h3 id=\"Subhead_4\">"));
    }

    public void testComment_SingleLine() throws IOException {
        String html = this.parser.parseToHtml("<!-- comment -->");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body></body>"));
    }

    public void testComment_SingleLine_TrailingText() throws IOException {
        String html = this.parser.parseToHtml("<!-- comment --> not a comment");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p> not a comment</p></body>"));
    }

    public void testComment_SingleLine_LeadingText() throws IOException {
        String html = this.parser.parseToHtml("not a comment <!-- comment -->");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>not a comment </p></body>"));
    }

    public void testComment_SingleLine_LeadingTrailingText() throws IOException {
        String html = this.parser.parseToHtml("not a comment <!-- comment --> more text");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>not a comment  more text</p></body>"));
    }

    public void testComment_SingleLine_MultipleBlocks() throws IOException {
        String input = "<!-- X -->Lorem<!-- Y -->Ipsum<!-- Z -->";
        String html = this.parser.parseToHtml(input);
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<p>LoremIpsum</p>"));
    }

    public void testComment_SingleLine_MultipleBlocks_OnMultipleLines() throws IOException {
        String input = "<!-- X -->Lorem<!-- Y -->Ipsum\n<!-- Z -->";
        String html = this.parser.parseToHtml(input);
        TestUtil.println(html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<p>LoremIpsum</p>"));
    }

    public void testComment_MultiLine() throws IOException {
        String html = this.parser.parseToHtml("<!-- comment\nwith\nMultiple lines of text -->\n");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body></body>"));
    }

    public void testComment_MultiLine_Multiple() throws IOException {
        String html = this.parser.parseToHtml("<!-- comment\nwith\nMultiple lines of text -->\n<!-- another comment -->");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body></body>"));
    }

    public void testComment_MultiLine_Multiple2() throws IOException {
        String html = this.parser.parseToHtml("<!-- comment\nwith\nMultiple lines of text -->abc<!-- another\ncomment -->");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>abc</p></body>"));
    }

    public void testComment_MultiLine_TrailingText() throws IOException {
        String html = this.parser.parseToHtml("<!-- comment\nwith\nMultiple lines of text --> not a comment");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p> not a comment</p></body>"));
    }

    public void testComment_MultiLine_LeadingText() throws IOException {
        String html = this.parser.parseToHtml("not a comment <!-- comment\nwith\nMultiple lines of text -->");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>not a comment </p></body>"));
    }

    public void testComment_MultiLine_LeadingTrailingText() throws IOException {
        String html = this.parser.parseToHtml("not a comment <!-- comment\nwith\nMultiple lines of text --> more text");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>not a comment\\s+more text</p></body>").matcher(html).find());
    }

    public void testImageFilenameCaseInsensitivity() {
        String html = this.parser.parseToHtml("[[Image:foo.gif]]");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<img border=\"0\" src=\"foo.gif\"/>"));
        HashSet<String> imageNames = new HashSet<String>();
        imageNames.add("Foo.gif");
        this.markupLanguage.setImageNames(imageNames);
        html = this.parser.parseToHtml("[[Image:foo.gif]]");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<img border=\"0\" src=\"Foo.gif\"/>"));
    }

    public void testHeadingWithHtmlTags() {
        String html = this.parser.parseToHtml("= <span style=\"font-family:monospace\">Heading Text</span> =\n\n text");
        TestUtil.println("HTML: \n" + html);
        MediaWikiLanguageTest.assertTrue((boolean)html.contains("<h1 id=\"Heading_Text\"><span style=\"font-family:monospace\">Heading Text</span></h1>"));
    }

    private String readFully(String resource) throws IOException {
        InputStreamReader reader = new InputStreamReader(MediaWikiLanguageTest.class.getResourceAsStream(resource));
        StringWriter writer = new StringWriter();
        try {
            int i;
            while ((i = ((Reader)reader).read()) != -1) {
                writer.write(i);
            }
        }
        finally {
            ((Reader)reader).close();
        }
        return writer.toString();
    }
}

