/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEventHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.event.SortColumnEvent;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class RowSelectionPreserver<T>
implements ILayerEventHandler<IVisualChangeEvent> {
    private final SelectionLayer selectionLayer;
    private final RowSelectionProvider<T> selectionProvider;
    private final IRowDataProvider<T> rowDataProvider;
    private List<T> selectedRowObjects = new ArrayList<T>();

    public RowSelectionPreserver(SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider) {
        this.selectionLayer = selectionLayer;
        this.rowDataProvider = rowDataProvider;
        this.selectionProvider = new RowSelectionProvider<T>(selectionLayer, rowDataProvider, true);
        this.selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RowSelectionPreserver.this.selectedRowObjects = ((StructuredSelection)event.getSelection()).toList();
            }
        });
    }

    private List<T> getValidSelections() {
        ArrayList<T> newSelection = new ArrayList<T>();
        for (T rowObj : this.selectedRowObjects) {
            int index = this.rowDataProvider.indexOfRowObject(rowObj);
            if (index == -1) continue;
            newSelection.add(rowObj);
        }
        return newSelection;
    }

    @Override
    public void handleLayerEvent(IVisualChangeEvent event) {
        if (ObjectUtils.isEmpty(this.selectedRowObjects)) {
            return;
        }
        if (event instanceof RowStructuralRefreshEvent || event instanceof RowStructuralChangeEvent || event instanceof SortColumnEvent) {
            this.selectionLayer.clear();
            this.selectionProvider.setSelection((ISelection)new StructuredSelection(this.getValidSelections()));
        }
    }

    @Override
    public Class<IVisualChangeEvent> getLayerEventClass() {
        return IVisualChangeEvent.class;
    }
}

