/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.tree.AbstractTreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;

public class TreeRowModel<T>
extends AbstractTreeRowModel<T> {
    protected final Set<Integer> parentIndexes = new HashSet<Integer>();

    public TreeRowModel(ITreeData<T> treeData) {
        super(treeData);
    }

    @Override
    public boolean isCollapsed(int index) {
        return this.parentIndexes.contains(index);
    }

    public void clear() {
        this.parentIndexes.clear();
    }

    @Override
    public List<Integer> collapse(int index) {
        this.parentIndexes.add(index);
        this.notifyListeners();
        return this.getChildIndexes(index);
    }

    @Override
    public List<Integer> collapseAll() {
        ArrayList<Integer> collapsedChildren = new ArrayList<Integer>();
        int i = this.getTreeData().getElementCount() - 1;
        while (i >= 0) {
            if (this.hasChildren(i) && !this.isCollapsed(i)) {
                collapsedChildren.addAll(this.collapse(i));
            }
            --i;
        }
        this.notifyListeners();
        return collapsedChildren;
    }

    @Override
    public List<Integer> expand(int index) {
        this.parentIndexes.remove(index);
        this.notifyListeners();
        List<Integer> children = this.getChildIndexes(index);
        this.parentIndexes.removeAll(children);
        return children;
    }

    @Override
    public List<Integer> expandAll() {
        ArrayList<Integer> children = new ArrayList<Integer>();
        for (int index : this.parentIndexes) {
            children.addAll(this.getChildIndexes(index));
        }
        this.parentIndexes.clear();
        this.notifyListeners();
        return children;
    }
}

