/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.internal.ui.views;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.net4j.ui.shared.SharedIcons;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class Net4jIntrospectorView
extends ViewPart
implements IPartListener,
ISelectionListener,
IDoubleClickListener,
IListener {
    public static final String VIEW_ID = "org.eclipse.net4j.util.Net4jIntrospectorView";
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static Net4jIntrospectorView instance;
    private TableViewer currentViewer;
    private TableViewer objectViewer;
    private TableViewer iterableViewer;
    private TableViewer arrayViewer;
    private TableViewer mapViewer;
    private Stack<Object> elements = new Stack();
    private Text classLabel;
    private Text objectLabel;
    private IAction backAction = new BackAction();
    private IAction modeAction = new ModeAction();
    private IAction containerAction = new ContainerAction();
    private IAction refreshAction = new RefreshAction();
    private StackLayout stackLayout;
    private Composite stacked;
    private IWorkbenchPart activePart;

    public void dispose() {
        IWorkbenchPage page = this.getSite().getPage();
        page.removePartListener((IPartListener)this);
        page.removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public static Net4jIntrospectorView getInstance() {
        return instance;
    }

    public static synchronized Net4jIntrospectorView getInstance(boolean show) {
        if (instance == null) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.showView(VIEW_ID);
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        return instance;
    }

    public void createPartControl(Composite parent) {
        Color bg = parent.getDisplay().getSystemColor(25);
        Color gray = parent.getDisplay().getSystemColor(10);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)UIUtil.createGridLayout(1));
        Composite c = new Composite(composite, 2048);
        c.setLayout((Layout)UIUtil.createGridLayout(2));
        c.setLayoutData((Object)UIUtil.createGridData(true, false));
        this.classLabel = new Text(c, 8);
        this.classLabel.setLayoutData((Object)UIUtil.createGridData(false, false));
        this.classLabel.setBackground(bg);
        this.classLabel.setForeground(gray);
        this.objectLabel = new Text(c, 8);
        this.objectLabel.setLayoutData((Object)UIUtil.createGridData(true, false));
        this.objectLabel.setBackground(bg);
        this.stackLayout = new StackLayout();
        this.stacked = new Composite(composite, 0);
        this.stacked.setLayoutData((Object)UIUtil.createGridData());
        this.stacked.setLayout((Layout)this.stackLayout);
        this.objectViewer = this.createViewer(this.stacked);
        this.createObjectColmuns();
        this.objectViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.objectViewer.setContentProvider((IContentProvider)new ObjectContentProvider());
        this.objectViewer.setLabelProvider((IBaseLabelProvider)new ObjectLabelProvider());
        this.objectViewer.setSorter((ViewerSorter)new NameSorter());
        this.objectViewer.setInput((Object)this.getViewSite());
        this.iterableViewer = this.createViewer(this.stacked);
        this.createIterableColmuns();
        this.iterableViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.iterableViewer.setContentProvider((IContentProvider)new IterableContentProvider());
        this.iterableViewer.setLabelProvider((IBaseLabelProvider)new IterableLabelProvider());
        this.iterableViewer.setInput((Object)this.getViewSite());
        this.arrayViewer = this.createViewer(this.stacked);
        this.createArrayColmuns();
        this.arrayViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.arrayViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.arrayViewer.setLabelProvider((IBaseLabelProvider)new ArrayLabelProvider());
        this.arrayViewer.setInput((Object)this.getViewSite());
        this.mapViewer = this.createViewer(this.stacked);
        this.createMapColmuns();
        this.mapViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.mapViewer.setContentProvider((IContentProvider)new MapContentProvider());
        this.mapViewer.setLabelProvider((IBaseLabelProvider)new MapLabelProvider());
        this.mapViewer.setSorter((ViewerSorter)new NameSorter());
        this.mapViewer.setInput((Object)this.getViewSite());
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        IWorkbenchPage page = this.getSite().getPage();
        page.addPartListener((IPartListener)this);
        page.addSelectionListener((ISelectionListener)this);
        this.setCurrentViewer(this.objectViewer);
        instance = this;
    }

    private void setCurrentViewer(TableViewer viewer) {
        this.currentViewer = viewer;
        this.stackLayout.topControl = this.currentViewer.getControl();
        this.stacked.layout();
    }

    private TableViewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 66306);
        viewer.getTable().setLayoutData((Object)UIUtil.createGridData());
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        return viewer;
    }

    public void refreshViewer() {
        UIUtil.refreshViewer((Viewer)this.currentViewer);
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this) {
            return;
        }
        this.activePart = part;
        if (this.modeAction.isChecked()) {
            this.elements.clear();
            this.setObject(this.activePart);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (this.modeAction.isChecked() && part == this.activePart) {
            this.activePart = null;
            this.setObject(null);
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        if (part == this) {
            return;
        }
        if (this.modeAction.isChecked()) {
            return;
        }
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)sel;
            this.elements.clear();
            this.setObject(ssel.getFirstElement());
        } else {
            this.setObject(null);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)sel;
            Object element = ssel.getFirstElement();
            if (this.currentViewer == this.objectViewer && element instanceof Pair) {
                Pair pair = (Pair)element;
                Field field = (Field)pair.getElement1();
                if (!field.getType().isPrimitive()) {
                    this.setObject(pair.getElement2());
                }
            } else if (this.currentViewer == this.mapViewer && element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                this.setObject(entry.getValue());
            } else if (this.currentViewer == this.iterableViewer) {
                this.setObject(element);
            } else if (this.currentViewer == this.arrayViewer && element instanceof Pair) {
                Pair pair = (Pair)element;
                this.setObject(pair.getElement2());
            }
        }
    }

    public void setFocus() {
        try {
            this.currentViewer.getControl().setFocus();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void notifyEvent(IEvent event) {
        this.refreshViewer();
    }

    public void setObject(Object object) {
        EventUtil.removeListener((Object)object, (IListener)this);
        if (object != null) {
            if (!this.elements.isEmpty()) {
                Object element = this.elements.peek();
                if (element != object) {
                    EventUtil.removeListener((Object)element, (IListener)this);
                    this.elements.push(object);
                }
            } else {
                this.elements.push(object);
            }
        }
        if (object == null) {
            this.classLabel.setText("");
            this.objectLabel.setText("");
            this.currentViewer = this.objectViewer;
        } else {
            EventUtil.addListener((Object)object, (IListener)this);
            String className = object.getClass().getName();
            this.classLabel.setText(className);
            String value = object.toString();
            if (value.startsWith(String.valueOf(className) + "@")) {
                this.objectLabel.setText(value.substring(className.length()));
            } else {
                this.objectLabel.setText(value);
            }
        }
        this.classLabel.getParent().layout();
        this.backAction.setEnabled(this.elements.size() >= 2);
        if (object instanceof Map) {
            this.setCurrentViewer(this.mapViewer);
        } else if (object instanceof Iterable) {
            this.setCurrentViewer(this.iterableViewer);
        } else if (object != null && object.getClass().isArray()) {
            this.setCurrentViewer(this.arrayViewer);
        } else {
            this.setCurrentViewer(this.objectViewer);
        }
        this.refreshViewer();
    }

    private void createObjectColmuns() {
        Table table = this.objectViewer.getTable();
        String[] columnNames = new String[]{Messages.getString("Net4jIntrospectorView_4"), Messages.getString("Net4jIntrospectorView_5"), Messages.getString("Net4jIntrospectorView_6"), Messages.getString("Net4jIntrospectorView_7")};
        int[] columnWidths = new int[]{200, 400, 300, 300};
        this.createColumns(table, columnNames, columnWidths);
    }

    private void createMapColmuns() {
        Table table = this.mapViewer.getTable();
        String[] columnNames = new String[]{Messages.getString("Net4jIntrospectorView_8"), Messages.getString("Net4jIntrospectorView_9"), Messages.getString("Net4jIntrospectorView_10")};
        int[] columnWidths = new int[]{200, 400, 300};
        this.createColumns(table, columnNames, columnWidths);
    }

    private void createIterableColmuns() {
        Table table = this.iterableViewer.getTable();
        String[] columnNames = new String[]{Messages.getString("Net4jIntrospectorView_11"), Messages.getString("Net4jIntrospectorView_12")};
        int[] columnWidths = new int[]{400, 300};
        this.createColumns(table, columnNames, columnWidths);
    }

    private void createArrayColmuns() {
        Table table = this.arrayViewer.getTable();
        String[] columnNames = new String[]{Messages.getString("Net4jIntrospectorView_13"), Messages.getString("Net4jIntrospectorView_14"), Messages.getString("Net4jIntrospectorView_15")};
        int[] columnWidths = new int[]{50, 400, 300};
        this.createColumns(table, columnNames, columnWidths);
    }

    private void createColumns(Table table, String[] columnNames, int[] columnWidths) {
        TableColumn[] columns = new TableColumn[columnNames.length];
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 16384, i);
            column.setText(columnNames[i]);
            column.setWidth(columnWidths[i]);
            column.setMoveable(true);
            column.setResizable(true);
            ++i;
        }
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.backAction);
        manager.add(this.containerAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.modeAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.refreshAction);
    }

    abstract class AbstractContentProvider
    implements IStructuredContentProvider {
        AbstractContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    abstract class AbstractLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        AbstractLabelProvider() {
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    class ArrayContentProvider
    extends AbstractContentProvider {
        ArrayContentProvider() {
        }

        public Object[] getElements(Object parent) {
            Object element;
            if (!Net4jIntrospectorView.this.elements.isEmpty() && (element = Net4jIntrospectorView.this.elements.peek()).getClass().isArray()) {
                Object[] array = (Object[])element;
                Object[] result = new Pair[array.length];
                int i = 0;
                while (i < array.length) {
                    result[i] = Pair.create((Object)i, (Object)array[i]);
                    ++i;
                }
                return result;
            }
            return NO_ELEMENTS;
        }
    }

    class ArrayLabelProvider
    extends AbstractLabelProvider {
        ArrayLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof Pair) {
                try {
                    Pair pair = (Pair)obj;
                    int i = (Integer)pair.getElement1();
                    Object value = pair.getElement2();
                    switch (index) {
                        case 0: {
                            return String.valueOf(i);
                        }
                        case 1: {
                            return value == null ? Messages.getString("Net4jIntrospectorView_24") : value.toString();
                        }
                        case 2: {
                            return value == null ? Messages.getString("Net4jIntrospectorView_25") : value.getClass().getName();
                        }
                    }
                }
                catch (RuntimeException ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            return "";
        }
    }

    class BackAction
    extends Action {
        private BackAction() {
            super(Messages.getString("Net4jIntrospectorView_16"));
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        }

        public void run() {
            if (!Net4jIntrospectorView.this.elements.isEmpty()) {
                Net4jIntrospectorView.this.elements.pop();
                if (!Net4jIntrospectorView.this.elements.isEmpty()) {
                    Net4jIntrospectorView.this.setObject(Net4jIntrospectorView.this.elements.peek());
                }
            }
        }
    }

    class ContainerAction
    extends Action {
        private ContainerAction() {
            super(Messages.getString("Net4jIntrospectorView_17"));
            this.setImageDescriptor(SharedIcons.getDescriptor((String)"view16/container"));
        }

        public void run() {
            Net4jIntrospectorView.this.setObject(IPluginContainer.INSTANCE);
        }
    }

    class IterableContentProvider
    extends AbstractContentProvider {
        IterableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            Object element;
            if (!Net4jIntrospectorView.this.elements.isEmpty() && (element = Net4jIntrospectorView.this.elements.peek()) instanceof Iterable) {
                ArrayList result = new ArrayList();
                for (Object object : (Iterable)element) {
                    result.add(object);
                }
                return result.toArray();
            }
            return NO_ELEMENTS;
        }
    }

    class IterableLabelProvider
    extends AbstractLabelProvider {
        IterableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            switch (index) {
                case 0: {
                    return obj == null ? Messages.getString("Net4jIntrospectorView_21") : obj.toString();
                }
                case 1: {
                    return obj == null ? Messages.getString("Net4jIntrospectorView_22") : obj.getClass().getName();
                }
            }
            return "";
        }
    }

    class MapContentProvider
    extends AbstractContentProvider {
        MapContentProvider() {
        }

        public Object[] getElements(Object parent) {
            Object element;
            if (!Net4jIntrospectorView.this.elements.isEmpty() && (element = Net4jIntrospectorView.this.elements.peek()) instanceof Map) {
                return ((Map)element).entrySet().toArray();
            }
            return NO_ELEMENTS;
        }
    }

    class MapLabelProvider
    extends AbstractLabelProvider {
        MapLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                Object value = entry.getValue();
                switch (index) {
                    case 0: {
                        return key == null ? Messages.getString("Net4jIntrospectorView_27") : key.toString();
                    }
                    case 1: {
                        return value == null ? Messages.getString("Net4jIntrospectorView_28") : value.toString();
                    }
                    case 2: {
                        return value == null ? Messages.getString("Net4jIntrospectorView_29") : value.getClass().getName();
                    }
                }
            }
            return "";
        }
    }

    class ModeAction
    extends Action {
        private ModeAction() {
            super(Messages.getString("Net4jIntrospectorView_17b"), 2);
            this.setImageDescriptor(SharedIcons.getDescriptor((String)"etool16/part_mode"));
        }

        public void run() {
            if (this.isChecked()) {
                Net4jIntrospectorView.this.elements.clear();
                Net4jIntrospectorView.this.setObject(Net4jIntrospectorView.this.activePart);
            } else {
                Net4jIntrospectorView.this.setObject(null);
            }
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ObjectContentProvider
    extends AbstractContentProvider {
        ObjectContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (!Net4jIntrospectorView.this.elements.isEmpty()) {
                try {
                    return ReflectUtil.dumpToArray(Net4jIntrospectorView.this.elements.peek());
                }
                catch (RuntimeException ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            return NO_ELEMENTS;
        }
    }

    class ObjectLabelProvider
    extends AbstractLabelProvider {
        ObjectLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof Pair) {
                try {
                    Pair pair = (Pair)obj;
                    Field field = (Field)pair.getElement1();
                    Object value = pair.getElement2();
                    switch (index) {
                        case 0: {
                            return field.getName();
                        }
                        case 1: {
                            return value == null ? Messages.getString("Net4jIntrospectorView_18") : value.toString();
                        }
                        case 2: {
                            return field.getType().getName();
                        }
                        case 3: {
                            return value == null ? Messages.getString("Net4jIntrospectorView_1") : value.getClass().getName();
                        }
                    }
                }
                catch (RuntimeException ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            return "";
        }
    }

    class RefreshAction
    extends Action {
        private RefreshAction() {
            super("Refresh");
            this.setImageDescriptor(SharedIcons.getDescriptor((String)"etool16/refresh"));
        }

        public void run() {
            Net4jIntrospectorView.this.refreshViewer();
        }
    }
}

