/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.objectteams.otredyn.transformer.jplis.ObjectTeamsTransformer;
import org.osgi.framework.Bundle;

public abstract class DelegatingTransformer {
    @NonNull
    static DelegatingTransformer newTransformer(boolean useDynamicWeaver) {
        if (useDynamicWeaver) {
            return new OTDRETransformer();
        }
        return new OTRETransformer();
    }

    static ClassLoader getBundleLoader(final Bundle bundle) {
        return new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return bundle.loadClass(name);
            }
        };
    }

    public abstract void readOTAttributes(String var1, InputStream var2, String var3, Bundle var4) throws ClassFormatError, IOException;

    public abstract byte[] transform(Bundle var1, String var2, Class<?> var3, ProtectionDomain var4, byte[] var5) throws IllegalClassFormatException;

    public abstract Collection<String> fetchAdaptedBases();

    private static class OTDRETransformer
    extends DelegatingTransformer {
        ObjectTeamsTransformer transformer = new ObjectTeamsTransformer();

        private OTDRETransformer() {
        }

        @Override
        public void readOTAttributes(String className, InputStream inputStream, String fileName, Bundle bundle) throws ClassFormatError, IOException {
            this.transformer.readOTAttributes(className, className.replace('.', '/'), inputStream, OTDRETransformer.getBundleLoader(bundle));
        }

        @Override
        public Collection<String> fetchAdaptedBases() {
            return this.transformer.fetchAdaptedBases();
        }

        @Override
        public byte[] transform(Bundle bundle, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) {
            return this.transformer.transform(OTDRETransformer.getBundleLoader(bundle), className, className.replace('.', '/'), classBeingRedefined, bytes);
        }
    }

    private static class OTRETransformer
    extends DelegatingTransformer {
        org.eclipse.objectteams.otre.jplis.ObjectTeamsTransformer transformer = new org.eclipse.objectteams.otre.jplis.ObjectTeamsTransformer();

        private OTRETransformer() {
        }

        @Override
        public void readOTAttributes(String className, InputStream inputStream, String fileName, Bundle bundle) throws ClassFormatError, IOException {
            this.transformer.readOTAttributes(inputStream, fileName, (Object)bundle);
        }

        @Override
        public Collection<String> fetchAdaptedBases() {
            return this.transformer.fetchAdaptedBases();
        }

        @Override
        public byte[] transform(Bundle bundle, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
            return this.transformer.transform((Object)bundle, className, classBeingRedefined, protectionDomain, bytes);
        }
    }
}

