/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.asm3;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ASM3JavaAnnotationReader {
    private static final Logger logger = Logger.getLogger(ASM3JavaAnnotationReader.class);
    @NonNull
    private final Map<String, Boolean> desc2state = new HashMap<String, Boolean>();
    @NonNull
    private final Set<String> readClasses = new HashSet<String>();
    @NonNull
    private final String nonNullDesc = Type.getDescriptor(NonNull.class);
    @NonNull
    private final String nullableDesc = Type.getDescriptor(Nullable.class);

    @Nullable
    public Boolean getIsNonNull(@NonNull Method method) {
        String requiredDesc;
        block16: {
            final String className = method.getDeclaringClass().getName();
            requiredDesc = String.valueOf(className) + ";" + method.getName() + Type.getMethodDescriptor((Method)method);
            Boolean state = this.desc2state.get(requiredDesc);
            if (state != null) {
                return state;
            }
            if (!this.readClasses.add(className)) {
                return null;
            }
            InputStream classStream = null;
            try {
                try {
                    int flags = 7;
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    String classFileName = String.valueOf(className.replace('.', '/')) + ".class";
                    classStream = contextClassLoader.getResourceAsStream(classFileName);
                    ClassReader cr = new ClassReader(classStream);
                    ClassVisitor cv = new ClassVisitor(){

                        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                            final String methodDesc = String.valueOf(className) + ";" + name + desc;
                            ASM3JavaAnnotationReader.this.desc2state.put(methodDesc, null);
                            return new MethodVisitor(){

                                public AnnotationVisitor visitAnnotation(String annotationDesc, boolean visible) {
                                    if (annotationDesc.equals(ASM3JavaAnnotationReader.this.nonNullDesc)) {
                                        ASM3JavaAnnotationReader.this.desc2state.put(methodDesc, true);
                                    } else if (annotationDesc.equals(ASM3JavaAnnotationReader.this.nullableDesc)) {
                                        ASM3JavaAnnotationReader.this.desc2state.put(methodDesc, false);
                                    }
                                    return null;
                                }

                                public AnnotationVisitor visitAnnotationDefault() {
                                    return null;
                                }

                                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                                    return null;
                                }

                                public void visitAttribute(Attribute attr) {
                                }

                                public void visitCode() {
                                }

                                public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                                }

                                public void visitInsn(int opcode) {
                                }

                                public void visitIntInsn(int opcode, int operand) {
                                }

                                public void visitVarInsn(int opcode, int var) {
                                }

                                public void visitTypeInsn(int opcode, String type) {
                                }

                                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                                }

                                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                                }

                                public void visitJumpInsn(int opcode, Label label) {
                                }

                                public void visitLabel(Label label) {
                                }

                                public void visitLdcInsn(Object cst) {
                                }

                                public void visitIincInsn(int var, int increment) {
                                }

                                public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
                                }

                                public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                                }

                                public void visitMultiANewArrayInsn(String desc, int dims) {
                                }

                                public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                                }

                                public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                                }

                                public void visitLineNumber(int line, Label start) {
                                }

                                public void visitMaxs(int maxStack, int maxLocals) {
                                }

                                public void visitEnd() {
                                }
                            };
                        }

                        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        }

                        public void visitSource(String source, String debug) {
                        }

                        public void visitOuterClass(String owner, String name, String desc) {
                        }

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            return null;
                        }

                        public void visitAttribute(Attribute attr) {
                        }

                        public void visitInnerClass(String name, String outerName, String innerName, int access) {
                        }

                        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                            return null;
                        }

                        public void visitEnd() {
                        }
                    };
                    cr.accept(cv, 7);
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read '" + className + "'"), (Throwable)e);
                    if (classStream != null) {
                        try {
                            classStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (classStream != null) {
                    try {
                        classStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (classStream != null) {
                try {
                    classStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.desc2state.get(requiredDesc);
    }
}

