/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstructorPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElementId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTupleExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTuplePart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.cgmodel.util.AbstractExtendingCGModelVisitor;
import org.eclipse.ocl.examples.codegen.cse.GlobalPlace;
import org.eclipse.ocl.examples.codegen.cse.SimpleAnalysis;
import org.eclipse.ocl.examples.domain.ids.BindingsId;
import org.eclipse.ocl.examples.domain.ids.ClassId;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.DataTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.EnumerationId;
import org.eclipse.ocl.examples.domain.ids.EnumerationLiteralId;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.LambdaTypeId;
import org.eclipse.ocl.examples.domain.ids.MetaclassId;
import org.eclipse.ocl.examples.domain.ids.NestedPackageId;
import org.eclipse.ocl.examples.domain.ids.NsURIPackageId;
import org.eclipse.ocl.examples.domain.ids.OclInvalidTypeId;
import org.eclipse.ocl.examples.domain.ids.OclVoidTypeId;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.ids.PrimitiveTypeId;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.RootPackageId;
import org.eclipse.ocl.examples.domain.ids.SpecializedId;
import org.eclipse.ocl.examples.domain.ids.TemplateBinding;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;
import org.eclipse.ocl.examples.domain.ids.TemplateableTypeId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.ids.UnspecifiedId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;

public class DependencyVisitor
extends AbstractExtendingCGModelVisitor<Object, CodeGenAnalyzer> {
    private static final int TOUCHED = -1;
    protected static final int NOT_AVAILABLE = -2;
    @NonNull
    private Map<CGValuedElement, Set<CGValuedElement>> directDependencies = new HashMap<CGValuedElement, Set<CGValuedElement>>();
    @NonNull
    protected Id2DependencyVisitor id2DependencyVisitor = new Id2DependencyVisitor();
    @NonNull
    protected final GlobalPlace globalPlace;

    public DependencyVisitor(@NonNull CodeGenAnalyzer analyzer, @NonNull GlobalPlace globalPlace) {
        super(analyzer);
        this.globalPlace = globalPlace;
    }

    protected void addDependency(@Nullable CGValuedElement cgElement, @Nullable CGValuedElement dependsOn) {
        cgElement = cgElement != null ? cgElement.getThisValue() : null;
        CGValuedElement cGValuedElement = dependsOn = dependsOn != null ? dependsOn.getThisValue() : null;
        if (cgElement != null && cgElement != dependsOn && (!cgElement.isGlobal() || dependsOn == null || dependsOn.isGlobal())) {
            CGValuedElement cgPrimaryDependsOn;
            CGValuedElement cgPrimaryElement = this.getPrimaryElement(cgElement);
            Set<CGValuedElement> dependencies = this.directDependencies.get(cgPrimaryElement);
            List<CGValuedElement> dependsOns = cgPrimaryElement.getDependsOn();
            if (dependencies == null) {
                dependencies = new HashSet<CGValuedElement>();
                this.directDependencies.put(cgPrimaryElement, dependencies);
                for (CGValuedElement cgDependent : new ArrayList<CGValuedElement>(dependsOns)) {
                    this.addDependency(cgPrimaryElement, cgDependent);
                }
                for (EStructuralFeature eFeature : cgPrimaryElement.eClass().getEAllStructuralFeatures()) {
                    EReference eReference;
                    if (!(eFeature instanceof EReference) || (eReference = (EReference)eFeature).isDerived() || eReference.isTransient() || eReference.isVolatile()) continue;
                    Object childOrChildren = cgPrimaryElement.eGet((EStructuralFeature)eReference);
                    if (eReference.isMany()) {
                        for (Object child : new ArrayList((List)childOrChildren)) {
                            if (!(child instanceof CGValuedElement)) continue;
                            this.addDependency(cgPrimaryElement, (CGValuedElement)child);
                        }
                        continue;
                    }
                    if (!(childOrChildren instanceof CGValuedElement) || childOrChildren == cgPrimaryElement.eContainer()) continue;
                    this.addDependency(cgPrimaryElement, (CGValuedElement)childOrChildren);
                }
            }
            if (dependsOn != null && (cgPrimaryDependsOn = this.getPrimaryElement(dependsOn)) != cgPrimaryElement) {
                dependencies.add(cgPrimaryDependsOn);
                if (!dependsOns.contains(cgPrimaryDependsOn)) {
                    dependsOns.add(cgPrimaryDependsOn);
                }
            }
        }
    }

    private void addElementIdDependency(@NonNull CGValuedElement cgValuedElement) {
        CGTypeId cgTypeId = cgValuedElement.getTypeId();
        this.addDependency(cgValuedElement, cgTypeId);
    }

    private void addElementIdDependency(@NonNull ElementId elementId, @NonNull ElementId dependsOn) {
        CGElementId cgElementId = ((CodeGenAnalyzer)this.context).getElementId(elementId);
        CGElementId cgDependsOn = ((CodeGenAnalyzer)this.context).getElementId(dependsOn);
        dependsOn.accept((IdVisitor)this.id2DependencyVisitor);
        this.addDependency(cgElementId, cgDependsOn);
    }

    private int computeDepths(@NonNull CGValuedElement cgElement, @NonNull Map<CGValuedElement, Integer> dependencyDepths, boolean isGlobal) {
        if (isGlobal) assert (cgElement.isGlobal());
        CGValuedElement cgPrimaryElement = this.getPrimaryElement(cgElement);
        if (isGlobal) assert (cgPrimaryElement.isGlobal());
        Set<CGValuedElement> dependencies = this.directDependencies.get(cgPrimaryElement);
        if (dependencies == null) {
            int depth = this.getRootDepth(cgPrimaryElement);
            dependencyDepths.put(cgPrimaryElement, depth);
            return depth;
        }
        Integer knownDepth = dependencyDepths.get(cgPrimaryElement);
        if (knownDepth != null) {
            if (knownDepth != -1) {
                return knownDepth;
            }
            throw new IllegalStateException("Cyclic dependency for " + cgPrimaryElement);
        }
        dependencyDepths.put(cgPrimaryElement, -1);
        int maxDepth = 0;
        for (CGValuedElement dependency : dependencies) {
            int depth = this.computeDepths(dependency, dependencyDepths, isGlobal);
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        int myDepth = maxDepth + 1;
        dependencyDepths.put(cgPrimaryElement, myDepth);
        return myDepth;
    }

    @NonNull
    public CGValuedElement getPrimaryElement(@NonNull CGValuedElement cgElement) {
        SimpleAnalysis simpleAnalysis = this.globalPlace.getSimpleAnalysis(cgElement);
        if (simpleAnalysis != null) {
            return simpleAnalysis.getPrimaryElement();
        }
        return cgElement;
    }

    public int getRootDepth(@NonNull CGValuedElement cgElement) {
        if (cgElement instanceof CGIterator) {
            return -2;
        }
        return 0;
    }

    @NonNull
    public List<CGValuedElement> getSortedDependencies(boolean isGlobal) {
        final HashMap<CGValuedElement, Integer> dependencyDepths = new HashMap<CGValuedElement, Integer>();
        for (CGValuedElement cgElement : this.directDependencies.keySet()) {
            this.computeDepths(cgElement, dependencyDepths, isGlobal);
        }
        ArrayList<CGValuedElement> sortedList = new ArrayList<CGValuedElement>();
        for (CGValuedElement cgElement : dependencyDepths.keySet()) {
            if (cgElement.isInlined() || cgElement.getThisValue() != cgElement) continue;
            if (isGlobal) assert (cgElement.isGlobal());
            sortedList.add(cgElement);
        }
        Collections.sort(sortedList, new Comparator<CGValuedElement>(){

            @Override
            public int compare(CGValuedElement o1, CGValuedElement o2) {
                String n2;
                int d2;
                int d1 = (Integer)dependencyDepths.get(o1);
                if (d1 != (d2 = ((Integer)dependencyDepths.get(o2)).intValue())) {
                    return d1 - d2;
                }
                String n1 = String.valueOf(o1.getName());
                int diff = n1.compareTo(n2 = String.valueOf(o2.getName()));
                if (diff != 0) {
                    return diff;
                }
                String s1 = String.valueOf(o1);
                String s2 = String.valueOf(o2);
                return s1.compareTo(s2);
            }
        });
        return sortedList;
    }

    public void visit(@NonNull CGNamedElement cgElement) {
        if (cgElement instanceof CGValuedElement) {
            CGValuedElement cgPrimaryElement = this.getPrimaryElement(((CGValuedElement)cgElement).getThisValue());
            this.addDependency(cgPrimaryElement, null);
            cgPrimaryElement.accept(this);
        } else {
            cgElement.accept(this);
        }
    }

    public void visitAll(@Nullable Iterable<? extends CGNamedElement> cgElements) {
        if (cgElements != null) {
            for (CGNamedElement cGNamedElement : cgElements) {
                if (cGNamedElement == null) continue;
                this.visit(cGNamedElement);
            }
        }
    }

    @Override
    @Nullable
    public Object visitCGCollectionExp(@NonNull CGCollectionExp cgCollectionExp) {
        this.addElementIdDependency(cgCollectionExp);
        for (CGCollectionPart cgCollectionPart : cgCollectionExp.getParts()) {
            this.addDependency(cgCollectionExp, cgCollectionPart);
        }
        return super.visitCGCollectionExp(cgCollectionExp);
    }

    @Override
    @Nullable
    public Object visitCGConstructorPart(@NonNull CGConstructorPart cgConstructorPart) {
        this.addDependency(cgConstructorPart, cgConstructorPart.getInit());
        return super.visitCGConstructorPart(cgConstructorPart);
    }

    @Override
    @Nullable
    public Object visitCGCollectionPart(@NonNull CGCollectionPart cgCollectionPart) {
        CGCollectionExp cgCollectionExp = cgCollectionPart.getCollectionExp();
        this.addDependency(cgCollectionExp, cgCollectionPart.getFirst());
        this.addDependency(cgCollectionExp, cgCollectionPart.getLast());
        return super.visitCGCollectionPart(cgCollectionPart);
    }

    @Override
    @Nullable
    public Object visitCGConstantExp(@NonNull CGConstantExp visitCGConstantExp) {
        this.addDependency(visitCGConstantExp, visitCGConstantExp.getNamedValue());
        return super.visitCGConstantExp(visitCGConstantExp);
    }

    @Override
    @Nullable
    public Object visitCGElement(@NonNull CGElement cgElement) {
        for (CGElement cGElement : cgElement.getChildren()) {
            if (cgElement instanceof CGValuedElement && cGElement instanceof CGValuedElement) {
                this.addDependency((CGValuedElement)cgElement, (CGValuedElement)cGElement);
            }
            cGElement.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGElementId(@NonNull CGElementId cgElementId) {
        cgElementId.getElementId().accept((IdVisitor)this.id2DependencyVisitor);
        return super.visitCGElementId(cgElementId);
    }

    @Override
    @Nullable
    public Object visitCGTuplePart(@NonNull CGTuplePart cgTuplePart) {
        this.addDependency(cgTuplePart, cgTuplePart.getInit());
        return super.visitCGTuplePart(cgTuplePart);
    }

    @Override
    @Nullable
    public Object visitCGTupleExp(@NonNull CGTupleExp cgTupleExp) {
        this.addElementIdDependency(cgTupleExp);
        return super.visitCGTupleExp(cgTupleExp);
    }

    @Override
    @Nullable
    public Object visitCGVariable(@NonNull CGVariable cgVariable) {
        CGValuedElement init = cgVariable.getInit();
        this.addDependency(cgVariable, init);
        return super.visitCGVariable(cgVariable);
    }

    @Override
    @Nullable
    public Object visitCGVariableExp(@NonNull CGVariableExp cgVariableExp) {
        this.addDependency(cgVariableExp, cgVariableExp.getReferredVariable());
        return super.visitCGVariableExp(cgVariableExp);
    }

    @Override
    @Nullable
    public Object visiting(@NonNull CGElement visitable) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    public class Id2DependencyVisitor
    implements IdVisitor<Object> {
        @Nullable
        public Object visitClassId(@NonNull ClassId id) {
            DependencyVisitor.this.addElementIdDependency((ElementId)id, (ElementId)id.getParent());
            return null;
        }

        @Nullable
        public Object visitCollectionTypeId(@NonNull CollectionTypeId id) {
            if (id instanceof SpecializedId) {
                BindingsId templateBindings = ((SpecializedId)id).getTemplateBindings();
                int i = 0;
                while (i < templateBindings.size()) {
                    ElementId elementId = (ElementId)DomainUtil.nonNullModel((Object)((ElementId)templateBindings.get(i)));
                    DependencyVisitor.this.addElementIdDependency((ElementId)id, elementId);
                    ++i;
                }
            }
            return null;
        }

        @Nullable
        public Object visitDataTypeId(@NonNull DataTypeId id) {
            DependencyVisitor.this.addElementIdDependency((ElementId)id, (ElementId)id.getParent());
            return null;
        }

        @Nullable
        public Object visitEnumerationId(@NonNull EnumerationId id) {
            DependencyVisitor.this.addElementIdDependency((ElementId)id, (ElementId)id.getParent());
            return null;
        }

        @Nullable
        public Object visitEnumerationLiteralId(@NonNull EnumerationLiteralId id) {
            DependencyVisitor.this.addElementIdDependency((ElementId)id, (ElementId)id.getParentId());
            return null;
        }

        @Nullable
        public Object visitInvalidId(@NonNull OclInvalidTypeId id) {
            return null;
        }

        @Nullable
        public Object visitLambdaTypeId(@NonNull LambdaTypeId id) {
            return this.visiting((ElementId)id);
        }

        @Nullable
        public Object visitMetaclassId(@NonNull MetaclassId id) {
            if (id != TypeId.METACLASS) {
                DependencyVisitor.this.addElementIdDependency((ElementId)id, id.getElementId());
            }
            return null;
        }

        @Nullable
        public Object visitNestedPackageId(@NonNull NestedPackageId id) {
            DependencyVisitor.this.addElementIdDependency((ElementId)id, (ElementId)id.getParent());
            return null;
        }

        @Nullable
        public Object visitNsURIPackageId(@NonNull NsURIPackageId id) {
            return null;
        }

        @Nullable
        public Object visitNullId(@NonNull OclVoidTypeId id) {
            return null;
        }

        @Nullable
        public Object visitOperationId(@NonNull OperationId id) {
            DependencyVisitor.this.addElementIdDependency((ElementId)id, (ElementId)id.getParent());
            for (TypeId parameterId : id.getParametersId()) {
                DependencyVisitor.this.addElementIdDependency((ElementId)id, (ElementId)parameterId);
            }
            return null;
        }

        @Nullable
        public Object visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
            return null;
        }

        @Nullable
        public Object visitPropertyId(@NonNull PropertyId id) {
            DependencyVisitor.this.addElementIdDependency((ElementId)id, (ElementId)id.getParent());
            return null;
        }

        @Nullable
        public Object visitRootPackageId(@NonNull RootPackageId id) {
            return null;
        }

        @Nullable
        public Object visitTemplateBinding(@NonNull TemplateBinding id) {
            return this.visiting((ElementId)id);
        }

        @Nullable
        public Object visitTemplateParameterId(@NonNull TemplateParameterId id) {
            return null;
        }

        @Nullable
        public Object visitTemplateableTypeId(@NonNull TemplateableTypeId id) {
            return this.visiting((ElementId)id);
        }

        @Nullable
        public Object visitTuplePartId(@NonNull TuplePartId id) {
            DependencyVisitor.this.addElementIdDependency((ElementId)id, (ElementId)id.getTypeId());
            return null;
        }

        @Nullable
        public Object visitTupleTypeId(@NonNull TupleTypeId id) {
            TuplePartId[] tuplePartIdArray = id.getPartIds();
            int n = tuplePartIdArray.length;
            int n2 = 0;
            while (n2 < n) {
                TuplePartId partId = tuplePartIdArray[n2];
                DependencyVisitor.this.addElementIdDependency((ElementId)id, (ElementId)partId);
                ++n2;
            }
            return null;
        }

        @Nullable
        public Object visitUnspecifiedId(@NonNull UnspecifiedId id) {
            return this.visiting((ElementId)id);
        }

        @Nullable
        public Object visiting(@NonNull ElementId id) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + id.getClass().getName());
        }
    }
}

