/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.java.types.JavaTypeId;
import org.eclipse.ocl.examples.domain.elements.DomainLambdaType;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.ClassId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.LambdaTypeId;
import org.eclipse.ocl.examples.domain.ids.NestedPackageId;
import org.eclipse.ocl.examples.domain.ids.NsURIPackageId;
import org.eclipse.ocl.examples.domain.ids.OclInvalidTypeId;
import org.eclipse.ocl.examples.domain.ids.OclVoidTypeId;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.ids.PrimitiveTypeId;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.RootPackageId;
import org.eclipse.ocl.examples.domain.ids.TemplateBinding;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;
import org.eclipse.ocl.examples.domain.ids.TemplateableTypeId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.ids.UnspecifiedId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.IntegerRange;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

public abstract class AbstractId2JavaClassVisitor
implements IdVisitor<Class<?>> {
    @NonNull
    protected final GenModelHelper genModelHelper;

    protected AbstractId2JavaClassVisitor(@NonNull GenModelHelper genModelHelper) {
        this.genModelHelper = genModelHelper;
    }

    @NonNull
    public Class<?> doVisit(@NonNull ElementId elementId) {
        return (Class)DomainUtil.nonNullState((Object)((Class)elementId.accept((IdVisitor)this)));
    }

    @NonNull
    public Class<?> visitClassId(@NonNull ClassId id) {
        MetaModelManager metaModelManager = this.genModelHelper.getMetaModelManager();
        Type type = metaModelManager.getIdResolver().getType((TypeId)id, null);
        EClass eClass = (EClass)type.getETarget();
        if (eClass != null) {
            try {
                return this.genModelHelper.getEcoreInterfaceClassifier((EClassifier)eClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Object.class;
    }

    @NonNull
    public Class<?> visitInvalidId(@NonNull OclInvalidTypeId id) {
        return InvalidValueException.class;
    }

    @NonNull
    public Class<?> visitLambdaTypeId(@NonNull LambdaTypeId id) {
        return DomainLambdaType.class;
    }

    @NonNull
    public Class<?> visitNestedPackageId(@NonNull NestedPackageId id) {
        return DomainPackage.class;
    }

    @NonNull
    public Class<?> visitNsURIPackageId(@NonNull NsURIPackageId id) {
        return DomainPackage.class;
    }

    @NonNull
    public Class<?> visitNullId(@NonNull OclVoidTypeId id) {
        return Object.class;
    }

    @NonNull
    public Class<?> visitOperationId(@NonNull OperationId id) {
        return DomainOperation.class;
    }

    @Nullable
    public Class<?> visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
        if (id instanceof JavaTypeId) {
            return ((JavaTypeId)id).getJavaClass();
        }
        if (id == TypeId.BOOLEAN) {
            return Boolean.class;
        }
        if (id == TypeId.INTEGER_RANGE) {
            return IntegerRange.class;
        }
        if (id == TypeId.OCL_ANY) {
            return Object.class;
        }
        if (id == TypeId.OCL_COMPARABLE) {
            return Object.class;
        }
        if (id == TypeId.OCL_SUMMABLE) {
            return Object.class;
        }
        if (id == TypeId.STRING) {
            return String.class;
        }
        return null;
    }

    @NonNull
    public Class<?> visitPropertyId(@NonNull PropertyId id) {
        return DomainProperty.class;
    }

    @NonNull
    public Class<?> visitRootPackageId(@NonNull RootPackageId id) {
        return DomainPackage.class;
    }

    @NonNull
    public Class<?> visitTemplateBinding(@NonNull TemplateBinding id) {
        return this.visiting((ElementId)id);
    }

    @NonNull
    public Class<?> visitTemplateParameterId(@NonNull TemplateParameterId id) {
        return Object.class;
    }

    @NonNull
    public Class<?> visitTemplateableTypeId(@NonNull TemplateableTypeId id) {
        return DomainType.class;
    }

    @NonNull
    public Class<?> visitTuplePartId(@NonNull TuplePartId id) {
        return DomainProperty.class;
    }

    @NonNull
    public Class<?> visitTupleTypeId(@NonNull TupleTypeId id) {
        return TupleValue.class;
    }

    @NonNull
    public Class<?> visitUnspecifiedId(@NonNull UnspecifiedId id) {
        return this.visiting((ElementId)id);
    }

    @NonNull
    public Class<?> visiting(@NonNull ElementId id) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + id.getClass().getName());
    }
}

