/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.iteration;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBuiltInIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.java.JavaConstants;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.iteration.AbstractAccumulation2Java;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

public class IsUniqueIteration2Java
extends AbstractAccumulation2Java {
    @NonNull
    public static final IsUniqueIteration2Java INSTANCE = new IsUniqueIteration2Java();

    @Override
    public void appendAccumulatorInit(@NonNull JavaStream js, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        CGTypeId cgAccumulatorId = cgIterationCallExp.getSource().getTypeId();
        CollectionTypeId elementId = (CollectionTypeId)cgAccumulatorId.getElementId();
        js.appendClassReference(ValuesUtil.class);
        js.append(".createSetAccumulatorValue(");
        js.appendIdReference((ElementId)(elementId != null ? elementId : TypeId.OCL_VOID));
        js.append(")");
    }

    @Override
    public boolean appendFinalValue(@NonNull JavaStream js, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        return js.appendAssignment(cgIterationCallExp, js.getCodeGenerator().getAnalyzer().getBoolean(true));
    }

    @Override
    public boolean appendUpdate(@NonNull JavaStream js, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        CGValuedElement cgBody = this.getBody(cgIterationCallExp);
        CGIterator cgAccumulator = this.getAccumulator(cgIterationCallExp);
        js.append("if (");
        js.appendValueName(cgAccumulator);
        js.append(".includes(");
        js.appendValueName(cgBody);
        js.append(") == ");
        js.appendClassReference(ValuesUtil.class);
        js.append(".TRUE_VALUE) {\n");
        js.pushIndentation(null);
        js.appendValueName(cgIterationCallExp);
        js.append(" = ");
        js.appendClassReference(ValuesUtil.class);
        js.append(".FALSE_VALUE;\t\t\t// Abort after second find\n");
        js.append("break;\n");
        js.popIndentation();
        js.append("}\n");
        js.append("else {\n");
        js.pushIndentation(null);
        js.appendValueName(cgAccumulator);
        js.append(".add(");
        js.appendValueName(cgBody);
        js.append(");\n");
        js.popIndentation();
        js.append("}\n");
        return true;
    }

    @Override
    @Nullable
    public CGTypeId getAccumulatorTypeId(@NonNull CodeGenAnalyzer analyzer, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        Class<?> accumulatorClass = this.getAccumulatorClass(analyzer, TypeId.SET);
        return analyzer.getTypeId(JavaConstants.getJavaTypeId(accumulatorClass));
    }
}

