/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.AbstractDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.CollectionDescriptor;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.TypeId;

public abstract class AbstractCollectionDescriptor
extends AbstractDescriptor
implements CollectionDescriptor {
    public AbstractCollectionDescriptor(@NonNull CollectionTypeId collectionTypeId) {
        super((ElementId)collectionTypeId);
    }

    @Override
    public void append(@NonNull JavaStream javaStream, boolean reClass) {
        this.append(javaStream);
    }

    @Override
    @NonNull
    public Boolean appendBox(@NonNull JavaStream js, @NonNull JavaLocalContext localContext, @NonNull CGBoxExp cgBoxExp, @NonNull CGValuedElement unboxedValue) {
        TypeId typeId = unboxedValue.getASTypeId();
        js.appendDeclaration(cgBoxExp);
        js.append(" = ");
        if (!unboxedValue.isNonNull()) {
            js.appendReferenceTo(unboxedValue);
            js.append(" == null ? null : ");
        }
        String collectionName = "Collection";
        if (typeId instanceof CollectionTypeId) {
            collectionName = ((CollectionTypeId)typeId).getGeneralizedId().getName();
        }
        js.appendReferenceTo(localContext.getIdResolverVariable(cgBoxExp));
        js.append(".create" + collectionName + "OfAll(");
        js.appendIdReference((ElementId)typeId);
        js.append(", ");
        js.appendReferenceTo(Iterable.class, unboxedValue);
        js.append(")");
        js.append(";\n");
        return true;
    }

    @Override
    public void appendElement(@NonNull JavaStream javaStream, boolean reClass) {
        javaStream.append(this.getClassName());
    }

    @Override
    @Nullable
    public CollectionDescriptor asCollectionDescriptor() {
        return this;
    }

    @Override
    @NonNull
    public CollectionTypeId getElementId() {
        return (CollectionTypeId)super.getElementId();
    }

    @Override
    public boolean isAssignableTo(@NonNull Class<?> javaClass) {
        return javaClass.isAssignableFrom(List.class);
    }

    @Override
    @NonNull
    public String toString() {
        return this.elementId + " => List<" + this.getClassName() + ">";
    }
}

