/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.SimpleDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.SimpleValueDescriptor;
import org.eclipse.ocl.examples.domain.ids.ElementId;

public class BooleanPrimitiveDescriptor
extends SimpleValueDescriptor
implements SimpleDescriptor {
    public BooleanPrimitiveDescriptor(@NonNull ElementId elementId) {
        super(elementId, Boolean.TYPE);
    }

    @Override
    public void append(@NonNull JavaStream js) {
        js.append("boolean");
    }

    @Override
    public void appendCast(@NonNull JavaStream js, @Nullable Class<?> actualJavaClass, @Nullable JavaStream.SubStream subStream) {
        if (subStream != null && actualJavaClass == Boolean.class) {
            subStream.append();
            js.append(".booleanValue()");
        } else {
            js.append("(");
            js.appendClassReference(Boolean.class);
            js.append(")");
            if (subStream != null) {
                subStream.append();
            }
        }
    }

    @Override
    public void appendNotEqualsTerm(@NonNull JavaStream js, @NonNull CGValuedElement thisValue, @NonNull TypeDescriptor thatTypeDescriptor, @NonNull String thatName) {
        if (thatTypeDescriptor instanceof BooleanPrimitiveDescriptor) {
            js.appendValueName(thisValue);
            js.append(" != ");
            js.append(thatName);
        } else {
            js.append("(");
            js.append(thatName);
            js.append(" == null) || (");
            js.appendValueName(thisValue);
            js.append(" != ");
            js.append(thatName);
            js.append(")");
        }
    }

    @Override
    public void appendEqualsValue(@NonNull JavaStream js, @NonNull CGValuedElement thisValue, @NonNull CGValuedElement thatValue, boolean notEquals) {
        js.appendValueName(thisValue);
        js.append(notEquals ? " != " : " == ");
        js.appendValueName(thatValue);
    }
}

