/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.AbstractCollectionDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;

public class EObjectsDescriptor
extends AbstractCollectionDescriptor
implements UnboxedDescriptor {
    @NonNull
    protected final EClassifier eClassifier;
    @NonNull
    protected final Class<?> javaClass;
    @NonNull
    protected final Class<?> oldJavaClass;

    public EObjectsDescriptor(@NonNull CollectionTypeId collectionTypeId, @NonNull EClassifier eClassifier, @NonNull Class<?> javaClass) {
        super(collectionTypeId);
        this.eClassifier = eClassifier;
        this.javaClass = javaClass;
        this.oldJavaClass = EObjectsDescriptor.reClass(javaClass);
    }

    @Override
    public void append(@NonNull JavaStream javaStream) {
        javaStream.appendClassReference(List.class, this.javaClass != this.oldJavaClass, this.oldJavaClass);
    }

    @Override
    public void append(@NonNull JavaStream javaStream, boolean reClass) {
        javaStream.appendClassReference(List.class, this.javaClass != this.oldJavaClass, reClass ? this.javaClass : this.oldJavaClass);
    }

    @Override
    public void appendElement(@NonNull JavaStream javaStream, boolean reClass) {
        javaStream.appendClassReference(reClass ? this.javaClass : this.oldJavaClass);
    }

    @Override
    @NonNull
    public String getClassName() {
        return this.javaClass.getName();
    }

    @Override
    @NonNull
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    @NonNull
    public UnboxedDescriptor getUnboxedDescriptor() {
        return this;
    }

    @Override
    @Nullable
    public Class<?> hasJavaClass() {
        return this.javaClass;
    }

    @Override
    public final boolean isAssignableFrom(@NonNull TypeDescriptor typeDescriptor) {
        if (!(typeDescriptor instanceof EObjectsDescriptor)) {
            return false;
        }
        return this.javaClass.isAssignableFrom(typeDescriptor.getJavaClass());
    }
}

