/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinecore;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstraint;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInvalid;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.java.CG2JavaVisitor;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreGlobalContext;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreLocalContext;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.osgi.util.NLS;

public class OCLinEcoreCG2JavaVisitor
extends CG2JavaVisitor {
    @NonNull
    protected final GenPackage genPackage;
    @NonNull
    protected final CGPackage cgPackage;
    protected ExpressionInOCL expInOcl;
    protected Feature feature;

    public OCLinEcoreCG2JavaVisitor(@NonNull JavaCodeGenerator codeGenerator, @NonNull GenPackage genPackage, @NonNull CGPackage cgPackage) {
        super(codeGenerator);
        this.genPackage = genPackage;
        this.cgPackage = cgPackage;
    }

    @Override
    protected void appendGlobalPrefix() {
        this.js.append(this.getGlobalContext().getTablesClassName());
        this.js.append(".");
    }

    @NonNull
    public Map<String, String> generateBodies() {
        HashMap<String, String> bodies = new HashMap<String, String>();
        for (CGClass cgClass : this.cgPackage.getClasses()) {
            String fragmentURI;
            String bodyText;
            String returnClassName;
            CGValuedElement cgBody;
            for (CGConstraint cgConstraint : cgClass.getInvariants()) {
                cgBody = cgConstraint.getBody();
                Element pivotClass = cgClass.getAst();
                Element asElement = cgConstraint.getAst();
                if (cgBody == null || !(pivotClass instanceof Type) || !(asElement instanceof Constraint)) continue;
                Constraint asConstraint = (Constraint)asElement;
                this.localContext = this.globalContext.getLocalContext(cgConstraint);
                String bodyText2 = this.generateValidatorBody(cgBody, asConstraint, (Type)pivotClass);
                String fragmentURI2 = String.valueOf(this.getFragmentURI(pivotClass)) + "==" + this.getRuleName(asConstraint);
                bodies.put(fragmentURI2, bodyText2);
            }
            for (CGOperation cgOperation : cgClass.getOperations()) {
                cgBody = cgOperation.getBody();
                Element asOperation = cgOperation.getAst();
                if (cgBody == null || !(asOperation instanceof Operation)) continue;
                returnClassName = this.genModelHelper.getOperationReturnType((Operation)asOperation);
                this.localContext = this.globalContext.getLocalContext(cgOperation);
                bodyText = this.generateBody(cgBody, returnClassName);
                fragmentURI = this.getFragmentURI(asOperation);
                bodies.put(fragmentURI, bodyText);
            }
            for (CGProperty cgProperty : cgClass.getProperties()) {
                cgBody = cgProperty.getBody();
                Element asProperty = cgProperty.getAst();
                if (cgBody == null || !(asProperty instanceof Property)) continue;
                returnClassName = this.genModelHelper.getPropertyResultType((Property)asProperty);
                this.localContext = this.globalContext.getLocalContext(cgProperty);
                bodyText = this.generateBody(cgBody, returnClassName);
                fragmentURI = this.getFragmentURI(asProperty);
                bodies.put(fragmentURI, bodyText);
            }
        }
        this.localContext = null;
        return bodies;
    }

    @NonNull
    protected String generateBody(@NonNull CGValuedElement cgBody, @NonNull String returnClassName) {
        this.js.resetStream();
        this.js.appendCommentWithOCL(null, cgBody.getAst());
        this.js.appendLocalStatements(cgBody);
        CGInvalid cgInvalidValue = cgBody.getInvalidValue();
        if (cgInvalidValue != null) {
            this.js.append("throw new ");
            this.js.appendValueName(cgInvalidValue);
        } else {
            this.js.append("return ");
            this.js.appendEcoreValue(returnClassName, cgBody);
        }
        this.js.append(";");
        return this.toString();
    }

    @NonNull
    public String generateConstants(List<CGValuedElement> sortedGlobals) {
        this.js.resetStream();
        this.js.pushIndentation(null);
        if (sortedGlobals != null) {
            this.generateGlobals(sortedGlobals);
        }
        return this.toString();
    }

    @NonNull
    protected String generateValidatorBody(@NonNull CGValuedElement cgBody, @NonNull Constraint asConstraint, @NonNull Type asType) {
        String genClassifierName;
        this.js.resetStream();
        String constraintName = asConstraint.getName();
        GenClassifier genClassifier = this.genModelHelper.getGenClassifier(asType);
        String string = genClassifierName = genClassifier != null ? genClassifier.getName() : null;
        if (genClassifierName == null) {
            genClassifierName = "";
        }
        String constraintLiteralName = String.valueOf(CodeGenUtil.upperName((String)genClassifierName)) + "__" + CodeGenUtil.upperName((String)(constraintName != null ? constraintName : ""));
        String validatorClass = this.genModelHelper.getQualifiedValidatorClassName(this.genPackage);
        this.js.appendCommentWithOCL(null, (Element)asConstraint);
        if (this.js.appendLocalStatements(cgBody)) {
            if (cgBody.isTrue()) {
                this.js.append("return true;");
            } else {
                this.js.append("if (");
                this.js.appendValueName(cgBody);
                this.js.append(" == ");
                this.js.appendClassReference(ValuesUtil.class);
                this.js.append(".TRUE_VALUE) {\n");
                this.js.pushIndentation(null);
                this.js.append("return true;\n");
                this.js.popIndentation();
                this.js.append("}\n");
                this.js.append("if (diagnostics != null) {\n");
                this.js.pushIndentation(null);
                this.js.append("int ");
                this.js.append(this.getLocalContext().getSeverityName());
                this.js.append(" = ");
                if (cgBody.isNull()) {
                    this.js.appendClassReference(Diagnostic.class);
                    this.js.append(".ERROR : ");
                } else if (cgBody.isNonNull()) {
                    this.js.appendClassReference(Diagnostic.class);
                    this.js.append(".WARNING;\n");
                } else {
                    this.js.appendValueName(cgBody);
                    this.js.append(" == null ? ");
                    this.js.appendClassReference(Diagnostic.class);
                    this.js.append(".ERROR : ");
                    this.js.appendClassReference(Diagnostic.class);
                    this.js.append(".WARNING;\n");
                }
                this.js.appendClassReference(String.class);
                this.js.append(" " + this.getLocalContext().getMessageName() + " = ");
                this.js.appendClassReference(NLS.class);
                this.js.append(".bind(");
                this.js.appendClassReference(EvaluatorMessages.class);
                this.js.append(".ValidationConstraintIsNotSatisfied_ERROR_, new Object[]{\"");
                this.js.append(genClassifierName);
                this.js.append("\", \"");
                this.js.append(constraintName != null ? constraintName : "UnnamedConstraint");
                this.js.append("\", ");
                this.js.appendClassReference(EObjectValidator.class);
                this.js.append(".getObjectLabel(this, context)});\n");
                this.js.append("diagnostics.add(new ");
                this.js.appendClassReference(BasicDiagnostic.class);
                this.js.append("(" + this.getLocalContext().getSeverityName() + ", ");
                this.js.appendClassReference(validatorClass);
                this.js.append(".DIAGNOSTIC_SOURCE, ");
                this.js.appendClassReference(validatorClass);
                this.js.append("." + constraintLiteralName + ", " + this.getLocalContext().getMessageName() + ", new Object [] { this }));\n");
                this.js.popIndentation();
                this.js.append("}\n");
                this.js.append("return false;");
            }
        }
        return this.toString();
    }

    protected String getFragmentURI(@NonNull Element element) {
        return EcoreUtil.getURI((EObject)element).fragment().toString();
    }

    @NonNull
    protected OCLinEcoreGlobalContext getGlobalContext() {
        return (OCLinEcoreGlobalContext)this.globalContext;
    }

    @NonNull
    protected OCLinEcoreLocalContext getLocalContext() {
        return (OCLinEcoreLocalContext)DomainUtil.nonNullState((Object)((OCLinEcoreLocalContext)this.localContext));
    }

    protected String getRuleName(@NonNull Constraint constraint) {
        String name = constraint.getName();
        return name != null ? name : "";
    }

    @Override
    @NonNull
    public Boolean visitCGClass(@NonNull CGClass cgClass) {
        return true;
    }

    @Override
    @NonNull
    public Boolean visitCGConstantExp(@NonNull CGConstantExp cgConstantExp) {
        CGValuedElement globalConstant = cgConstantExp.getReferredConstant();
        if (globalConstant != null) {
            if (!cgConstantExp.isInlined()) {
                this.appendGlobalPrefix();
            }
            this.js.appendValueName(globalConstant);
        }
        return true;
    }

    @Override
    @NonNull
    public Boolean visitCGOperation(@NonNull CGOperation cgOperation) {
        return true;
    }

    @Override
    @NonNull
    public Boolean visitCGPackage(@NonNull CGPackage cgPackage) {
        return true;
    }
}

