/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinecore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreGenModelGeneratorAdapter;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreTablesUtils;
import org.eclipse.ocl.examples.domain.elements.DomainParameterTypes;
import org.eclipse.ocl.examples.domain.elements.DomainTypeParameters;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorEnumeration;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorEnumerationLiteral;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorInvalidType;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorPackage;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorProperty;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorType;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorVoidType;
import org.eclipse.ocl.examples.library.ecore.EcoreLibraryOppositeProperty;
import org.eclipse.ocl.examples.library.executor.ExecutorFragment;
import org.eclipse.ocl.examples.library.executor.ExecutorOperation;
import org.eclipse.ocl.examples.library.executor.ExecutorProperty;
import org.eclipse.ocl.examples.library.executor.ExecutorPropertyWithImplementation;
import org.eclipse.ocl.examples.library.executor.ExecutorStandardLibrary;
import org.eclipse.ocl.examples.library.executor.ExecutorType;
import org.eclipse.ocl.examples.library.executor.ExecutorTypeParameter;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OrderedSetType;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.SequenceType;
import org.eclipse.ocl.examples.pivot.SetType;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class OCLinEcoreTables
extends OCLinEcoreTablesUtils {
    protected final boolean useNullAnnotations;

    public OCLinEcoreTables(@NonNull GenPackage genPackage) {
        super(genPackage);
        GenModel genModel = (GenModel)DomainUtil.nonNullState((Object)genPackage.getGenModel());
        this.useNullAnnotations = OCLinEcoreGenModelGeneratorAdapter.useNullAnnotations(genModel);
    }

    protected void appendConstants(@NonNull String constants) {
        this.s.append("\t/**\n");
        this.s.append("\t *\tConstants used by auto-generated code.\n");
        this.s.append("\t */\n");
        int i = 0;
        while (i < constants.length()) {
            int k;
            int j = constants.indexOf("<%", i);
            if (j < 0 || (k = constants.indexOf("%>", j + 2)) < 0) break;
            this.s.append(constants.substring(i, j));
            String referencedClass = constants.substring(j + 2, k);
            this.s.appendClassReference(referencedClass);
            i = k + 2;
        }
        this.s.append(constants.substring(i));
    }

    protected void appendTypeFlags(@NonNull Type type) {
        if (type instanceof OrderedSetType) {
            this.s.appendClassReference(ExecutorType.class);
            this.s.append(".ORDERED | ");
            this.s.appendClassReference(ExecutorType.class);
            this.s.append(".UNIQUE");
        } else if (type instanceof SetType) {
            this.s.appendClassReference(ExecutorType.class);
            this.s.append(".UNIQUE");
        } else if (type instanceof SequenceType) {
            this.s.appendClassReference(ExecutorType.class);
            this.s.append(".ORDERED");
        } else {
            this.s.append("0");
        }
    }

    protected void appendUpperName(@NonNull NamedElement namedElement) {
        this.s.append((String)DomainUtil.nonNullModel((Object)CodeGenUtil.upperName((String)namedElement.getName())));
    }

    @NonNull
    protected String atNonNull() {
        if (this.useNullAnnotations) {
            this.s.addClassReference("NonNull", "org.eclipse.jdt.annotation.NonNull");
            return "@NonNull";
        }
        return "/*@NonNull*/";
    }

    @NonNull
    protected LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>> computeFragmentOperations() {
        LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>> fragmentOperations = new LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>>();
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            assert (pClass != null);
            LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, ArrayList<Operation>> classOperations = new LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, ArrayList<Operation>>();
            fragmentOperations.put(pClass, classOperations);
            ArrayList<Operation> sortedOperations = new ArrayList<Operation>(this.getOperations((Type)pClass));
            Collections.sort(sortedOperations, signatureComparator);
            classOperations.put(pClass, sortedOperations);
            for (org.eclipse.ocl.examples.pivot.Class pSuperClass : this.getAllProperSupertypesSortedByName(pClass)) {
                assert (pSuperClass != null);
                ArrayList<Operation> sortedSuperOperations = new ArrayList<Operation>(this.getOperations((Type)pSuperClass));
                Collections.sort(sortedSuperOperations, signatureComparator);
                classOperations.put(pSuperClass, sortedSuperOperations);
            }
        }
        return fragmentOperations;
    }

    @NonNull
    public LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>> computeFragmentProperties() {
        LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>> fragmentProperties = new LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>>();
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            assert (pClass != null);
            HashSet<Property> allProperties = new HashSet<Property>();
            for (org.eclipse.ocl.examples.pivot.Class pSuperClass : this.getAllSupertypesSortedByName(pClass)) {
                assert (pSuperClass != null);
                for (Property prop : this.getLocalPropertiesSortedByName(pSuperClass)) {
                    assert (prop != null);
                    if (!this.isProperty(prop)) continue;
                    allProperties.add(prop);
                }
            }
            ArrayList sortedProperties = new ArrayList(allProperties);
            Collections.sort(sortedProperties, propertyComparator);
            fragmentProperties.put(pClass, sortedProperties);
        }
        return fragmentProperties;
    }

    protected void declareEnumerationLiterals() {
        this.s.append("\t/**\n");
        this.s.append("\t *\tThe lists of enumeration literals for each enumeration.\n");
        this.s.append("\t */\n");
        this.s.append("\tpublic static class EnumerationLiterals {");
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            EnumerationLiteral enumerationLiteral;
            if (!(pClass instanceof Enumeration)) continue;
            this.s.append("\n");
            List enumerationLiterals = ((Enumeration)pClass).getOwnedLiteral();
            int i = 0;
            while (i < enumerationLiterals.size()) {
                enumerationLiteral = (EnumerationLiteral)DomainUtil.nonNullModel((Object)((EnumerationLiteral)enumerationLiterals.get(i)));
                this.s.append("\t\tpublic static final " + this.atNonNull() + " ");
                this.s.appendClassReference(EcoreExecutorEnumerationLiteral.class);
                this.s.append(" ");
                this.s.appendScopedTypeName((Type)pClass);
                this.s.append("__");
                this.s.appendName((NamedElement)enumerationLiteral);
                this.s.append(" = new ");
                this.s.appendClassReference(EcoreExecutorEnumerationLiteral.class);
                this.s.append("(");
                this.s.append(String.valueOf(this.genPackage.getPrefix()) + "Package.Literals.");
                this.appendUpperName((NamedElement)pClass);
                this.s.append(".getEEnumLiteral(");
                this.s.appendString((String)DomainUtil.nonNullModel((Object)enumerationLiteral.getName()));
                this.s.append("), Types.");
                this.s.appendScopedTypeName((Type)pClass);
                this.s.append(", " + i + ");\n");
                ++i;
            }
            this.s.append("\t\tprivate static final " + this.atNonNull() + " ");
            this.s.appendClassReference(EcoreExecutorEnumerationLiteral.class);
            this.s.append("[] ");
            this.s.appendScopedTypeName((Type)pClass);
            this.s.append(" = {");
            i = 0;
            while (i < enumerationLiterals.size()) {
                enumerationLiteral = (EnumerationLiteral)DomainUtil.nonNullModel((Object)((EnumerationLiteral)enumerationLiterals.get(i)));
                if (i > 0) {
                    this.s.append(",");
                }
                this.s.append("\n");
                this.s.append("\t\t\t");
                this.s.appendScopedTypeName((Type)pClass);
                this.s.append("__");
                this.s.appendName((NamedElement)enumerationLiteral);
                ++i;
            }
            this.s.append("\n");
            this.s.append("\t\t};\n");
        }
        this.s.append("\n");
        this.s.append("\t\t/**\n");
        this.s.append("\t\t *\tInstall the enumeration literals in the enumerations.\n");
        this.s.append("\t\t */\n");
        this.s.append("\t\tstatic {\n");
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            if (!(pClass instanceof Enumeration)) continue;
            this.s.append("\t\t\tTypes.");
            this.s.appendScopedTypeName((Type)pClass);
            this.s.append(".initLiterals(");
            this.s.appendScopedTypeName((Type)pClass);
            this.s.append(");\n");
        }
        this.s.append("\t\t}\n");
        this.s.append("\n");
        this.s.append("\t\tpublic static void init() {}\n");
        this.s.append("\t}\n");
    }

    protected void declareFragments() {
        this.s.append("\t/**\n");
        this.s.append("\t *\tThe fragment descriptors for the local elements of each type and its supertypes.\n");
        this.s.append("\t */\n");
        this.s.append("\tpublic static class Fragments {");
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            assert (pClass != null);
            this.s.append("\n");
            List<org.eclipse.ocl.examples.pivot.Class> allSupertypesSortedByName = this.getAllSupertypesSortedByName(pClass);
            for (org.eclipse.ocl.examples.pivot.Class pSuperClass : allSupertypesSortedByName) {
                assert (pSuperClass != null);
                this.s.append("\t\tprivate static final " + this.atNonNull() + " ");
                this.s.appendClassReference(ExecutorFragment.class);
                this.s.append(" ");
                this.s.appendScopedTypeName((Type)pClass);
                this.s.append("__");
                this.s.appendUnscopedTypeName(this.metaModelManager, (Type)pSuperClass);
                this.s.append(" = new ");
                this.s.appendClassReference(ExecutorFragment.class);
                this.s.append("(");
                pClass.accept((Visitor)this.emitLiteralVisitor);
                this.s.append(", ");
                pSuperClass.accept((Visitor)this.emitQualifiedLiteralVisitor);
                this.s.append(");\n");
            }
        }
        this.s.append("\n");
        this.s.append("\t\t/*\n");
        this.s.append("\t\t * Force initialization.\n");
        this.s.append("\t\t */\n");
        this.s.append("\t\tpublic static void init() {\n");
        this.s.append("\t\t\tTypes.init();\n");
        this.s.append("\t\t}\n");
        this.s.append("\t}\n");
    }

    protected void declareFragmentOperations(@NonNull List<LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>>> paginatedFragmentOperations) {
        this.s.append("\t/**\n");
        this.s.append("\t *\tThe lists of local operations or local operation overrides for each fragment of each type.\n");
        this.s.append("\t */\n");
        int page = 1;
        int pageMax = paginatedFragmentOperations.size();
        for (LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>> fragmentOperations : paginatedFragmentOperations) {
            this.s.append("\tpublic static class FragmentOperations");
            this.s.appendPage(page, pageMax);
            this.s.append(" {");
            for (org.eclipse.ocl.examples.pivot.Class pClass : fragmentOperations.keySet()) {
                assert (pClass != null);
                this.s.append("\n");
                LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>> classOperations = fragmentOperations.get(pClass);
                for (org.eclipse.ocl.examples.pivot.Class pSuperClass : classOperations.keySet()) {
                    assert (pSuperClass != null);
                    List<Operation> sortedOperations = classOperations.get(pSuperClass);
                    this.s.append("\t\tprivate static final " + this.atNonNull() + " ");
                    this.s.appendClassReference(ExecutorOperation.class);
                    this.s.append("[] ");
                    this.s.appendScopedTypeName((Type)pClass);
                    this.s.append("__");
                    this.s.appendUnscopedTypeName(this.metaModelManager, (Type)pSuperClass);
                    this.s.append(" = ");
                    if (sortedOperations.size() <= 0) {
                        this.s.append("{};\n");
                        continue;
                    }
                    this.s.append("{");
                    int i = 0;
                    while (i < sortedOperations.size()) {
                        Operation op = (Operation)DomainUtil.nonNullModel((Object)sortedOperations.get(i));
                        Operation overloadOp = this.getOverloadOp(pClass, op);
                        if (i > 0) {
                            this.s.append(",");
                        }
                        this.s.append("\n");
                        this.s.append("\t\t\t");
                        overloadOp.accept((Visitor)this.emitQualifiedLiteralVisitor);
                        this.s.append(" /* ");
                        this.s.append(OCLinEcoreTables.getSignature(overloadOp));
                        this.s.append(" */");
                        ++i;
                    }
                    this.s.append("\n");
                    this.s.append("\t\t};\n");
                }
            }
            this.s.append("\n");
            this.s.append("\t\t/*\n");
            this.s.append("\t\t *\tInstall the operation descriptors in the fragment descriptors.\n");
            this.s.append("\t\t */\n");
            this.s.append("\t\tpublic static void init() {\n");
            this.s.append("\t\t\tTypeFragments.init();\n");
            for (org.eclipse.ocl.examples.pivot.Class pClass : fragmentOperations.keySet()) {
                assert (pClass != null);
                this.s.append("\n");
                for (org.eclipse.ocl.examples.pivot.Class pSuperClass : this.getAllSupertypesSortedByName(pClass)) {
                    assert (pSuperClass != null);
                    this.s.append("\t\t\tFragments.");
                    this.s.appendScopedTypeName((Type)pClass);
                    this.s.append("__");
                    this.s.appendUnscopedTypeName(this.metaModelManager, (Type)pSuperClass);
                    this.s.append(".initOperations(");
                    this.s.appendScopedTypeName((Type)pClass);
                    this.s.append("__");
                    this.s.appendUnscopedTypeName(this.metaModelManager, (Type)pSuperClass);
                    this.s.append(");\n");
                }
            }
            this.s.append("\t\t}\n");
            this.s.append("\t}\n");
            this.s.append("\n");
            ++page;
        }
    }

    public void declareFragmentProperties(@NonNull List<LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>>> paginatedFragmentProperties) {
        this.s.append("\t/**\n");
        this.s.append("\t *\tThe lists of local properties for the local fragment of each type.\n");
        this.s.append("\t */\n");
        int page = 1;
        int pageMax = paginatedFragmentProperties.size();
        for (LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>> fragmentProperties : paginatedFragmentProperties) {
            this.s.append("\tpublic static class FragmentProperties");
            this.s.appendPage(page, pageMax);
            this.s.append(" {");
            for (org.eclipse.ocl.examples.pivot.Class pClass : fragmentProperties.keySet()) {
                List<Property> sortedProperties = fragmentProperties.get(pClass);
                this.s.append("\n");
                this.s.append("\t\tprivate static final " + this.atNonNull() + " ");
                this.s.appendClassReference(ExecutorProperty.class);
                this.s.append("[] ");
                this.s.appendScopedTypeName((Type)pClass);
                this.s.append(" = ");
                if (sortedProperties.size() <= 0) {
                    this.s.append("{};\n");
                    continue;
                }
                this.s.append("{");
                int i = 0;
                while (i < sortedProperties.size()) {
                    Property prop = sortedProperties.get(i);
                    if (i > 0) {
                        this.s.append(",");
                    }
                    this.s.append("\n");
                    this.s.append("\t\t\t");
                    prop.accept((Visitor)this.emitQualifiedLiteralVisitor);
                    ++i;
                }
                this.s.append("\n");
                this.s.append("\t\t};\n");
            }
            this.s.append("\n");
            this.s.append("\t\t/**\n");
            this.s.append("\t\t *\tInstall the property descriptors in the fragment descriptors.\n");
            this.s.append("\t\t */\n");
            this.s.append("\t\tpublic static void init() {\n");
            this.s.append("\t\t\tTypeFragments.init();\n");
            this.s.append("\n");
            for (org.eclipse.ocl.examples.pivot.Class pClass : fragmentProperties.keySet()) {
                assert (pClass != null);
                this.s.append("\t\t\tFragments.");
                this.s.appendScopedTypeName((Type)pClass);
                this.s.append("__");
                this.s.appendUnscopedTypeName(this.metaModelManager, (Type)pClass);
                this.s.append(".initProperties(");
                this.s.appendScopedTypeName((Type)pClass);
                this.s.append(");\n");
            }
            this.s.append("\t\t}\n");
            this.s.append("\t}\n");
            this.s.append("\n");
            ++page;
        }
    }

    protected void declareOperations() {
        this.s.append("\t/**\n");
        this.s.append("\t *\tThe operation descriptors for each operation of each type.\n");
        this.s.append("\t */\n");
        this.s.append("\tpublic static class Operations {");
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            assert (pClass != null);
            ArrayList<Operation> sortedOperations = new ArrayList<Operation>(this.getOperations((Type)pClass));
            Collections.sort(sortedOperations, signatureComparator);
            int i = 0;
            while (i < sortedOperations.size()) {
                if (i == 0) {
                    this.s.append("\n");
                }
                Operation op = (Operation)sortedOperations.get(i);
                TemplateSignature ownedTemplateSignature = op.getOwnedTemplateSignature();
                this.s.append("\t\tpublic static final " + this.atNonNull() + " ");
                this.s.appendClassReference(ExecutorOperation.class);
                this.s.append(" ");
                op.accept((Visitor)this.emitLiteralVisitor);
                this.s.append(" = new ");
                this.s.appendClassReference(ExecutorOperation.class);
                this.s.append("(");
                this.s.appendString((String)DomainUtil.nonNullModel((Object)op.getName()));
                this.s.append(", Parameters.");
                this.s.append(this.getTemplateBindingsName(op.getParameterTypes()));
                this.s.append(", ");
                op.getOwningType().accept((Visitor)this.emitLiteralVisitor);
                this.s.append(",\n\t\t\t" + i + ", ");
                if (ownedTemplateSignature == null) {
                    this.s.appendClassReference(DomainTypeParameters.class);
                    this.s.append(".EMPTY_LIST");
                } else {
                    this.s.append("new ");
                    this.s.appendClassReference(DomainTypeParameters.class);
                    this.s.append("(");
                    for (TemplateParameter parameter : ownedTemplateSignature.getOwnedParameter()) {
                        ParameterableElement parameteredElement = parameter.getParameteredElement();
                        if (!(parameteredElement instanceof Nameable)) continue;
                        this.s.append("TypeParameters._");
                        op.accept((Visitor)this.emitLiteralVisitor);
                        this.s.append("_");
                        this.s.appendParameterName((NamedElement)parameteredElement);
                    }
                    this.s.append(")");
                }
                this.s.append(", ");
                this.s.append(this.getImplementationName(op));
                this.s.append(");\n");
                ++i;
            }
        }
        this.s.append("\n");
        this.s.append("\t}\n");
    }

    protected void declareParameterLists() {
        HashSet<DomainParameterTypes> allLists = new HashSet<DomainParameterTypes>();
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            assert (pClass != null);
            for (Operation operation : this.getOperations((Type)pClass)) {
                allLists.add(operation.getParameterTypes());
            }
        }
        this.s.append("\t/**\n");
        this.s.append("\t *\tThe parameter lists shared by operations.\n");
        this.s.append("\t */\n");
        this.s.append("\tpublic static class Parameters {\n");
        ArrayList sortedLists = new ArrayList(allLists);
        Collections.sort(sortedLists, this.templateBindingNameComparator);
        for (DomainParameterTypes types : sortedLists) {
            assert (types != null);
            this.s.append("\t\tpublic static final " + this.atNonNull() + " ");
            this.s.appendClassReference(DomainParameterTypes.class);
            this.s.append(" ");
            this.s.append(this.getTemplateBindingsName(types));
            this.s.append(" = new ");
            this.s.appendClassReference(DomainParameterTypes.class);
            this.s.append("(");
            int i = 0;
            while (i < types.size()) {
                if (i > 0) {
                    this.s.append(", ");
                }
                Type type = PivotUtil.getType((Type)((Type)types.get(i)));
                type.accept((Visitor)this.declareParameterTypeVisitor);
                ++i;
            }
            this.s.append(");\n");
        }
        this.s.append("\t}\n");
    }

    protected void declareProperties() {
        this.s.append("\t/**\n");
        this.s.append("\t *\tThe property descriptors for each property of each type.\n");
        this.s.append("\t */\n");
        this.s.append("\tpublic static class Properties {");
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            assert (pClass != null);
            boolean isFirst = true;
            List<Property> sortedProperties = this.getLocalPropertiesSortedByName(pClass);
            assert (pClass != null);
            int i = 0;
            while (i < sortedProperties.size()) {
                Property prop = (Property)DomainUtil.nonNullModel((Object)sortedProperties.get(i));
                if (this.isProperty(prop)) {
                    this.s.append("\n");
                    if (isFirst) {
                        this.s.append("\n");
                    }
                    isFirst = false;
                    this.s.append("\t\tpublic static final " + this.atNonNull() + " ");
                    this.s.appendClassReference(ExecutorProperty.class);
                    this.s.append(" ");
                    prop.accept((Visitor)this.emitLiteralVisitor);
                    this.s.append(" = new ");
                    String name = (String)DomainUtil.nonNullModel((Object)prop.getName());
                    if (prop.getImplementationClass() != null) {
                        this.s.appendClassReference(ExecutorPropertyWithImplementation.class);
                        this.s.append("(");
                        this.s.appendString(name);
                        this.s.append(", ");
                        pClass.accept((Visitor)this.emitLiteralVisitor);
                        this.s.append(", " + i + ", ");
                        this.s.append(prop.getImplementationClass());
                        this.s.append(".INSTANCE)");
                    } else if (this.hasEcore(prop).booleanValue()) {
                        Type owningType = (Type)DomainUtil.nonNullModel((Object)prop.getOwningType());
                        this.s.appendClassReference(EcoreExecutorProperty.class);
                        this.s.append("(");
                        this.s.append(this.genPackage.getPrefix());
                        this.s.append("Package.Literals.");
                        this.appendUpperName((NamedElement)owningType);
                        this.s.append("__");
                        this.appendUpperName((NamedElement)prop);
                        this.s.append(", ");
                        pClass.accept((Visitor)this.emitLiteralVisitor);
                        this.s.append(", " + i + ")");
                    } else {
                        Property opposite = prop.getOpposite();
                        if (opposite != null && this.hasEcore(opposite).booleanValue()) {
                            this.s.appendClassReference(ExecutorPropertyWithImplementation.class);
                            this.s.append("(");
                            this.s.appendString(name);
                            this.s.append(", ");
                            pClass.accept((Visitor)this.emitLiteralVisitor);
                            this.s.append(", " + i + ", new ");
                            this.s.appendClassReference(EcoreLibraryOppositeProperty.class);
                            this.s.append("(");
                            this.s.append(this.genPackage.getPrefix());
                            this.s.append("Package.Literals.");
                            this.appendUpperName((NamedElement)DomainUtil.nonNullModel((Object)opposite.getOwningType()));
                            this.s.append("__");
                            this.appendUpperName((NamedElement)opposite);
                            this.s.append("))");
                        } else {
                            this.s.appendClassReference(ExecutorPropertyWithImplementation.class);
                            this.s.append("(");
                            this.s.appendString(name);
                            this.s.append(", ");
                            pClass.accept((Visitor)this.emitLiteralVisitor);
                            this.s.append(", " + i + ", null)");
                        }
                    }
                    this.s.append(";");
                }
                ++i;
            }
        }
        this.s.append("\n");
        this.s.append("\n");
        this.s.append("\t\t/*\n");
        this.s.append("\t\t * Force initialization.\n");
        this.s.append("\t\t */\n");
        this.s.append("\t\tpublic static void init() {\n");
        this.s.append("\t\t\tTypes.init();\n");
        this.s.append("\t\t}\n");
        this.s.append("\t}\n");
    }

    protected void declareType(@NonNull org.eclipse.ocl.examples.pivot.Class pClass) {
        Class typeClass = pClass instanceof Enumeration ? EcoreExecutorEnumeration.class : (pClass instanceof InvalidType ? EcoreExecutorInvalidType.class : (pClass instanceof VoidType ? EcoreExecutorVoidType.class : EcoreExecutorType.class));
        this.s.append("\t\tpublic static final " + this.atNonNull() + " ");
        this.s.appendClassReference(typeClass);
        this.s.append(" ");
        this.s.appendScopedTypeName((Type)pClass);
        this.s.append(" = ");
        if (!this.hasEcore((Type)pClass).booleanValue() || pClass instanceof VoidType || pClass instanceof InvalidType) {
            this.s.append("new ");
            this.s.appendClassReference(typeClass);
            this.s.append("(");
            if (OCLinEcoreTables.isBuiltInType((Type)pClass).booleanValue()) {
                this.s.appendClassReference(TypeId.class);
                this.s.append(".");
                this.appendUpperName((NamedElement)pClass);
            } else {
                this.s.appendString((String)DomainUtil.nonNullModel((Object)pClass.getName()));
            }
        } else {
            this.s.append("new ");
            this.s.appendClassReference(typeClass);
            this.s.append("(" + this.genPackage.getPrefix() + "Package.Literals.");
            this.appendUpperName((NamedElement)pClass);
        }
        this.s.append(", PACKAGE, ");
        this.appendTypeFlags((Type)pClass);
        if (pClass.getOwnedTemplateSignature() != null) {
            for (TemplateParameter parameter : pClass.getOwnedTemplateSignature().getOwnedParameter()) {
                if (!(parameter instanceof TypeTemplateParameter)) continue;
                Type parameteredElement = (Type)DomainUtil.nonNullModel((Object)((Type)parameter.getParameteredElement()));
                this.s.append(", TypeParameters.");
                this.s.appendScopedTypeName((Type)pClass);
                this.s.append("_");
                this.s.appendParameterName((NamedElement)parameteredElement);
            }
        }
        this.s.append(");\n");
    }

    protected void declareTypes(@NonNull List<LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>>> paginatedFragmentOperations, @NonNull List<LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>>> paginatedFragmentProperties) {
        this.s.append("\t/**\n");
        this.s.append("\t *\tThe type descriptors for each type.\n");
        this.s.append("\t */\n");
        this.s.append("\tpublic static class Types {\n");
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            assert (pClass != null);
            this.declareType(pClass);
        }
        this.s.append("\n");
        this.s.append("\t\tprivate static final " + this.atNonNull() + " ");
        this.s.appendClassReference(EcoreExecutorType.class);
        this.s.append("[] types = {");
        boolean isFirst = true;
        boolean hasEnumeration = false;
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            assert (pClass != null);
            if (pClass instanceof Enumeration) {
                hasEnumeration = true;
            }
            if (!isFirst) {
                this.s.append(",");
            }
            isFirst = false;
            this.s.append("\n");
            this.s.append("\t\t\t");
            this.s.appendScopedTypeName((Type)pClass);
        }
        this.s.append("\n");
        this.s.append("\t\t};\n");
        this.s.append("\n");
        this.s.append("\t\t/*\n");
        this.s.append("\t\t *\tInstall the type descriptors in the package descriptor.\n");
        this.s.append("\t\t */\n");
        this.s.append("\t\tstatic {\n");
        this.s.append("\t\t\tPACKAGE.init(LIBRARY, types);\n");
        Package extendedPackage = this.getExtendedPackage(this.pPackage);
        if (extendedPackage != null) {
            this.s.append("\t\t\tLIBRARY.addExtension(");
            this.s.appendClassReference(this.getQualifiedTablesClassName(extendedPackage));
            this.s.append(".PACKAGE, PACKAGE);\n");
        }
        this.s.append("\t\t\tTypeFragments.init();\n");
        int iMax = paginatedFragmentOperations.size();
        int i = 1;
        while (i <= iMax) {
            this.s.append("\t\t\tFragmentOperations");
            this.s.appendPage(i, iMax);
            this.s.append(".init();\n");
            ++i;
        }
        iMax = paginatedFragmentProperties.size();
        i = 1;
        while (i <= iMax) {
            this.s.append("\t\t\tFragmentProperties");
            this.s.appendPage(i, iMax);
            this.s.append(".init();\n");
            ++i;
        }
        if (hasEnumeration) {
            this.s.append("\t\t\tEnumerationLiterals.init();\n");
        }
        this.s.append("\t\t}\n");
        this.s.append("\n");
        this.s.append("\t\tpublic static void init() {}\n");
        this.s.append("\t}\n");
    }

    protected void declareTypeFragments() {
        this.s.append("\t/**\n");
        this.s.append("\t *\tThe fragments for all base types in depth order: OclAny first, OclSelf last.\n");
        this.s.append("\t */\n");
        this.s.append("\tpublic static class TypeFragments {");
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            assert (pClass != null);
            final HashMap<org.eclipse.ocl.examples.pivot.Class, Integer> allSuperTypes = new HashMap<org.eclipse.ocl.examples.pivot.Class, Integer>();
            int myDepth = this.getAllSuperClasses(allSuperTypes, pClass);
            int[] typesPerDepth = new int[myDepth + 1];
            int i = 0;
            while (i <= myDepth) {
                typesPerDepth[i] = 0;
                ++i;
            }
            for (Integer aDepth : allSuperTypes.values()) {
                int n = aDepth;
                typesPerDepth[n] = typesPerDepth[n] + 1;
            }
            ArrayList superTypes = new ArrayList(allSuperTypes.keySet());
            Collections.sort(superTypes, new Comparator<Type>(){

                @Override
                public int compare(Type o1, Type o2) {
                    Integer d2;
                    Integer d1 = (Integer)allSuperTypes.get(o1);
                    if (d1 != (d2 = (Integer)allSuperTypes.get(o2))) {
                        return d1.compareTo(d2);
                    }
                    String n1 = o1.getName();
                    String n2 = o2.getName();
                    return n1.compareTo(n2);
                }
            });
            this.s.append("\n");
            this.s.append("\t\tprivate static final " + this.atNonNull() + " ");
            this.s.appendClassReference(ExecutorFragment.class);
            this.s.append("[] ");
            this.s.appendScopedTypeName((Type)pClass);
            this.s.append(" =\n");
            this.s.append("\t\t{");
            boolean isFirst = true;
            for (Type superClass : superTypes) {
                assert (superClass != null);
                if (!isFirst) {
                    this.s.append(",");
                }
                this.s.append("\n");
                this.s.append("\t\t\tFragments.");
                this.s.appendScopedTypeName((Type)pClass);
                this.s.append("__");
                this.s.appendUnscopedTypeName(this.metaModelManager, superClass);
                this.s.append(" /* " + allSuperTypes.get(superClass) + " */");
                isFirst = false;
            }
            this.s.append("\n");
            this.s.append("\t\t};\n");
            this.s.append("\t\tprivate static final " + this.atNonNull() + " int[] _");
            this.s.appendScopedTypeName((Type)pClass);
            this.s.append(" = { ");
            int i2 = 0;
            while (i2 <= myDepth) {
                if (i2 > 0) {
                    this.s.append(",");
                }
                this.s.append(Integer.toString(typesPerDepth[i2]));
                ++i2;
            }
            this.s.append(" };\n");
        }
        this.s.append("\n");
        this.s.append("\t\t/**\n");
        this.s.append("\t\t *\tInstall the fragment descriptors in the class descriptors.\n");
        this.s.append("\t\t */\n");
        this.s.append("\t\tpublic static void init() {\n");
        this.s.append("\t\t\tFragments.init();\n");
        this.s.append("\t\t\tProperties.init();\n");
        this.s.append("\n");
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            assert (pClass != null);
            this.s.append("\t\t\t");
            pClass.accept((Visitor)this.emitLiteralVisitor);
            this.s.append(".initFragments(");
            this.s.appendScopedTypeName((Type)pClass);
            this.s.append(", _");
            this.s.appendScopedTypeName((Type)pClass);
            this.s.append(");\n");
        }
        this.s.append("\t\t}\n");
        this.s.append("\t}\n");
    }

    protected void declareTypeParameters() {
        this.s.append("\t/**\n");
        this.s.append("\t *\tThe type parameters for templated types and operations.\n");
        this.s.append("\t */\n");
        this.s.append("\tpublic static class TypeParameters {");
        for (org.eclipse.ocl.examples.pivot.Class pClass : this.activeClassesSortedByName) {
            TemplateSignature templateSignature = pClass.getOwnedTemplateSignature();
            if (templateSignature != null) {
                this.s.append("\n");
                for (TemplateParameter parameter : templateSignature.getOwnedParameter()) {
                    if (!(parameter instanceof TypeTemplateParameter)) continue;
                    Type parameteredElement = (Type)DomainUtil.nonNullModel((Object)((Type)parameter.getParameteredElement()));
                    this.s.append("\t\tpublic static final " + this.atNonNull() + " ");
                    this.s.appendClassReference(ExecutorTypeParameter.class);
                    this.s.append(" ");
                    this.s.appendScopedTypeName((Type)pClass);
                    this.s.append("_");
                    this.s.appendParameterName((NamedElement)parameteredElement);
                    this.s.append(" = new ");
                    this.s.appendClassReference(ExecutorTypeParameter.class);
                    this.s.append("(");
                    TemplateParameterId elementId = parameter.getElementId();
                    String idName = elementId.getLiteralName();
                    if (idName != null) {
                        this.s.appendClassReference(TypeId.class);
                        this.s.append(".");
                        this.s.append(idName);
                    } else {
                        this.s.appendClassReference(IdManager.class);
                        this.s.append(".getTemplateParameterId(" + elementId.getIndex() + ")");
                    }
                    this.s.append(", LIBRARY, ");
                    this.s.appendString((String)DomainUtil.nonNullModel((Object)parameteredElement.getName()));
                    this.s.append(");\n");
                }
            }
            for (Operation operation : this.getLocalOperationsSortedBySignature(pClass)) {
                assert (operation != null);
                templateSignature = operation.getOwnedTemplateSignature();
                if (templateSignature == null) continue;
                for (TemplateParameter parameter : templateSignature.getOwnedParameter()) {
                    if (!(parameter instanceof TypeTemplateParameter)) continue;
                    Type parameteredElement = (Type)DomainUtil.nonNullModel((Object)((Type)parameter.getParameteredElement()));
                    this.s.append("\t\tpublic static final " + this.atNonNull() + " ");
                    this.s.appendClassReference(ExecutorTypeParameter.class);
                    this.s.append(" _");
                    operation.accept((Visitor)this.emitLiteralVisitor);
                    this.s.append("_");
                    this.s.appendParameterName((NamedElement)parameteredElement);
                    this.s.append(" = new ");
                    this.s.appendClassReference(ExecutorTypeParameter.class);
                    this.s.append("(");
                    TemplateParameterId elementId = parameter.getElementId();
                    String idName = elementId.getLiteralName();
                    if (idName != null) {
                        this.s.appendClassReference(TypeId.class);
                        this.s.append(".");
                        this.s.append(idName);
                    } else {
                        this.s.appendClassReference(IdManager.class);
                        this.s.append(".getTemplateParameterId(" + elementId.getIndex() + ")");
                    }
                    this.s.append(", LIBRARY, ");
                    this.s.appendString((String)DomainUtil.nonNullModel((Object)parameteredElement.getName()));
                    this.s.append(");\n");
                }
            }
        }
        this.s.append("\t}\n");
    }

    @NonNull
    public String generateTablesClass(@Nullable String constants) {
        String tablesClassName = this.getTablesClassName(this.genPackage);
        LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>> fragmentOperations = this.computeFragmentOperations();
        LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>> fragmentProperties = this.computeFragmentProperties();
        List<LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>>> paginatedFragmentOperations = this.paginateFragmentOperations(fragmentOperations);
        List<LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>>> paginatedFragmentProperties = this.paginateFragmentProperties(fragmentProperties);
        this.s.append("/**\n");
        this.s.append(" * " + tablesClassName + " provides the dispatch tables for the " + this.pPackage.getName() + " for use by the OCL dispatcher.\n");
        this.s.append(" *\n");
        this.s.append(" * In order to ensure correct static initialization, a top level class element must be accessed\n");
        this.s.append(" * before any nested class element. Therefore an access to PACKAGE.getClass() is recommended.\n");
        this.s.append(" */\n");
        this.s.append("@SuppressWarnings(\"nls\")\n");
        this.s.append("public class " + tablesClassName + "\n");
        this.s.append("{\n");
        this.s.append("\t/**\n");
        this.s.append("\t *\tThe package descriptor for the package.\n");
        this.s.append("\t */\n");
        this.s.append("\tpublic static final ");
        this.s.append(this.atNonNull());
        this.s.append(" ");
        this.s.appendClassReference(EcoreExecutorPackage.class);
        this.s.append(" PACKAGE = new ");
        this.s.appendClassReference(EcoreExecutorPackage.class);
        this.s.append("(" + this.genPackage.getPrefix() + "Package.eINSTANCE);\n");
        this.s.append("\n");
        this.s.append("\t/**\n");
        this.s.append("\t *\tThe library of all packages and types.\n");
        this.s.append("\t */\n");
        this.s.append("\tpublic static final " + this.atNonNull() + " ");
        this.s.appendClassReference(ExecutorStandardLibrary.class);
        this.s.append(" LIBRARY = ");
        if (this.hasSharedLibrary().booleanValue()) {
            this.s.appendClassReference(this.getSharedLibrary());
            this.s.append(".LIBRARY");
        } else {
            this.s.append("new ");
            this.s.appendClassReference(ExecutorStandardLibrary.class);
            this.s.append("()");
        }
        this.s.append(";\n");
        if (constants != null) {
            this.s.append("\n");
            this.appendConstants(constants);
        }
        this.s.append("\n");
        this.declareTypeParameters();
        this.s.append("\n");
        this.declareTypes(paginatedFragmentOperations, paginatedFragmentProperties);
        this.s.append("\n");
        this.declareFragments();
        this.s.append("\n");
        this.declareParameterLists();
        this.s.append("\n");
        this.declareOperations();
        this.s.append("\n");
        this.declareProperties();
        this.s.append("\n");
        this.declareTypeFragments();
        this.s.append("\n");
        this.declareFragmentOperations(paginatedFragmentOperations);
        this.declareFragmentProperties(paginatedFragmentProperties);
        this.declareEnumerationLiterals();
        this.s.append("\n");
        this.s.append("\t/*\n");
        this.s.append("\t * Force initialization.\n");
        this.s.append("\t */\n");
        this.s.append("\tstatic {\n");
        this.s.append("\t\tTypes.init();\n");
        this.s.append("\t}\n");
        this.s.append("}\n");
        return this.s.toString();
    }

    @NonNull
    public List<LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>>> paginateFragmentOperations(@NonNull LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>> fragmentOperations) {
        ArrayList<LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>>> paginatedFragmentOperations = new ArrayList<LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>>>();
        LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>> pageOfFragmentOperations = null;
        int size = 0;
        for (org.eclipse.ocl.examples.pivot.Class pClass : fragmentOperations.keySet()) {
            LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>> line = fragmentOperations.get(pClass);
            int lineSize = 0;
            for (List<Operation> operations : line.values()) {
                lineSize += operations.size();
            }
            if (pageOfFragmentOperations == null || size + lineSize > 4000) {
                pageOfFragmentOperations = new LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Operation>>>();
                size = 0;
                paginatedFragmentOperations.add(pageOfFragmentOperations);
            }
            pageOfFragmentOperations.put(pClass, line);
            size += lineSize;
        }
        return paginatedFragmentOperations;
    }

    @NonNull
    public List<LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>>> paginateFragmentProperties(@NonNull LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>> fragmentProperties) {
        ArrayList<LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>>> paginatedFragmentProperties = new ArrayList<LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>>>();
        LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>> pageOfFragmentProperties = null;
        int size = 0;
        for (org.eclipse.ocl.examples.pivot.Class pClass : fragmentProperties.keySet()) {
            List<Property> line = fragmentProperties.get(pClass);
            int lineSize = line.size();
            if (pageOfFragmentProperties == null || size + lineSize > 4000) {
                pageOfFragmentProperties = new LinkedHashMap<org.eclipse.ocl.examples.pivot.Class, List<Property>>();
                size = 0;
                paginatedFragmentProperties.add(pageOfFragmentProperties);
            }
            pageOfFragmentProperties.put(pClass, line);
            size += lineSize;
        }
        return paginatedFragmentProperties;
    }

    @NonNull
    public String toString() {
        String copyright = this.genPackage.getCopyright(" * ");
        StringBuilder s1 = new StringBuilder();
        s1.append("/*******************************************************************************\n");
        if (copyright != null) {
            s1.append(" * ");
            s1.append(copyright.replace("\r", ""));
            s1.append("\n");
        }
        s1.append(" *************************************************************************\n");
        s1.append(" * This code is 100% auto-generated\n");
        s1.append(" * from: " + this.pPackage.getName() + "\n");
        s1.append(" * using: " + this.getClass().getName() + "\n");
        s1.append(" *\n");
        s1.append(" * Do not edit it.\n");
        s1.append(" *******************************************************************************/\n");
        s1.append("package ");
        s1.append(this.genPackage.getQualifiedPackageName());
        s1.append(";\n");
        s1.append("\n");
        for (String classReference : this.s.getClassReferences()) {
            s1.append("import ");
            s1.append(classReference);
            s1.append(";\n");
        }
        s1.append("\n");
        s1.append(this.s.toString());
        String string = s1.toString();
        return string;
    }
}

