/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinecore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.common.NameQueries;
import org.eclipse.ocl.examples.codegen.generator.AbstractGenModelHelper;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainParameterTypes;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.domain.ids.BuiltInTypeId;
import org.eclipse.ocl.examples.domain.ids.LambdaTypeId;
import org.eclipse.ocl.examples.domain.ids.ParametersId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.LibraryConstants;
import org.eclipse.ocl.examples.library.executor.ExecutorLambdaType;
import org.eclipse.ocl.examples.library.executor.ExecutorSpecializedType;
import org.eclipse.ocl.examples.library.executor.ExecutorTupleType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotConstants;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.xtext.util.Strings;

public class OCLinEcoreTablesUtils {
    public Comparator<DomainParameterTypes> templateBindingNameComparator = new Comparator<DomainParameterTypes>(){

        @Override
        public int compare(DomainParameterTypes o1, DomainParameterTypes o2) {
            if (!($assertionsDisabled || o1 != null && o2 != null)) {
                throw new AssertionError();
            }
            String n1 = OCLinEcoreTablesUtils.this.getTemplateBindingsName(o1);
            String n2 = OCLinEcoreTablesUtils.this.getTemplateBindingsName(o2);
            return n1.compareTo(n2);
        }
    };
    public static Comparator<Nameable> nameComparator = new Comparator<Nameable>(){

        @Override
        public int compare(Nameable o1, Nameable o2) {
            String n1 = String.valueOf(o1.getName());
            String n2 = String.valueOf(o2.getName());
            return n1.compareTo(n2);
        }
    };
    public static Comparator<Property> propertyComparator = new Comparator<Property>(){

        @Override
        public int compare(Property p1, Property p2) {
            String n2;
            boolean b2;
            boolean b1 = p1.isImplicit();
            if (b1 != (b2 = p2.isImplicit())) {
                return b1 ? 1 : -1;
            }
            String n1 = String.valueOf(p1.getName());
            int diff = n1.compareTo(n2 = String.valueOf(p2.getName()));
            if (diff != 0) {
                return diff;
            }
            Property o1 = p1.getOpposite();
            Property o2 = p2.getOpposite();
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            n1 = String.valueOf(o1.getName());
            n2 = String.valueOf(o2.getName());
            return n1.compareTo(n2);
        }
    };
    public static Comparator<Operation> signatureComparator = new Comparator<Operation>(){

        @Override
        public int compare(Operation o1, Operation o2) {
            if (!($assertionsDisabled || o1 != null && o2 != null)) {
                throw new AssertionError();
            }
            String n1 = String.valueOf(OCLinEcoreTablesUtils.getSignature(o1));
            String n2 = String.valueOf(OCLinEcoreTablesUtils.getSignature(o2));
            return n1.compareTo(n2);
        }
    };
    @NonNull
    protected final CodeGenString s = new CodeGenString();
    @NonNull
    protected final GenPackage genPackage;
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final Package pPackage;
    @NonNull
    protected final DeclareParameterTypeVisitor declareParameterTypeVisitor = new DeclareParameterTypeVisitor(this.s);
    @NonNull
    protected final EmitLiteralVisitor emitLiteralVisitor = new EmitLiteralVisitor(this.s);
    @NonNull
    protected final EmitQualifiedLiteralVisitor emitQualifiedLiteralVisitor = new EmitQualifiedLiteralVisitor(this.s);
    @NonNull
    protected final Iterable<org.eclipse.ocl.examples.pivot.Class> activeClassesSortedByName;
    @NonNull
    protected final Map<DomainParameterTypes, String> templateBindingsNames = new HashMap<DomainParameterTypes, String>();

    private static <T extends GenPackage> T getLibraryGenPackage(List<T> genPackages) {
        for (GenPackage genPackage : genPackages) {
            EPackage ecorePackage = genPackage.getEcorePackage();
            EClassifier eClassifier = ecorePackage.getEClassifier("_Dummy");
            if (eClassifier == null) continue;
            return (T)genPackage;
        }
        return null;
    }

    @Nullable
    private static <T extends GenPackage> T getMetaModelGenPackage(@NonNull List<T> genPackages) {
        for (GenPackage genPackage : genPackages) {
            EPackage ecorePackage = genPackage.getEcorePackage();
            EClassifier eClassifier = ecorePackage.getEClassifier("Element");
            if (eClassifier == null) continue;
            return (T)genPackage;
        }
        return null;
    }

    @Nullable
    private static <T extends GenClassifier> T getNamedElement1(@Nullable List<T> genClasses, @NonNull String name) {
        if (genClasses != null) {
            for (GenClassifier genClass : genClasses) {
                if (!genClass.getName().equals(name)) continue;
                return (T)genClass;
            }
        }
        return null;
    }

    @Nullable
    private static <T extends GenFeature> T getNamedElement2(@Nullable List<T> genClasses, @NonNull String name) {
        if (genClasses != null) {
            for (GenFeature genClass : genClasses) {
                if (!genClass.getName().equals(name)) continue;
                return (T)genClass;
            }
        }
        return null;
    }

    @NonNull
    public static Boolean isBuiltInType(@NonNull Type type) {
        return type.getTypeId() instanceof BuiltInTypeId;
    }

    @NonNull
    private static GenPackage loadGenPackage(@NonNull ResourceSet resourceSet, @NonNull URI genModelURI) {
        Resource resource = resourceSet.getResource(genModelURI, true);
        GenModel genModel = (GenModel)resource.getContents().get(0);
        GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
        assert (genPackage != null);
        return genPackage;
    }

    protected OCLinEcoreTablesUtils(@NonNull GenPackage genPackage) {
        this.genPackage = genPackage;
        Resource genModelResource = genPackage.eResource();
        ResourceSet genModelResourceSet = genModelResource.getResourceSet();
        assert (genModelResourceSet != null);
        MetaModelManagerResourceSetAdapter resourceSetAdapter = MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)genModelResourceSet, null);
        this.metaModelManager = resourceSetAdapter.getMetaModelManager();
        this.pPackage = (Package)DomainUtil.nonNullModel((Object)this.getPivotPackage(genPackage));
        this.activeClassesSortedByName = this.getActiveClassesSortedByName(this.pPackage);
    }

    @NonNull
    protected Iterable<org.eclipse.ocl.examples.pivot.Class> getActiveClassesSortedByName(@NonNull Package pPackage) {
        Set<? extends Type> activeTypes = this.getActiveTypes(pPackage);
        ArrayList<org.eclipse.ocl.examples.pivot.Class> sortedClasses = new ArrayList<org.eclipse.ocl.examples.pivot.Class>();
        for (Type type : activeTypes) {
            if (!(type instanceof org.eclipse.ocl.examples.pivot.Class)) continue;
            sortedClasses.add((org.eclipse.ocl.examples.pivot.Class)type);
        }
        Collections.sort(sortedClasses, nameComparator);
        return sortedClasses;
    }

    @NonNull
    protected Set<? extends Type> getActiveTypes(@NonNull Package pPackage) {
        Package oclstdlibPackage = this.metaModelManager.getBooleanType().getPackage();
        DomainPackage pivotMetaModel = this.metaModelManager.getASMetamodel();
        Type elementType = this.metaModelManager.getPivotType("Element");
        if (oclstdlibPackage == pPackage) {
            HashSet<Type> types = new HashSet<Type>();
            for (Type type : oclstdlibPackage.getOwnedType()) {
                assert (type != null);
                TypeServer typeServer = this.metaModelManager.getTypeServer((DomainType)type);
                if (elementType != null && typeServer.conformsTo((DomainStandardLibrary)this.metaModelManager, (DomainType)elementType) || "_Dummy".equals(type.getName())) continue;
                types.add(type);
            }
            return types;
        }
        if (pivotMetaModel == pPackage) {
            HashSet<Type> types = new HashSet<Type>();
            for (DomainType type : pivotMetaModel.getOwnedType()) {
                assert (type != null);
                boolean pruned = false;
                Type myType = null;
                TypeServer typeServer = this.metaModelManager.getTypeServer(type);
                for (DomainType partialType : typeServer.getPartialTypes()) {
                    DomainPackage partialPackage = partialType.getPackage();
                    if (partialPackage == oclstdlibPackage) {
                        if (elementType == null || typeServer.conformsTo((DomainStandardLibrary)this.metaModelManager, (DomainType)elementType)) continue;
                        pruned = true;
                        continue;
                    }
                    if (partialPackage != pPackage || !(partialType instanceof Type)) continue;
                    myType = (Type)type;
                }
                if (pruned || myType == null) continue;
                types.add(myType);
            }
            return types;
        }
        return new HashSet(pPackage.getOwnedType());
    }

    @NonNull
    protected Iterable<org.eclipse.ocl.examples.pivot.Class> getAllProperSupertypesSortedByName(@NonNull org.eclipse.ocl.examples.pivot.Class pClass) {
        org.eclipse.ocl.examples.pivot.Class theClass = (org.eclipse.ocl.examples.pivot.Class)this.metaModelManager.getType((DomainType)pClass);
        HashMap<org.eclipse.ocl.examples.pivot.Class, Integer> results = new HashMap<org.eclipse.ocl.examples.pivot.Class, Integer>();
        this.getAllSuperClasses(results, theClass);
        ArrayList<org.eclipse.ocl.examples.pivot.Class> sortedClasses = new ArrayList<org.eclipse.ocl.examples.pivot.Class>(results.keySet());
        sortedClasses.remove(theClass);
        Collections.sort(sortedClasses, nameComparator);
        return sortedClasses;
    }

    @NonNull
    protected List<org.eclipse.ocl.examples.pivot.Class> getAllSupertypesSortedByName(@NonNull org.eclipse.ocl.examples.pivot.Class pClass) {
        HashMap<org.eclipse.ocl.examples.pivot.Class, Integer> results = new HashMap<org.eclipse.ocl.examples.pivot.Class, Integer>();
        this.getAllSuperClasses(results, pClass);
        ArrayList<org.eclipse.ocl.examples.pivot.Class> sortedClasses = new ArrayList<org.eclipse.ocl.examples.pivot.Class>(results.keySet());
        Collections.sort(sortedClasses, nameComparator);
        return sortedClasses;
    }

    protected int getAllSuperClasses(@NonNull Map<org.eclipse.ocl.examples.pivot.Class, Integer> results, @NonNull org.eclipse.ocl.examples.pivot.Class aClass) {
        org.eclipse.ocl.examples.pivot.Class theClass = (org.eclipse.ocl.examples.pivot.Class)this.metaModelManager.getType((DomainType)aClass);
        Integer depth = results.get(theClass);
        if (depth != null) {
            return depth;
        }
        int myDepth = 0;
        for (DomainType superClass : this.metaModelManager.getAllSuperClasses((DomainType)theClass)) {
            int superDepth;
            if ((superClass = this.metaModelManager.getType(superClass)) == theClass || !(superClass instanceof org.eclipse.ocl.examples.pivot.Class) || (superDepth = this.getAllSuperClasses(results, (org.eclipse.ocl.examples.pivot.Class)(superClass = (DomainType)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)((org.eclipse.ocl.examples.pivot.Class)superClass))))) < myDepth) continue;
            myDepth = superDepth + 1;
        }
        results.put(theClass, myDepth);
        return myDepth;
    }

    @Nullable
    protected Package getExtendedPackage(@NonNull Package pPackage) {
        Package oclstdlibPackage = this.metaModelManager.getBooleanType().getPackage();
        DomainPackage pivotMetaModel = this.metaModelManager.getASMetamodel();
        if (oclstdlibPackage == pPackage) {
            return null;
        }
        if (pivotMetaModel == pPackage) {
            return oclstdlibPackage;
        }
        return null;
    }

    @NonNull
    public GenPackage getGenPackage() {
        return this.genPackage;
    }

    @Nullable
    protected GenPackage getGenPackage(@NonNull Type type) {
        Package pPackage = type.getPackage();
        assert (pPackage != null);
        Package oclstdlibPackage = this.metaModelManager.getBooleanType().getPackage();
        Type elementType = this.metaModelManager.getPivotType("Element");
        if (elementType != null && oclstdlibPackage != null) {
            Package pivotMetaModel = elementType.getPackage();
            assert (pivotMetaModel != null);
            if (oclstdlibPackage == pPackage) {
                TypeServer typeServer = this.metaModelManager.getTypeServer((DomainType)type);
                if (typeServer.conformsTo((DomainStandardLibrary)this.metaModelManager, (DomainType)elementType)) {
                    return this.getGenPackage((DomainPackage)pivotMetaModel);
                }
                return this.getGenPackage((DomainPackage)oclstdlibPackage);
            }
            if (pivotMetaModel == pPackage) {
                TypeServer typeServer = this.metaModelManager.getTypeServer((DomainType)type);
                for (DomainType partialType : typeServer.getPartialTypes()) {
                    DomainPackage partialPackage = partialType.getPackage();
                    if (partialPackage != oclstdlibPackage || typeServer.conformsTo((DomainStandardLibrary)this.metaModelManager, (DomainType)elementType)) continue;
                    return this.getGenPackage((DomainPackage)oclstdlibPackage);
                }
                return this.getGenPackage((DomainPackage)pivotMetaModel);
            }
        }
        return this.getGenPackage((DomainPackage)pPackage);
    }

    @Nullable
    protected GenPackage getGenPackage(@NonNull DomainPackage asPackage) {
        EPackage firstEPackage = this.genPackage.getEcorePackage();
        if (firstEPackage.getName().equals(asPackage.getName())) {
            return this.genPackage;
        }
        EList usedGenPackages = this.genPackage.getGenModel().getUsedGenPackages();
        assert (usedGenPackages != null);
        Resource genModelResource = this.genPackage.eResource();
        ResourceSet genModelResourceSet = genModelResource.getResourceSet();
        assert (genModelResourceSet != null);
        DomainPackage metaModelPackage = this.metaModelManager.getASMetamodel();
        Package libraryPackage = (Package)this.metaModelManager.getLibraries().get(0);
        if (asPackage == libraryPackage) {
            Object libraryGenPackage = OCLinEcoreTablesUtils.getLibraryGenPackage(usedGenPackages);
            if (libraryGenPackage == null) {
                libraryGenPackage = OCLinEcoreTablesUtils.loadGenPackage(genModelResourceSet, LibraryConstants.GEN_MODEL_URI);
            }
            return libraryGenPackage;
        }
        if (asPackage == metaModelPackage) {
            Object metaModelGenPackage = OCLinEcoreTablesUtils.getMetaModelGenPackage(usedGenPackages);
            if (metaModelGenPackage == null) {
                metaModelGenPackage = OCLinEcoreTablesUtils.loadGenPackage(genModelResourceSet, PivotConstants.GEN_MODEL_URI);
            }
            return metaModelGenPackage;
        }
        String nsURI = asPackage.getNsURI();
        if (nsURI != null) {
            GenPackage genPackage2 = this.metaModelManager.getGenPackage(nsURI);
            if (genPackage2 != null) {
                return genPackage2;
            }
            for (GenPackage usedGenPackage : usedGenPackages) {
                if (usedGenPackage == null) continue;
                this.metaModelManager.addGenPackage(usedGenPackage);
            }
            genPackage2 = this.metaModelManager.getGenPackage(nsURI);
            if (genPackage2 != null) {
                return genPackage2;
            }
        }
        throw new IllegalStateException("No GenPackage for '" + nsURI + "'");
    }

    @NonNull
    protected String getImplementationName(@NonNull Operation operation) {
        if (operation.getImplementationClass() != null) {
            return String.valueOf(operation.getImplementationClass()) + ".INSTANCE";
        }
        return "null";
    }

    @NonNull
    protected Iterable<Operation> getLocalOperationsSortedBySignature(@NonNull org.eclipse.ocl.examples.pivot.Class pClass) {
        ArrayList<Operation> sortedOperations = new ArrayList<Operation>(this.getOperations((Type)pClass));
        Collections.sort(sortedOperations, signatureComparator);
        return sortedOperations;
    }

    @NonNull
    protected List<Property> getLocalPropertiesSortedByName(@NonNull org.eclipse.ocl.examples.pivot.Class pClass) {
        ArrayList<Property> sortedProperties = new ArrayList<Property>();
        for (Property property : this.getProperties((Type)pClass)) {
            assert (property != null);
            if (!this.isProperty(property)) continue;
            sortedProperties.add(property);
        }
        Collections.sort(sortedProperties, propertyComparator);
        return sortedProperties;
    }

    @NonNull
    protected LinkedHashSet<Operation> getOperations(@NonNull Type type) {
        LinkedHashSet<Operation> operations = new LinkedHashSet<Operation>();
        for (Operation operation : this.metaModelManager.getMemberOperations(type, false)) {
            operations.add(operation);
        }
        for (Operation operation : this.metaModelManager.getMemberOperations(type, true)) {
            operations.add(operation);
        }
        return operations;
    }

    @NonNull
    protected Operation getOverloadOp(@NonNull org.eclipse.ocl.examples.pivot.Class pClass, @NonNull Operation baseOp) {
        String baseSignature = OCLinEcoreTablesUtils.getSignature(baseOp);
        HashMap<org.eclipse.ocl.examples.pivot.Class, Integer> results = new HashMap<org.eclipse.ocl.examples.pivot.Class, Integer>();
        this.getAllSuperClasses(results, pClass);
        int bestDepth = -1;
        Operation best = null;
        for (org.eclipse.ocl.examples.pivot.Class aClass : results.keySet()) {
            int aDepth = (Integer)results.get(aClass);
            for (Operation op : this.getOperations((Type)DomainUtil.nonNullState((Object)aClass))) {
                if (!baseSignature.equals(OCLinEcoreTablesUtils.getSignature((Operation)DomainUtil.nonNullState((Object)op))) || aDepth <= bestDepth) continue;
                bestDepth = aDepth;
                best = op;
            }
        }
        assert (best != null);
        return best;
    }

    protected Package getPivotPackage(@NonNull GenPackage genPackage) {
        EPackage ePackage = genPackage.getEcorePackage();
        Resource ecoreResource = ePackage.eResource();
        if (ecoreResource == null) {
            return null;
        }
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter((Resource)ecoreResource, (MetaModelManager)this.metaModelManager);
        Package asPackage = (Package)ecore2Pivot.getCreated(Package.class, (EObject)ePackage);
        if (asPackage == null) {
            return null;
        }
        if (asPackage.getNsURI().equals("http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib")) {
            this.mergeLibrary(asPackage);
        }
        return asPackage;
    }

    @NonNull
    protected LinkedHashSet<Property> getProperties(@NonNull Type type) {
        HashSet<String> names = new HashSet<String>();
        LinkedHashSet<Property> properties = new LinkedHashSet<Property>();
        for (Property property : this.metaModelManager.getMemberProperties(type, true)) {
            if (property == null) continue;
            names.add(property.getName());
            properties.add((Property)this.metaModelManager.getPrimaryProperty((DomainProperty)property));
        }
        for (Property property : this.metaModelManager.getMemberProperties(type, false)) {
            if (property == null || names.contains(property.getName())) continue;
            properties.add((Property)this.metaModelManager.getPrimaryProperty((DomainProperty)property));
        }
        return properties;
    }

    @NonNull
    protected String getQualifiedTablesClassName(@NonNull Type type) {
        GenPackage genPackage = this.getGenPackage(type);
        if (genPackage != null) {
            return String.valueOf(genPackage.getInterfacePackageName()) + "." + this.getTablesClassName(genPackage);
        }
        return "UnknownMetaModelTables";
    }

    @NonNull
    protected String getQualifiedTablesClassName(@NonNull Package pPackage) {
        GenPackage genPackage = this.getGenPackage((DomainPackage)pPackage);
        if (genPackage != null) {
            return String.valueOf(genPackage.getInterfacePackageName()) + "." + this.getTablesClassName(genPackage);
        }
        return "UnknownMetaModelTables";
    }

    @NonNull
    protected String getSharedLibrary() {
        GenPackage gPackage;
        PrimitiveType booleanType;
        Package libraryPackage;
        Package thisPackage = this.getPivotPackage(this.genPackage);
        if (thisPackage != null && (libraryPackage = (booleanType = this.metaModelManager.getBooleanType()).getPackage()) != null && (gPackage = this.getGenPackage((DomainPackage)libraryPackage)) != null) {
            return String.valueOf(gPackage.getInterfacePackageName()) + "." + gPackage.getPrefix() + "Tables";
        }
        return "";
    }

    @NonNull
    public static String getSignature(@NonNull Operation anOperation) {
        Type owningType = anOperation.getOwningType();
        if (owningType == null) {
            return "null";
        }
        String qualifiedSignature = PrettyPrinter.printType((Element)anOperation, (Namespace)((Namespace)owningType));
        int colonColonIndex = qualifiedSignature.indexOf("::");
        int parenthesisIndex = qualifiedSignature.indexOf("(");
        if (parenthesisIndex < 0 ? colonColonIndex > 0 : colonColonIndex < parenthesisIndex) {
            String substring = qualifiedSignature.substring(colonColonIndex + 1);
            return substring;
        }
        return qualifiedSignature;
    }

    @NonNull
    public String getTablesClassName() {
        return this.getTablesClassName(this.genPackage);
    }

    @NonNull
    protected String getTablesClassName(@NonNull GenPackage genPackage) {
        return String.valueOf(genPackage.getPrefix()) + "Tables";
    }

    @NonNull
    protected String getTemplateBindingsName(@NonNull DomainParameterTypes templateBindings) {
        String name2 = this.templateBindingsNames.get(templateBindings);
        if (name2 == null) {
            String string;
            StringBuilder s = new StringBuilder();
            s.append("_");
            if (templateBindings.size() > 0) {
                int i = 0;
                while (i < templateBindings.size()) {
                    if (i > 0) {
                        s.append("___");
                    }
                    DomainType element = templateBindings.get(i);
                    this.getTemplateBindingsName(s, (Nameable)element);
                    ++i;
                }
            }
            name2 = string = s.toString();
            this.templateBindingsNames.put(templateBindings, name2);
        }
        return name2;
    }

    private void getTemplateBindingsName(@NonNull StringBuilder s, @NonNull Nameable element) {
        List templateBindings;
        TemplateParameter templateParameter;
        if (element instanceof ParameterableElement && (templateParameter = ((ParameterableElement)element).getOwningTemplateParameter()) != null) {
            TemplateableElement template = templateParameter.getSignature().getTemplate();
            if (template instanceof Operation) {
                s.append(AbstractGenModelHelper.encodeName((NamedElement)DomainUtil.nonNullModel((Object)((Operation)template).getOwningType())));
                s.append("_");
            }
            s.append(AbstractGenModelHelper.encodeName((NamedElement)DomainUtil.nonNullModel((Object)((NamedElement)template))));
            s.append("_");
        }
        s.append(AbstractGenModelHelper.encodeName((NamedElement)element));
        if (element instanceof TemplateableElement && (templateBindings = ((TemplateableElement)element).getTemplateBinding()).size() > 0) {
            s.append("_");
            for (TemplateBinding templateBinding : templateBindings) {
                for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitution()) {
                    s.append("_");
                    this.getTemplateBindingsName(s, (Nameable)DomainUtil.nonNullModel((Object)((Nameable)templateParameterSubstitution.getActual())));
                }
            }
            s.append("__");
        }
        if (element instanceof LambdaType) {
            LambdaType lambdaType = (LambdaType)element;
            s.append("_");
            this.getTemplateBindingsName(s, (Nameable)DomainUtil.nonNullModel((Object)lambdaType.getContextType()));
            for (Type type : lambdaType.getParameterType()) {
                assert (type != null);
                s.append("_");
                this.getTemplateBindingsName(s, (Nameable)type);
            }
            s.append("_");
            this.getTemplateBindingsName(s, (Nameable)DomainUtil.nonNullModel((Object)lambdaType.getResultType()));
        }
    }

    @NonNull
    protected Boolean hasEcore(@NonNull Property property) {
        Type owningType = property.getOwningType();
        if (owningType == null) {
            return false;
        }
        String typeName = owningType.getName();
        if (typeName == null) {
            return false;
        }
        GenClass genClass = (GenClass)OCLinEcoreTablesUtils.getNamedElement1(this.genPackage.getGenClasses(), typeName);
        if (genClass == null) {
            return false;
        }
        String propertyName = property.getName();
        if (propertyName == null) {
            return false;
        }
        Object genFeature = OCLinEcoreTablesUtils.getNamedElement2(genClass.getAllGenFeatures(), propertyName);
        if (genFeature == null) {
            return false;
        }
        return true;
    }

    @NonNull
    protected Boolean hasSharedLibrary() {
        PrimitiveType booleanType;
        Package libraryPackage;
        Package thisPackage = this.getPivotPackage(this.genPackage);
        if (thisPackage != (libraryPackage = (booleanType = this.metaModelManager.getBooleanType()).getPackage())) {
            return true;
        }
        return false;
    }

    protected boolean isLambdaParameterList(@NonNull ParametersId parametersId) {
        for (TypeId typeId : parametersId) {
            if (!(typeId instanceof LambdaTypeId)) continue;
            return true;
        }
        return false;
    }

    protected boolean isProperty(@NonNull Property prop) {
        if (this.hasEcore(prop).booleanValue()) {
            return true;
        }
        Property opposite = prop.getOpposite();
        return opposite != null && this.hasEcore(opposite) != false;
    }

    @NonNull
    protected Boolean hasEcore(@NonNull Type type) {
        String typeName = type.getName();
        if (typeName != null) {
            GenClass genClass = (GenClass)OCLinEcoreTablesUtils.getNamedElement1(this.genPackage.getGenClasses(), typeName);
            if (genClass != null) {
                return true;
            }
            GenEnum genEnum = (GenEnum)OCLinEcoreTablesUtils.getNamedElement1(this.genPackage.getGenEnums(), typeName);
            if (genEnum != null) {
                return true;
            }
        }
        return false;
    }

    protected void mergeLibrary(@NonNull Package primaryPackage) {
        List primaryTypes = primaryPackage.getOwnedType();
        for (Library library : this.metaModelManager.getLibraries()) {
            Type primaryType;
            HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
            ArrayList libraryTypes = new ArrayList(library.getOwnedType());
            for (Type secondaryType : libraryTypes) {
                primaryType = (Type)DomainUtil.getNamedElement((Iterable)primaryTypes, (String)secondaryType.getName());
                if (primaryType != null) {
                    typeMap.put(secondaryType, primaryType);
                    continue;
                }
                primaryTypes.add(secondaryType);
            }
            for (Type secondaryType : libraryTypes) {
                primaryType = (Type)typeMap.get(secondaryType);
                if (primaryType == null) continue;
                List primarySuperClasses = primaryType.getSuperClass();
                for (Type secondarySuperClass : secondaryType.getSuperClass()) {
                    Type primarySuperClass = (Type)typeMap.get(secondarySuperClass);
                    if (primarySuperClass == null) {
                        primarySuperClasses.add(secondarySuperClass);
                        continue;
                    }
                    if (primarySuperClasses.contains(primarySuperClass)) continue;
                    primarySuperClasses.add(primarySuperClass);
                }
                primaryType.getOwnedOperation().addAll(secondaryType.getOwnedOperation());
                primaryType.getOwnedAttribute().addAll(secondaryType.getOwnedAttribute());
            }
        }
        for (Type primaryType : primaryTypes) {
            List primarySuperClasses = primaryType.getSuperClass();
            Type classType = (Type)DomainUtil.getNamedElement((Iterable)primarySuperClasses, (String)"Class");
            Type metaclass = (Type)DomainUtil.getNamedElement((Iterable)primarySuperClasses, (String)"Classifier");
            if (classType == null || metaclass == null) continue;
            primarySuperClasses.remove(classType);
        }
    }

    public static class CodeGenString {
        @NonNull
        private final StringBuilder s = new StringBuilder();
        private Map<String, String> classReferences = new HashMap<String, String>();
        @NonNull
        protected final Map<Type, String> typeNameMap = new HashMap<Type, String>();
        @NonNull
        protected final Set<String> typeNameUse = new HashSet<String>();

        public void append(@Nullable String string) {
            if (string != null) {
                this.s.append(string);
            }
        }

        public void addClassReference(@NonNull Class<?> referencedClass) {
            String simpleName = referencedClass.getSimpleName();
            String fullName = referencedClass.getName();
            this.addClassReference(simpleName, fullName);
        }

        protected String addClassReference(@NonNull String simpleName, @NonNull String fullName) {
            return this.classReferences.put(simpleName, fullName);
        }

        public void appendClassReference(@NonNull Class<?> referencedClass) {
            this.s.append(referencedClass.getSimpleName());
            this.addClassReference(referencedClass);
        }

        public void appendClassReference(@NonNull String referencedClass) {
            String key = referencedClass;
            int i = referencedClass.lastIndexOf(".");
            if (i > 0) {
                String trimmedKey;
                key = trimmedKey = referencedClass.substring(i + 1);
                this.s.append(key);
            } else {
                this.s.append(referencedClass);
            }
            this.addClassReference(key, referencedClass);
        }

        public void appendName(@NonNull NamedElement namedElement) {
            this.s.append(AbstractGenModelHelper.encodeName(namedElement));
        }

        public void appendPage(int i, int iMax) {
            if (i < iMax) {
                this.s.append(i);
            }
        }

        public void appendParameterName(@NonNull NamedElement namedElement) {
            this.s.append(AbstractGenModelHelper.encodeName(namedElement));
        }

        public void appendScopedTypeName(@NonNull Type theType) {
            this.s.append("_" + AbstractGenModelHelper.encodeName((NamedElement)theType));
        }

        protected void appendString(@NonNull String string) {
            String javaString = Strings.convertToJavaString((String)string);
            this.s.append("\"");
            this.s.append(javaString);
            this.s.append("\"");
        }

        public void appendUnscopedTypeName(@NonNull MetaModelManager metaModelManager, @NonNull Type theType) {
            this.s.append(this.getTypeName(metaModelManager.getPrimaryType((DomainType)theType)));
        }

        @NonNull
        private String getTypeName(@NonNull Type theType) {
            String name = this.typeNameMap.get(theType);
            if (name != null) {
                return name;
            }
            name = AbstractGenModelHelper.encodeName((NamedElement)theType);
            if (this.typeNameUse.contains(name)) {
                int index = 1;
                String candidateName = String.valueOf(name) + '_' + index;
                while (this.typeNameUse.contains(String.valueOf(name) + '_' + index)) {
                    ++index;
                }
                name = candidateName;
            }
            this.typeNameMap.put(theType, name);
            this.typeNameUse.add(name);
            return name;
        }

        @NonNull
        public List<String> getClassReferences() {
            ArrayList<String> names = new ArrayList<String>(this.classReferences.values());
            Collections.sort(names);
            return names;
        }

        @NonNull
        public String toString() {
            String string = this.s.toString();
            return string;
        }
    }

    public class DeclareParameterTypeVisitor
    extends AbstractExtendingVisitor<Object, Object> {
        protected DeclareParameterTypeVisitor(Object context) {
            super(context);
        }

        @Nullable
        public Object visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException("Unsupported DeclareParameterTypeVisitor for " + visitable.eClass().getName());
        }

        @Nullable
        public Object visitCollectionType(@NonNull CollectionType type) {
            OCLinEcoreTablesUtils.this.s.append("new ");
            OCLinEcoreTablesUtils.this.s.appendClassReference(ExecutorSpecializedType.class);
            OCLinEcoreTablesUtils.this.s.append("(LIBRARY, ");
            OCLinEcoreTablesUtils.this.s.appendString((String)DomainUtil.nonNullModel((Object)type.getName()));
            OCLinEcoreTablesUtils.this.s.append(", ");
            type.getElementType().accept((Visitor)this);
            OCLinEcoreTablesUtils.this.s.append(")");
            return null;
        }

        @Nullable
        public Object visitLambdaType(@NonNull LambdaType lambdaType) {
            OCLinEcoreTablesUtils.this.s.append("new ");
            OCLinEcoreTablesUtils.this.s.appendClassReference(ExecutorLambdaType.class);
            OCLinEcoreTablesUtils.this.s.append("(LIBRARY, ");
            OCLinEcoreTablesUtils.this.s.appendString((String)DomainUtil.nonNullModel((Object)lambdaType.getName()));
            OCLinEcoreTablesUtils.this.s.append(", ");
            lambdaType.getContextType().accept((Visitor)this);
            for (Type parameterType : lambdaType.getParameterType()) {
                OCLinEcoreTablesUtils.this.s.append(", ");
                parameterType.accept((Visitor)this);
            }
            OCLinEcoreTablesUtils.this.s.append(")");
            return null;
        }

        @Nullable
        public Object visitMetaclass(@NonNull Metaclass<?> metaclass) {
            OCLinEcoreTablesUtils.this.s.append("new ");
            OCLinEcoreTablesUtils.this.s.appendClassReference(ExecutorSpecializedType.class);
            OCLinEcoreTablesUtils.this.s.append("(LIBRARY, ");
            OCLinEcoreTablesUtils.this.s.appendString((String)DomainUtil.nonNullModel((Object)metaclass.getName()));
            OCLinEcoreTablesUtils.this.s.append(", ");
            metaclass.getInstanceType().accept((Visitor)this);
            OCLinEcoreTablesUtils.this.s.append(")");
            return null;
        }

        @Nullable
        public Object visitTupleType(@NonNull TupleType tupleType) {
            OCLinEcoreTablesUtils.this.s.append("new ");
            OCLinEcoreTablesUtils.this.s.appendClassReference(ExecutorTupleType.class);
            OCLinEcoreTablesUtils.this.s.append("(LIBRARY, ");
            OCLinEcoreTablesUtils.this.s.appendString((String)DomainUtil.nonNullModel((Object)tupleType.getName()));
            OCLinEcoreTablesUtils.this.s.append(", ");
            for (Property part : tupleType.getOwnedAttribute()) {
                OCLinEcoreTablesUtils.this.s.append(", ");
                part.getType().accept((Visitor)this);
            }
            OCLinEcoreTablesUtils.this.s.append(")");
            return null;
        }

        @Nullable
        public Object visitType(@NonNull Type type) {
            TemplateParameter owningTemplateParameter = type.getOwningTemplateParameter();
            if (owningTemplateParameter == null) {
                type.accept((Visitor)OCLinEcoreTablesUtils.this.emitQualifiedLiteralVisitor);
            } else if (owningTemplateParameter.getSignature().getTemplate() instanceof Type) {
                Type containerType = (Type)owningTemplateParameter.getSignature().getTemplate();
                assert (containerType != null);
                String prefix = OCLinEcoreTablesUtils.this.getQualifiedTablesClassName(containerType);
                if (prefix.length() <= 0) {
                    OCLinEcoreTablesUtils.this.s.append("(");
                    OCLinEcoreTablesUtils.this.s.appendClassReference(DomainType.class);
                    OCLinEcoreTablesUtils.this.s.append(")null/*containerType._package.name/");
                } else {
                    OCLinEcoreTablesUtils.this.s.appendClassReference(prefix);
                    OCLinEcoreTablesUtils.this.s.append(".TypeParameters.");
                    OCLinEcoreTablesUtils.this.s.appendScopedTypeName(containerType);
                    OCLinEcoreTablesUtils.this.s.append("_");
                    OCLinEcoreTablesUtils.this.s.appendParameterName((NamedElement)type);
                }
            } else if (owningTemplateParameter.getSignature().getTemplate() instanceof Operation) {
                Operation containerOperation = (Operation)owningTemplateParameter.getSignature().getTemplate();
                Type containerType = containerOperation.getOwningType();
                assert (containerType != null);
                String prefix = OCLinEcoreTablesUtils.this.getQualifiedTablesClassName(containerType);
                if (prefix.length() <= 0) {
                    OCLinEcoreTablesUtils.this.s.append("(");
                    OCLinEcoreTablesUtils.this.s.appendClassReference(DomainType.class);
                    OCLinEcoreTablesUtils.this.s.append(")null/*containerOperation.owningType._package.name/");
                } else {
                    OCLinEcoreTablesUtils.this.s.appendClassReference(prefix);
                    OCLinEcoreTablesUtils.this.s.append(".TypeParameters._");
                    containerOperation.accept((Visitor)OCLinEcoreTablesUtils.this.emitLiteralVisitor);
                    OCLinEcoreTablesUtils.this.s.append("_");
                    OCLinEcoreTablesUtils.this.s.appendParameterName((NamedElement)type);
                }
            }
            return null;
        }
    }

    public class EmitLiteralVisitor
    extends AbstractExtendingVisitor<Object, Object> {
        protected EmitLiteralVisitor(Object context) {
            super(context);
        }

        @Nullable
        public Object visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException("Unsupported EmitLiteralVisitor for " + visitable.eClass().getName());
        }

        @Nullable
        public Object visitCollectionType(@NonNull CollectionType type) {
            CollectionType unspecializedType = (CollectionType)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)type);
            OCLinEcoreTablesUtils.this.s.append("Types.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)unspecializedType);
            return null;
        }

        @Nullable
        public Object visitConstraint(@NonNull Constraint constraint) {
            Type type = (Type)DomainUtil.nonNullModel((Object)((Type)constraint.eContainer()));
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName(type);
            OCLinEcoreTablesUtils.this.s.append("__");
            OCLinEcoreTablesUtils.this.s.append(NameQueries.getUniqueText((Element)type, constraint));
            return null;
        }

        @Nullable
        public Object visitEnumerationLiteral(@NonNull EnumerationLiteral enumerationLiteral) {
            Enumeration enumeration = (Enumeration)DomainUtil.nonNullModel((Object)enumerationLiteral.getEnumeration());
            OCLinEcoreTablesUtils.this.s.append("EnumerationLiterals.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)enumeration);
            OCLinEcoreTablesUtils.this.s.append("__");
            OCLinEcoreTablesUtils.this.s.appendName((NamedElement)enumerationLiteral);
            return null;
        }

        @Nullable
        public Object visitOperation(@NonNull Operation operation) {
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)DomainUtil.nonNullModel((Object)operation.getOwningType()));
            OCLinEcoreTablesUtils.this.s.append("__");
            OCLinEcoreTablesUtils.this.s.appendName((NamedElement)operation);
            return null;
        }

        @Nullable
        public Object visitPackage(@NonNull Package pkge) {
            OCLinEcoreTablesUtils.this.s.append("_");
            OCLinEcoreTablesUtils.this.s.appendName((NamedElement)pkge);
            return null;
        }

        @Nullable
        public Object visitProperty(@NonNull Property property) {
            Property opposite;
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)DomainUtil.nonNullModel((Object)property.getOwningType()));
            OCLinEcoreTablesUtils.this.s.append("__");
            OCLinEcoreTablesUtils.this.s.appendName((NamedElement)property);
            if (property.isImplicit() && (opposite = property.getOpposite()) != null) {
                OCLinEcoreTablesUtils.this.s.append("__");
                OCLinEcoreTablesUtils.this.s.appendName((NamedElement)opposite);
            }
            return null;
        }

        @Nullable
        public Object visitType(@NonNull Type type) {
            if (type.getOwningTemplateParameter() != null) {
                OCLinEcoreTablesUtils.this.s.append("null");
            } else {
                OCLinEcoreTablesUtils.this.s.append("Types.");
                OCLinEcoreTablesUtils.this.s.appendScopedTypeName(type);
            }
            return null;
        }
    }

    public class EmitQualifiedLiteralVisitor
    extends EmitLiteralVisitor {
        protected EmitQualifiedLiteralVisitor(Object context) {
            super(context);
        }

        @Override
        @Nullable
        public Object visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException("Unsupported EmitQualifiedLiteralVisitor for " + visitable.eClass().getName());
        }

        @Override
        @Nullable
        public Object visitCollectionType(@NonNull CollectionType object) {
            CollectionType unspecializedObject = (CollectionType)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)object);
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName((Type)unspecializedObject));
            OCLinEcoreTablesUtils.this.s.append(".Types.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)unspecializedObject);
            return null;
        }

        @Override
        @Nullable
        public Object visitEnumerationLiteral(@NonNull EnumerationLiteral enumerationLiteral) {
            Enumeration enumeration = (Enumeration)DomainUtil.nonNullModel((Object)enumerationLiteral.getEnumeration());
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName((Type)enumeration));
            OCLinEcoreTablesUtils.this.s.append(".EnumerationLiterals.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)enumeration);
            OCLinEcoreTablesUtils.this.s.append("__");
            OCLinEcoreTablesUtils.this.s.appendName((NamedElement)enumerationLiteral);
            return null;
        }

        @Override
        @Nullable
        public Object visitOperation(@NonNull Operation operation) {
            Type type = (Type)DomainUtil.nonNullModel((Object)operation.getOwningType());
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName(type));
            OCLinEcoreTablesUtils.this.s.append(".Operations.");
            return super.visitOperation(operation);
        }

        @Override
        @Nullable
        public Object visitProperty(@NonNull Property property) {
            Type type = (Type)DomainUtil.nonNullModel((Object)property.getOwningType());
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName(type));
            OCLinEcoreTablesUtils.this.s.append(".Properties.");
            return super.visitProperty(property);
        }

        @Nullable
        public Object visitTupleType(@NonNull TupleType type) {
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName((Type)type));
            OCLinEcoreTablesUtils.this.s.append(".tuple_type_");
            OCLinEcoreTablesUtils.this.s.appendUnscopedTypeName(OCLinEcoreTablesUtils.this.metaModelManager, (Type)type);
            return null;
        }

        @Override
        @Nullable
        public Object visitType(@NonNull Type type) {
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName(type));
            OCLinEcoreTablesUtils.this.s.append(".Types.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName(type);
            return null;
        }
    }
}

