/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinjunit;

import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.java.CG2JavaVisitor;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;

public class JUnitCG2JavaClassVisitor
extends CG2JavaVisitor {
    @NonNull
    protected final ExpressionInOCL expInOcl;
    @Nullable
    protected final List<CGValuedElement> sortedGlobals;

    public JUnitCG2JavaClassVisitor(@NonNull JavaCodeGenerator codeGenerator, @NonNull ExpressionInOCL expInOcl, @Nullable List<CGValuedElement> sortedGlobals) {
        super(codeGenerator);
        this.expInOcl = expInOcl;
        this.sortedGlobals = sortedGlobals;
    }

    @Override
    @NonNull
    public Set<String> getAllImports() {
        return this.globalContext.getImports();
    }

    @Override
    @NonNull
    public Boolean visitCGClass(@NonNull CGClass cgClass) {
        Class<?> baseClass = this.genModelHelper.getAbstractOperationClass(this.expInOcl.getParameterVariable());
        String title = String.valueOf(cgClass.getName()) + " provides the Java implementation for\n";
        this.js.appendCommentWithOCL(title, (Element)this.expInOcl);
        String className = cgClass.getName();
        this.js.append("@SuppressWarnings(\"nls\")\n");
        this.js.append("public class " + className + " extends ");
        this.js.appendClassReference(baseClass);
        this.js.append("\n");
        this.js.append("{\n");
        this.js.pushIndentation(null);
        if (this.sortedGlobals != null) {
            this.generateGlobals(this.sortedGlobals);
        }
        this.js.append("\n");
        if (this.expInOcl.getContextVariable() != null) {
            for (CGOperation cgOperation : cgClass.getOperations()) {
                cgOperation.accept(this);
            }
        } else {
            this.js.append("/*\n");
            this.js.append("\u00abIF expInOcl.messageExpression != null\u00bb\u00ab(expInOcl.messageExpression as StringLiteralExp).stringSymbol\u00bb\u00abENDIF\u00bb\n");
            this.js.append("*/\n");
        }
        this.js.popIndentation();
        this.js.append("}\n");
        return true;
    }
}

