/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinjunit;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.analyzer.AS2CGVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.java.ImportUtils;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.oclinjunit.JUnitCG2JavaClassVisitor;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Visitor;

public class JUnitCodeGenerator
extends JavaCodeGenerator {
    @NonNull
    protected final CodeGenAnalyzer cgAnalyzer;

    @NonNull
    public static String generateClassFile(@NonNull MetaModelManager metaModelManager, @NonNull ExpressionInOCL query, @NonNull String packageName, @NonNull String className) {
        JUnitCodeGenerator expressionInOCL2Class = new JUnitCodeGenerator(metaModelManager, true);
        return expressionInOCL2Class.generate(query, packageName, className);
    }

    protected JUnitCodeGenerator(@NonNull MetaModelManager metaModelManager, boolean useNullAnnotations) {
        super(metaModelManager);
        this.getOptions().setUseNullAnnotations(useNullAnnotations);
        this.cgAnalyzer = new CodeGenAnalyzer(this);
    }

    @NonNull
    protected CGPackage createCGPackage(@NonNull ExpressionInOCL expInOcl, @NonNull String packageName, @NonNull String className) {
        CGPackage cgPackage = CGModelFactory.eINSTANCE.createCGPackage();
        cgPackage.setName(packageName);
        CGClass cgClass = CGModelFactory.eINSTANCE.createCGClass();
        cgClass.setName(className);
        cgPackage.getClasses().add(cgClass);
        Variable contextVariable = expInOcl.getContextVariable();
        if (contextVariable != null) {
            contextVariable.setIsRequired(false);
        }
        AS2CGVisitor pivot2CGVisitor = new AS2CGVisitor(this.cgAnalyzer);
        CGValuedElement cgBody = (CGValuedElement)DomainUtil.nonNullState((Object)((CGNamedElement)expInOcl.accept((Visitor)pivot2CGVisitor)));
        CGLibraryOperation cgOperation = CGModelFactory.eINSTANCE.createCGLibraryOperation();
        List<CGParameter> cgParameters = cgOperation.getParameters();
        if (contextVariable != null) {
            CGParameter cgContext = pivot2CGVisitor.getParameter(contextVariable);
            cgParameters.add(cgContext);
        }
        for (Variable parameterVariable : expInOcl.getParameterVariable()) {
            CGParameter cgParameter = pivot2CGVisitor.getParameter(parameterVariable);
            cgParameters.add(cgParameter);
        }
        cgOperation.setAst((Element)expInOcl);
        TypeId asTypeId = expInOcl.getTypeId();
        cgOperation.setTypeId(this.cgAnalyzer.getTypeId(asTypeId));
        cgOperation.setName(this.getGlobalContext().getEvaluateName());
        cgOperation.setBody(cgBody);
        cgClass.getOperations().add(cgOperation);
        return cgPackage;
    }

    @NonNull
    protected String generate(@NonNull ExpressionInOCL expInOcl, @NonNull String packageName, @NonNull String className) {
        CGPackage cgPackage = this.createCGPackage(expInOcl, packageName, className);
        this.optimize(cgPackage);
        List<CGValuedElement> sortedGlobals = this.prepareGlobals();
        JUnitCG2JavaClassVisitor cg2JavaClassVisitor = new JUnitCG2JavaClassVisitor(this, expInOcl, sortedGlobals);
        cg2JavaClassVisitor.safeVisit(cgPackage);
        Set<String> allImports = cg2JavaClassVisitor.getAllImports();
        Map<String, String> long2ShortImportNames = ImportUtils.getLong2ShortImportNames(allImports);
        return ImportUtils.resolveImports(cg2JavaClassVisitor.toString(), long2ShortImportNames);
    }

    @Override
    @NonNull
    public CodeGenAnalyzer getAnalyzer() {
        return this.cgAnalyzer;
    }
}

