/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ocl.examples.debug.launching.OCLDebuggableRunnerFactory;
import org.eclipse.ocl.examples.debug.ui.OCLDebugUIPlugin;
import org.eclipse.ocl.examples.debug.vm.utils.CompiledUnit;
import org.eclipse.ocl.examples.debug.vm.utils.LineNumberProvider;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.ocl.examples.xtext.completeocl.ui.CompleteOCLEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

class BreakpointLocationVerifier {
    private final ILineBreakpoint fBreakpoint;
    private final CompleteOCLEditor fEditor;
    private final String fInvalidLocationMessage;

    @NonNull
    private static LineNumberProvider getLineNumberProvider(final @NonNull IDocument doc) {
        return new LineNumberProvider(){

            public int getLineNumber(int offset) {
                try {
                    return doc.getLineOfOffset(offset) + 1;
                }
                catch (BadLocationException e) {
                    return -1;
                }
            }

            public int getLineEnd(int lineNumber) {
                try {
                    IRegion lineInfo = doc.getLineInformation(lineNumber);
                    return lineInfo.getOffset() + lineInfo.getLength();
                }
                catch (BadLocationException e) {
                    return -1;
                }
            }

            public int getLineCount() {
                return doc.getNumberOfLines();
            }
        };
    }

    BreakpointLocationVerifier(CompleteOCLEditor editor, ILineBreakpoint breakpoint, String invalidLocationMessage) {
        if (editor == null || breakpoint == null || invalidLocationMessage == null) {
            throw new IllegalArgumentException();
        }
        this.fEditor = editor;
        this.fBreakpoint = breakpoint;
        this.fInvalidLocationMessage = invalidLocationMessage;
    }

    IStatus run() {
        IStatus status = this.checkBreakpointableElements();
        if (!status.isOK() && this.fBreakpoint != null) {
            try {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
            }
            catch (CoreException e) {
                OCLDebugUIPlugin.log(e.getStatus());
            }
        }
        return status;
    }

    private IStatus checkBreakpointableElements() {
        CompiledUnit compilationUnit;
        int lineNumber;
        try {
            lineNumber = this.fBreakpoint.getLineNumber();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        IDocumentProvider docProvider = this.fEditor.getDocumentProvider();
        if (docProvider == null) {
            return this.canceled();
        }
        IDocument doc = docProvider.getDocument((Object)this.fEditor.getEditorInput());
        if (doc == null) {
            return this.canceled();
        }
        Root root = (Root)((XtextDocument)doc).readOnly((IUnitOfWork)new IUnitOfWork<Root, XtextResource>(){

            public Root exec(@Nullable XtextResource state) throws Exception {
                EObject eObject;
                ASResource asResource;
                BaseCSResource csResource;
                CS2PivotResourceAdapter cs2asAdapter;
                if (state instanceof BaseCSResource && (cs2asAdapter = (csResource = (BaseCSResource)state).findCS2ASAdapter()) != null && (asResource = cs2asAdapter.getASResource(csResource)) != null && asResource.getContents().size() > 0 && (eObject = (EObject)asResource.getContents().get(0)) instanceof Root) {
                    return (Root)eObject;
                }
                return null;
            }
        });
        CompiledUnit compiledUnit = compilationUnit = root != null ? new CompiledUnit((Element)root) : null;
        if (compilationUnit == null) {
            return OCLDebugUIPlugin.createErrorStatus("Failed to obtain AST");
        }
        List elements = OCLDebuggableRunnerFactory.validBreakpointLocator.getBreakpointableElementsForLine(compilationUnit, BreakpointLocationVerifier.getLineNumberProvider(doc), lineNumber);
        if (elements.isEmpty()) {
            this.report(NLS.bind((String)this.fInvalidLocationMessage, (Object)new Integer(lineNumber)));
            return this.canceled();
        }
        return Status.OK_STATUS;
    }

    protected void report(final String message) {
        OCLDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IEditorStatusLine statusLine = (IEditorStatusLine)BreakpointLocationVerifier.this.fEditor.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    statusLine.setMessage(true, message, null);
                }
                if (message != null && OCLDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }

    private IStatus canceled() {
        return OCLDebugUIPlugin.createStatus(8, this.fInvalidLocationMessage);
    }
}

