/*******************************************************************************
 * Copyright (c) 2014 E.D.Willink and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     R.Dvorak and others - QVTo debugger framework
 *     E.D.Willink - revised API for OCL debugger framework
 *******************************************************************************/
package org.eclipse.ocl.examples.debug.vm;


import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationVisitor;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;

public class ConditionChecker {

	public static final int ERR_CODE_COMPILATION = 100;
	public static final int ERR_CODE_EVALUATION = 110;
	
//	private final @NonNull String fConditionBody;
//	private final @NonNull Element fTargetASTElement;
	
//	private OCLExpression fConditionAST;
	private IStatus fConditionError;


	public ConditionChecker(@NonNull String conditionBody, @NonNull Element targetASTElement) {
//		fConditionBody = conditionBody;
//		fTargetASTElement = targetASTElement;
	}
		
	public Object evaluate(@NonNull IVMEvaluationVisitor<?> mainEvaluator) throws CoreException {
		OCLExpression condition = null; //getConditionAST();
		if (fConditionError != null) {
			throw new CoreException(fConditionError);
		}
		
		assert condition != null;
		// FIXME - use a watching thread to interrupt infinite loop execution
		EvaluationVisitor dedicatedVisitor = mainEvaluator.getClonedEvaluator();

		try {
			return condition.accept(dedicatedVisitor);
		} catch (Throwable e) {
			throw new CoreException(new Status(IStatus.ERROR, mainEvaluator.getPluginId(), ERR_CODE_EVALUATION, e.toString(), e));
		}
	}

	public boolean checkCondition(@NonNull IVMEvaluationVisitor<?> mainEvaluator) throws CoreException {
		return Boolean.TRUE.equals(evaluate(mainEvaluator));
	}
	
	public EClassifier getConditionType() {
//		if (fConditionAST != null) { 
//			return fConditionAST.getType();
//		}
		return null;
	}
}
