/*******************************************************************************
 * Copyright (c) 2014 E.D.Willink and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     R.Dvorak and others - QVTo debugger framework
 *     E.D.Willink - revised API for OCL debugger framework
 *******************************************************************************/
package org.eclipse.ocl.examples.debug.vm.evaluator;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;

public interface IVMEvaluationEnvironment<T extends NamedElement> extends EvaluationEnvironment
{
	public class StepperEntry
	{
		public final @NonNull IStepper stepper;
		public final @NonNull Element element;
		private @Nullable Map<DomainTypedElement, Object> partialResults;
		
		public StepperEntry(@NonNull IStepper stepper, @NonNull Element element) {
			this.stepper = stepper;
			this.element = element;
		}

		public void popFrom(@NonNull IVMEvaluationEnvironment<?> evaluationEnvironment) {
			Map<DomainTypedElement, Object> partialResults2 = partialResults;
			if (partialResults2 != null) {
				for (DomainTypedElement element : partialResults2.keySet()) {
					if (element != null) {
						evaluationEnvironment.remove(element);
					}
				}
				partialResults2.clear();
				partialResults = null;
			}
		}

		public void pushTo(@NonNull IVMEvaluationEnvironment<?> evaluationEnvironment, @NonNull DomainTypedElement element, @Nullable Object value) {
			Map<DomainTypedElement, Object> partialResults2 = partialResults;
			if (partialResults2 == null) {
				partialResults = partialResults2 = new HashMap<DomainTypedElement, Object>();
			}
			partialResults2.put(element, value);
			evaluationEnvironment.replace(element, value);
		}
	}

	@NonNull Element getCurrentIP();
	@NonNull UnitLocation getCurrentLocation();
	@NonNull VMDebugCore getDebugCore();
	@NonNull T getDebuggableElement();
	int getDepth();
	long getID();
	@NonNull IVMModelManager getModelManager();
	@NonNull Map<String, Resource> getModelParameterVariables();
	@NonNull NamedElement getOperation();
	@NonNull Variable getPCVariable();
	@Nullable IVMEvaluationEnvironment<?> getParentEvaluationEnvironment();
	@NonNull IVMRootEvaluationEnvironment<T> getRootEvaluationEnvironment();
	@NonNull Stack<StepperEntry> getStepperStack();
	boolean isDeferredExecution();
	void processDeferredTasks();
	@NonNull Element setCurrentIP(@NonNull Element element);
	void throwVMException(@NonNull VMRuntimeException vmRuntimeException);
}
