/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.evaluator.IOCLVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMModelManager;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMNestedEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMRootEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMRootEvaluationVisitor;
import org.eclipse.ocl.examples.debug.vm.IVMDebuggerShell;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEnvironmentFactory;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMModelManager;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;

public class OCLVMEnvironmentFactory
extends PivotEnvironmentFactory
implements IVMEnvironmentFactory {
    private IVMDebuggerShell shell;
    private long envId = 0L;

    public OCLVMEnvironmentFactory(EPackage.Registry reg, @NonNull MetaModelManager metaModelManager) {
        super(reg, metaModelManager);
    }

    @NonNull
    public OCLVMEnvironment createEnvironment() {
        OCLVMEnvironment result = new OCLVMEnvironment(this, null);
        return result;
    }

    @NonNull
    public OCLVMEnvironment createEnvironment(@NonNull Environment parent) {
        if (!(parent instanceof OCLVMEnvironment)) {
            throw new IllegalArgumentException("Parent environment must be an OCLVM environment: " + parent);
        }
        OCLVMEnvironment result = new OCLVMEnvironment((OCLVMEnvironment)parent);
        return result;
    }

    @NonNull
    public IOCLVMEvaluationEnvironment createEvaluationEnvironment(@NonNull IVMModelManager modelManager, @NonNull ExpressionInOCL expressionInOCL) {
        return new OCLVMRootEvaluationEnvironment(this.getMetaModelManager(), modelManager, expressionInOCL, ++this.envId);
    }

    @NonNull
    public IOCLVMEvaluationEnvironment createEvaluationEnvironment(@NonNull EvaluationEnvironment parent) {
        return new OCLVMNestedEvaluationEnvironment((IOCLVMEvaluationEnvironment)parent, ++this.envId, ((IOCLVMEvaluationEnvironment)parent).getOperation());
    }

    @NonNull
    public IOCLVMEvaluationEnvironment createEvaluationEnvironment(@NonNull IVMEvaluationEnvironment<?> parent, @NonNull NamedElement operation) {
        return new OCLVMNestedEvaluationEnvironment((IOCLVMEvaluationEnvironment)parent, ++this.envId, operation);
    }

    @NonNull
    public OCLVMRootEvaluationVisitor createEvaluationVisitor(@NonNull OCLVMEnvironment env, @NonNull IOCLVMEvaluationEnvironment evalEnv) {
        return new OCLVMRootEvaluationVisitor(env, evalEnv, (IVMDebuggerShell)DomainUtil.nonNullState((Object)this.shell));
    }

    @NonNull
    public OCLVMModelManager createModelManager(@NonNull MetaModelManager metaModelManager) {
        return new OCLVMModelManager(metaModelManager);
    }

    public boolean keepDebug() {
        return true;
    }

    public void setShell(@Nullable IVMDebuggerShell shell) {
        this.shell = shell;
    }
}

