/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.launching;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.core.OCLDebugCore;
import org.eclipse.ocl.examples.debug.core.OCLDebugTarget;
import org.eclipse.ocl.examples.debug.core.OCLEvaluationContext;
import org.eclipse.ocl.examples.debug.core.OCLVirtualProcess;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMVirtualMachine;
import org.eclipse.ocl.examples.debug.launching.OCLDebuggableRunnerFactory;
import org.eclipse.ocl.examples.debug.launching.OCLLaunchConstants;
import org.eclipse.ocl.examples.debug.vm.IVMVirtualMachineShell;
import org.eclipse.ocl.examples.debug.vm.core.VMVirtualProcess;
import org.eclipse.ocl.examples.debug.vm.launching.DebuggableRunner;
import org.eclipse.ocl.examples.debug.vm.launching.DebuggableRunnerFactory;
import org.eclipse.ocl.examples.debug.vm.launching.VMLaunchConfigurationDelegate;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;

public class OCLVMLaunchConfigurationDelegate
extends VMLaunchConfigurationDelegate<OCLEvaluationContext>
implements OCLLaunchConstants {
    public static final IStatus MODIFIED_SOURCE_STATUS = OCLDebugCore.INSTANCE.createError("", 300, null);

    @NonNull
    protected OCLDebugTarget createDebugTarget(@NonNull IVMVirtualMachineShell vm, @NonNull VMVirtualProcess process) {
        return new OCLDebugTarget((IProcess)process, vm);
    }

    @NonNull
    protected DebuggableRunnerFactory createDebuggableRunnerFactory(@NonNull EPackage.Registry packageRegistry, @NonNull List<String> modelURIs, @Nullable String traceURI) {
        return new OCLDebuggableRunnerFactory(packageRegistry, modelURIs, null);
    }

    @NonNull
    protected OCLEvaluationContext createEvaluationContext(@NonNull ILaunchConfiguration configuration) throws CoreException {
        Map attributes = configuration.getAttributes();
        Object contextObject = attributes.get("contextObject");
        Object expressionObject = attributes.get("expressionObject");
        if ((contextObject == null || contextObject instanceof EObject) && expressionObject instanceof ExpressionInOCL) {
            return new OCLEvaluationContext((ExpressionInOCL)expressionObject, (EObject)contextObject);
        }
        String expressionUri = configuration.getAttribute("constraint", "");
        URI expressionURI = URI.createURI((String)expressionUri, (boolean)true);
        String contextUri = configuration.getAttribute("context", "");
        URI contextURI = URI.createURI((String)contextUri, (boolean)true);
        return new OCLEvaluationContext(expressionURI, contextURI);
    }

    @NonNull
    protected OCLVMVirtualMachine createVirtualMachine(@NonNull OCLEvaluationContext evaluationContext, @NonNull DebuggableRunner runner) {
        return new OCLVMVirtualMachine(runner, evaluationContext);
    }

    @NonNull
    protected OCLVirtualProcess createVirtualProcess(@NonNull ILaunch launch, @NonNull IVMVirtualMachineShell vm) {
        return new OCLVirtualProcess(launch, vm);
    }

    @NonNull
    protected OCLDebugCore getDebugCore() {
        return OCLDebugCore.INSTANCE;
    }
}

