/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.values.IntegerRange;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.impl.OrderedSetValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.RangeSequenceValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SparseOrderedSetValueImpl;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeOrderedSetValueImpl
extends OrderedSetValueImpl {
    public RangeOrderedSetValueImpl(@NonNull CollectionTypeId typeId, @NonNull IntegerRange range) {
        super(typeId, range);
    }

    @Override
    @NonNull
    public OrderedSetValue append(@Nullable Object value) {
        IntegerRange theElements = this.getElements();
        IntegerValue nextValue = theElements.getLast().addInteger(ONE_VALUE);
        if (nextValue.equals(value)) {
            IntegerRange range = RangeOrderedSetValueImpl.createRange(theElements.getFirst(), nextValue);
            return new RangeOrderedSetValueImpl(this.getTypeId(), range);
        }
        List<Object> elements = this.createElements();
        elements.remove(value);
        elements.add(value);
        return new SparseOrderedSetValueImpl(this.getTypeId(), elements);
    }

    @Override
    @NonNull
    public IntegerValue count(@Nullable Object value) {
        IntegerValue integerValue = ValuesUtil.isIntegerValue(value);
        if (integerValue != null && this.elements.contains(integerValue)) {
            return ONE_VALUE;
        }
        return ZERO_VALUE;
    }

    protected List<Object> createElements() {
        ArrayList<Object> elements = new ArrayList<Object>(this.intSize());
        for (Object object : this.iterable()) {
            elements.add(object);
        }
        return elements;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RangeOrderedSetValueImpl) {
            RangeOrderedSetValueImpl that = (RangeOrderedSetValueImpl)obj;
            return this.elements.equals(that.elements);
        }
        return super.equals(obj);
    }

    @Override
    @Nullable
    public Value first() {
        return this.getElements().getFirst();
    }

    @Override
    @NonNull
    public OrderedSetValue flatten() {
        return this;
    }

    @NonNull
    public IntegerRange getElements() {
        return (IntegerRange)this.elements;
    }

    @Override
    @NonNull
    public OrderedSetValue including(@Nullable Object value) {
        return this.append(value);
    }

    @Override
    @Nullable
    public Value last() {
        return this.getElements().getLast();
    }

    @Override
    @NonNull
    public OrderedSetValue prepend(@Nullable Object value) {
        IntegerRange theElements = this.getElements();
        IntegerValue previousValue = theElements.getFirst().subtractInteger(ONE_VALUE);
        if (previousValue.equals(value)) {
            IntegerRange range = RangeOrderedSetValueImpl.createRange(previousValue, theElements.getLast());
            return new RangeOrderedSetValueImpl(this.getTypeId(), range);
        }
        List<Object> elements = this.createElements();
        elements.remove(value);
        elements.add(0, value);
        return new SparseOrderedSetValueImpl(this.getTypeId(), elements);
    }

    @Override
    public SequenceValue toSequenceValue() {
        return new RangeSequenceValueImpl(this.getSequenceTypeId(), this.getElements());
    }

    @Override
    public void toString(@NonNull StringBuilder s, int lengthLimit) {
        s.append("OrderedSet{");
        IntegerRange theElements = this.getElements();
        s.append(theElements.getFirst());
        s.append("..");
        s.append(theElements.getLast());
        s.append("}");
        s.toString();
    }
}

