/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.ValuesPackage;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.ValueImpl;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleValueImpl
extends ValueImpl
implements TupleValue {
    @NonNull
    protected final TupleTypeId tupleTypeId;
    @NonNull
    private final Object[] partValues;
    private Integer hashCode = null;

    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.TUPLE_VALUE;
    }

    public TupleValueImpl(@NonNull TupleTypeId tupleTypeId, @NonNull Map<? extends TuplePartId, Object> values) {
        this.tupleTypeId = tupleTypeId;
        this.partValues = new Object[tupleTypeId.getPartIds().length];
        for (Map.Entry<? extends TuplePartId, Object> entry : values.entrySet()) {
            this.partValues[entry.getKey().getIndex()] = entry.getValue();
        }
    }

    public TupleValueImpl(@NonNull TupleTypeId tupleTypeId, Object ... values) {
        this.tupleTypeId = tupleTypeId;
        TuplePartId[] partIds = tupleTypeId.getPartIds();
        if (partIds.length != values.length) {
            throw new InvalidValueException("Mismatching tuple values", new Object[0]);
        }
        this.partValues = new Object[partIds.length];
        int i = 0;
        while (i < values.length) {
            this.partValues[i] = values[i];
            ++i;
        }
    }

    @Override
    @NonNull
    public Object asObject() {
        return this.partValues;
    }

    @Override
    @NonNull
    public TupleValue asTupleValue() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TupleValueImpl)) {
            return false;
        }
        TupleValueImpl that = (TupleValueImpl)o;
        if (this.tupleTypeId != that.tupleTypeId) {
            return false;
        }
        int i = 0;
        while (i < this.partValues.length) {
            Object thisPart = this.partValues[i];
            Object thatPart = that.partValues[i];
            if (thisPart == null ? thatPart != null : !thisPart.equals(thatPart)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    @NonNull
    public TupleTypeId getTypeId() {
        return this.tupleTypeId;
    }

    @Override
    @Nullable
    public Object getValue(@NonNull TuplePartId partId) {
        return this.getValue(partId.getIndex());
    }

    @Override
    @Nullable
    public Object getValue(int index) {
        return this.partValues[index];
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int hash = this.tupleTypeId.hashCode();
            Object[] objectArray = this.partValues;
            int n = this.partValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object partValue = objectArray[n2];
                hash = 37 * hash + (partValue != null ? partValue.hashCode() : 0);
                ++n2;
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Tuple{");
        TuplePartId[] partIds = this.tupleTypeId.getPartIds();
        int i = 0;
        while (i < partIds.length) {
            TuplePartId partId = partIds[i];
            if (i != 0) {
                result.append(", ");
            }
            result.append(partId.getDisplayName());
            result.append(" = ");
            ValuesUtil.toString(this.partValues[i], result, 40);
            ++i;
        }
        result.append("}");
        return result.toString();
    }
}

