/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.locator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.locator.AbstractConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.emf.validation.validity.plugin.ValidityPlugin;
import org.eclipse.ocl.examples.emf.validation.validity.utilities.ComposedEValidator;

public class EValidatorConstraintLocator
extends AbstractConstraintLocator {
    @NonNull
    public static EValidatorConstraintLocator INSTANCE = new EValidatorConstraintLocator();

    @Override
    @Nullable
    public Map<EObject, List<LeafConstrainingNode>> getConstraints(@NonNull ValidityModel validityModel, @NonNull EPackage ePackage, @NonNull Set<Resource> resources, @NonNull Monitor monitor) {
        Map<EObject, List<LeafConstrainingNode>> map = null;
        Object object = EValidator.Registry.INSTANCE.get((Object)ePackage);
        if (object instanceof EValidator) {
            map = this.getConstraints(map, validityModel, ePackage, (EValidator)object, monitor);
        }
        if (map != null && !monitor.isCanceled()) {
            for (EObject eClassifier : map.keySet()) {
                if (monitor.isCanceled()) {
                    return null;
                }
                List<LeafConstrainingNode> oldList = map.get(eClassifier);
                if (oldList.size() <= 1) continue;
                ArrayList<LeafConstrainingNode> newList = new ArrayList<LeafConstrainingNode>(oldList);
                for (LeafConstrainingNode constraint : newList) {
                    if (!"".equals(constraint.getLabel())) continue;
                    oldList.remove(constraint);
                }
            }
        }
        return map;
    }

    @Nullable
    protected Map<EObject, List<LeafConstrainingNode>> getConstraints(@Nullable Map<EObject, List<LeafConstrainingNode>> map, @NonNull ValidityModel validityModel, @NonNull EPackage ePackage, @NonNull EValidator eValidator, @NonNull Monitor monitor) {
        if (eValidator instanceof ComposedEValidator) {
            for (EValidator child : ((ComposedEValidator)eValidator).getChildren()) {
                map = this.getConstraints(map, validityModel, ePackage, child, monitor);
            }
            return map;
        }
        HashMap<Class, ArrayList<EClassifier>> javaClass2eClassifiers = new HashMap<Class, ArrayList<EClassifier>>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (monitor.isCanceled()) {
                return null;
            }
            Class javaClass = eClassifier.getInstanceClass();
            if (javaClass == null) continue;
            ArrayList<EClassifier> eClassifiers = (ArrayList<EClassifier>)javaClass2eClassifiers.get(javaClass);
            if (eClassifiers == null) {
                eClassifiers = new ArrayList<EClassifier>();
                javaClass2eClassifiers.put(javaClass, eClassifiers);
            }
            eClassifiers.add(eClassifier);
        }
        Method[] methodArray = eValidator.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (monitor.isCanceled()) {
                return null;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (Modifier.isPublic(method.getModifiers()) && parameterTypes.length == 3 && DiagnosticChain.class == parameterTypes[1] && Map.class == parameterTypes[2]) {
                String name = method.getName();
                List eClassifiers = (List)javaClass2eClassifiers.get(parameterTypes[0]);
                if (eClassifiers != null) {
                    for (EClassifier eClassifier : eClassifiers) {
                        String eClassifierName = eClassifier.getName();
                        int index = name.indexOf(eClassifierName);
                        if (index <= 0) continue;
                        int nameLength = name.length();
                        int eClassifierNameLength = eClassifierName.length();
                        int separatorIndex = index + eClassifierNameLength;
                        String constraintName = null;
                        if (separatorIndex + 1 < nameLength && '_' == name.charAt(separatorIndex)) {
                            constraintName = name.substring(separatorIndex + 1);
                        } else if (separatorIndex == nameLength && !(eClassifier instanceof EClass)) {
                            constraintName = "<datatype>";
                        }
                        if (constraintName == null) continue;
                        map = this.createLeafConstrainingNode(map, validityModel, (EObject)eClassifier, method, constraintName);
                    }
                }
            }
            ++n2;
        }
        return map;
    }

    @Override
    public Object getImage() {
        return ValidityPlugin.INSTANCE.getImage("methpub_obj.gif");
    }

    @Override
    @NonNull
    public String getName() {
        return "Java validateXXXX methods";
    }

    @Override
    @Nullable
    public String getSourceExpression(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (!(constrainingObject instanceof Method)) {
            return null;
        }
        return ((Method)constrainingObject).toString();
    }

    @NonNull
    protected String print(@NonNull Map<EClassifier, List<LeafConstrainingNode>> map) {
        StringBuilder s = new StringBuilder();
        ArrayList<EClassifier> sortedList = new ArrayList<EClassifier>(map.keySet());
        Collections.sort(sortedList, new Comparator<EClassifier>(){

            @Override
            public int compare(EClassifier o1, EClassifier o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (EClassifier eClassifier : sortedList) {
            s.append("\t" + eClassifier.getName() + ":");
            for (LeafConstrainingNode constraint : map.get(eClassifier)) {
                s.append(" '" + constraint.getLabel() + "'");
            }
            s.append("\n");
        }
        String string = s.toString();
        return string;
    }

    @Override
    public void validate(@NonNull Result result, @NonNull ValidityManager validityManager, @Nullable Monitor monitor) {
        Method method = (Method)result.getLeafConstrainingNode().getConstrainingObject();
        EObject eObject = result.getValidatableNode().getConstrainedObject();
        BasicDiagnostic diagnostic = validityManager.createDefaultDiagnostic(eObject);
        try {
            Object eValidator;
            Class<?> declaringClass = method.getDeclaringClass();
            try {
                Field field = declaringClass.getField("INSTANCE");
                eValidator = field.get(null);
            }
            catch (Exception e) {
                eValidator = declaringClass.newInstance();
            }
            method.invoke(eValidator, eObject, diagnostic, validityManager.createDefaultContext());
            result.setDiagnostic(diagnostic);
            result.setSeverity(this.getSeverity((Diagnostic)diagnostic));
        }
        catch (Exception e) {
            result.setException(e);
            result.setSeverity(Severity.FATAL);
        }
    }
}

