/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.plugin;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.plugin.ValidityPlugin;

class ConstraintLocatorRegistryReader
extends RegistryReader {
    @NonNull
    static final String TAG_LOCATOR = "locator";
    @NonNull
    static final String ATT_METACLASS = "metaclass";
    @NonNull
    static final String ATT_CLASS = "class";

    public ConstraintLocatorRegistryReader() {
        super(RegistryFactory.getRegistry(), ValidityPlugin.INSTANCE.getSymbolicName(), "constraint_locator");
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_LOCATOR)) {
            String metaclass = element.getAttribute(ATT_METACLASS);
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                if (add) {
                    ConstraintLocatorDescriptor descriptor = new ConstraintLocatorDescriptor(element, metaclass, ATT_CLASS);
                    ValidityManager.addConstraintLocator(metaclass, descriptor);
                }
                return true;
            }
        }
        return false;
    }

    static class ConstraintLocatorDescriptor
    extends RegistryReader.PluginClassDescriptor
    implements ConstraintLocator.Descriptor {
        @Nullable
        protected final String uri;
        protected ConstraintLocator constraintLocator = null;
        protected boolean failed = false;

        public ConstraintLocatorDescriptor(@NonNull IConfigurationElement e, @Nullable String uri, @NonNull String className) {
            super(e, className);
            this.uri = uri;
        }

        @Override
        @NonNull
        public ConstraintLocator getConstraintLocator() {
            ConstraintLocator constraintLocator2 = this.constraintLocator;
            if (constraintLocator2 == null) {
                if (this.failed) {
                    throw new IllegalStateException();
                }
                try {
                    constraintLocator2 = (ConstraintLocator)this.createInstance();
                    assert (constraintLocator2 != null);
                    this.constraintLocator = constraintLocator2;
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            }
            return constraintLocator2;
        }

        @Nullable
        public String toString() {
            return this.uri;
        }
    }
}

