/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.collection;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractUntypedBinaryOperation;
import org.eclipse.ocl.examples.domain.values.CollectionValue;

public class CollectionSelectByTypeOperation
extends AbstractUntypedBinaryOperation {
    @NonNull
    public static final CollectionSelectByTypeOperation INSTANCE = new CollectionSelectByTypeOperation();

    @NonNull
    public CollectionValue evaluate(@NonNull DomainEvaluator evaluator, @Nullable Object sourceVal, @Nullable Object argVal) {
        CollectionValue collectionValue = CollectionSelectByTypeOperation.asCollectionValue((Object)sourceVal);
        DomainType requiredElementType = CollectionSelectByTypeOperation.asType((Object)argVal);
        DomainStandardLibrary standardLibrary = evaluator.getStandardLibrary();
        boolean changedContents = false;
        ArrayList newElements = new ArrayList();
        for (Object element : collectionValue.iterable()) {
            DomainType elementType = evaluator.getIdResolver().getDynamicTypeOf(element);
            if (elementType.isEqualTo(standardLibrary, requiredElementType)) {
                newElements.add(element);
                continue;
            }
            changedContents = true;
        }
        if (changedContents) {
            return evaluator.getIdResolver().createCollectionOfAll(collectionValue.isOrdered(), collectionValue.isUnique(), (TypeId)collectionValue.getTypeId(), newElements);
        }
        return collectionValue;
    }
}

