/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainFragment;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.types.AbstractFragment;
import org.eclipse.ocl.examples.domain.types.AbstractInheritance;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.executor.ExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ExecutorTypeParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectiveType
extends AbstractInheritance {
    private DomainFragment[] fragments = null;
    private int[] indexes = null;
    private Set<ReflectiveType> knownSubInheritances = null;

    protected static int computeFlags(@NonNull DomainType type) {
        if (type instanceof DomainCollectionType) {
            DomainCollectionType collectionType = (DomainCollectionType)type;
            return (collectionType.isOrdered() ? 1 : 0) | (collectionType.isUnique() ? 2 : 0);
        }
        return 0;
    }

    public ReflectiveType(@NonNull String name, @NonNull ExecutorPackage evaluationPackage, int flags, ExecutorTypeParameter ... typeParameters) {
        super(name, (DomainPackage)evaluationPackage, flags);
    }

    public void addSubInheritance(@NonNull ReflectiveType subInheritance) {
        if (this.knownSubInheritances == null) {
            this.knownSubInheritances = new HashSet<ReflectiveType>();
        }
        this.knownSubInheritances.add(subInheritance);
    }

    protected abstract AbstractFragment createFragment(@NonNull DomainInheritance var1);

    @NonNull
    public Object createInstance() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Object createInstance(@NonNull String value) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
    }

    public boolean gatherUninstalledInheritances(@NonNull List<ReflectiveType> inheritances) {
        boolean gotOne = false;
        if (!inheritances.contains((Object)this)) {
            inheritances.add(this);
            if (this.fragments == null) {
                for (DomainInheritance domainInheritance : this.getInitialSuperInheritances()) {
                    if (domainInheritance instanceof ReflectiveType) {
                        if (!((ReflectiveType)domainInheritance).gatherUninstalledInheritances(inheritances)) continue;
                        gotOne = true;
                        continue;
                    }
                    gotOne = true;
                }
            } else {
                gotOne = true;
            }
        }
        return gotOne;
    }

    @NonNull
    public final AbstractInheritance.FragmentIterable getAllSuperFragments() {
        if (this.fragments == null) {
            this.initialize();
        }
        return new AbstractInheritance.FragmentIterable((DomainFragment[])DomainUtil.nonNullState((Object)this.fragments));
    }

    public final int getDepth() {
        if (this.indexes == null) {
            this.initialize();
        }
        return this.indexes.length - 2;
    }

    public DomainFragment getFragment(int fragmentNumber) {
        if (this.fragments == null && this == this.getOclAnyInheritance()) {
            this.installOclAny();
        }
        return this.fragments[fragmentNumber];
    }

    @NonNull
    protected DomainFragment[] getFragments() {
        DomainFragment[] fragments2 = this.fragments;
        if (fragments2 != null) {
            return fragments2;
        }
        this.initialize();
        DomainFragment[] fragments3 = this.fragments;
        return fragments3;
    }

    public int getIndex(int fragmentNumber) {
        return this.indexes[fragmentNumber];
    }

    public int getIndexes() {
        return this.indexes.length;
    }

    @NonNull
    protected abstract Iterable<? extends DomainInheritance> getInitialSuperInheritances();

    @NonNull
    public DomainFragment getSelfFragment() {
        DomainFragment fragment;
        if (this.indexes == null) {
            this.initialize();
        }
        if ((fragment = this.getFragment(this.fragments.length - 1)) == null) {
            throw new IllegalStateException("No self fragment");
        }
        return fragment;
    }

    @NonNull
    public final AbstractInheritance.FragmentIterable getSuperFragments(int depth) {
        return new AbstractInheritance.FragmentIterable((DomainFragment[])DomainUtil.nonNullState((Object)this.fragments), this.indexes[depth], this.indexes[depth + 1]);
    }

    @NonNull
    public DomainType getType() {
        return this;
    }

    @NonNull
    public TypeId getTypeId() {
        return this.getPackage().getPackageId().getClassId(this.name, this.getTypeParameters().parametersSize());
    }

    protected synchronized void initialize() {
        block4: {
            Boolean gotOne;
            ArrayList<ReflectiveType> uninstalledInheritances = new ArrayList<ReflectiveType>();
            if (!this.gatherUninstalledInheritances(uninstalledInheritances)) {
                DomainInheritance oclAnyInheritance = this.getOclAnyInheritance();
                uninstalledInheritances.contains(oclAnyInheritance);
            }
            ArrayList<ReflectiveType> debugOldUninstalledInheritances = new ArrayList<ReflectiveType>(uninstalledInheritances);
            do {
                gotOne = false;
                ListIterator it = uninstalledInheritances.listIterator();
                while (it.hasNext()) {
                    ReflectiveType uninstalledInheritance = (ReflectiveType)((Object)it.next());
                    if (!uninstalledInheritance.isInstallable()) continue;
                    uninstalledInheritance.install();
                    it.remove();
                    gotOne = true;
                }
                if (uninstalledInheritances.isEmpty()) break block4;
            } while (gotOne.booleanValue());
            ArrayList<ReflectiveType> debugNewUninstalledInheritances = new ArrayList<ReflectiveType>();
            this.gatherUninstalledInheritances(debugNewUninstalledInheritances);
            StringBuilder s = new StringBuilder();
            s.append("Inheritance loop for ");
            ListIterator it = uninstalledInheritances.listIterator();
            while (it.hasNext()) {
                ReflectiveType uninstalledInheritance = (ReflectiveType)((Object)it.next());
                if (uninstalledInheritance.isInstallable()) continue;
                s.append("\n  ");
                s.append((Object)uninstalledInheritance);
            }
            throw new IllegalStateException(s.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean install() {
        if (this.fragments != null) {
            return true;
        }
        DomainInheritance oclAnyInheritance = this.getOclAnyInheritance();
        if (this == oclAnyInheritance) {
            this.installOclAny();
        } else {
            ArrayList<DomainInheritance> all = new ArrayList<DomainInheritance>();
            for (DomainInheritance domainInheritance : this.getInitialSuperInheritances()) {
                int n = 0;
                int i = 0;
                while (i < domainInheritance.getIndexes() - 1) {
                    DomainInheritance some;
                    DomainInheritance domainInheritance2 = some = i < all.size() ? (DomainInheritance)all.get(i) : null;
                    if (some == null) {
                        some = new ArrayList();
                        all.add(some);
                    }
                    int jMax = domainInheritance.getIndex(i + 1);
                    while (n < jMax) {
                        DomainFragment fragment = domainInheritance.getFragment(n);
                        DomainInheritance baseInheritance = fragment.getBaseInheritance();
                        if (!some.contains(baseInheritance)) {
                            some.add(baseInheritance);
                            if (baseInheritance instanceof ReflectiveType) {
                                ((ReflectiveType)baseInheritance).addSubInheritance(this);
                            }
                        }
                        ++n;
                    }
                    ++i;
                }
            }
            int n = all.size();
            int superInheritances = 0;
            for (List list : all) {
                superInheritances += list.size();
            }
            if (n > 0) {
                void var5_14;
                void var3_8;
                void var5_13;
                this.fragments = new DomainFragment[superInheritances + 1];
                this.indexes = new int[n + 2];
                boolean bl = false;
                this.indexes[0] = 0;
                int i = 0;
                while (i < n) {
                    for (DomainInheritance some : (List)all.get(i)) {
                        if (some == null) continue;
                        this.fragments[++var5_13] = this.createFragment(some);
                    }
                    this.indexes[i + 1] = var5_13;
                    ++i;
                }
                this.indexes[n] = var5_13;
                this.fragments[var5_13] = this.createFragment((DomainInheritance)this);
                ++var3_8;
                this.indexes[++var3_7] = ++var5_14;
            } else {
                this.fragments = new DomainFragment[]{oclAnyInheritance.getFragment(0), this.createFragment((DomainInheritance)this)};
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                this.indexes = nArray;
            }
        }
        return true;
    }

    protected final void installOclAny() {
        assert (this.fragments == null);
        this.fragments = new DomainFragment[]{this.createFragment((DomainInheritance)this)};
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.indexes = nArray;
    }

    public boolean isInstallable() {
        if (this.fragments != null) {
            return true;
        }
        DomainInheritance oclAnyInheritance = this.getOclAnyInheritance();
        if (this != oclAnyInheritance) {
            for (DomainInheritance domainInheritance : this.getInitialSuperInheritances()) {
                if (!(domainInheritance instanceof ReflectiveType) || ((ReflectiveType)domainInheritance).isInstalled()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isInstalled() {
        return this.fragments != null;
    }

    public void removeSubInheritance(@NonNull ReflectiveType subInheritance) {
        if (this.knownSubInheritances != null) {
            this.knownSubInheritances.remove((Object)subInheritance);
        }
    }

    public void uninstall() {
        if (this.fragments != null) {
            DomainFragment[] domainFragmentArray = this.fragments;
            int n = this.fragments.length;
            int n2 = 0;
            while (n2 < n) {
                DomainFragment fragment = domainFragmentArray[n2];
                DomainInheritance baseInheritance = fragment.getBaseInheritance();
                if (baseInheritance instanceof ReflectiveType) {
                    ((ReflectiveType)baseInheritance).removeSubInheritance(this);
                }
                ++n2;
            }
            this.fragments = null;
            this.indexes = null;
            if (this.knownSubInheritances != null) {
                Set<ReflectiveType> previouslyKnownSubInheritances = this.knownSubInheritances;
                this.knownSubInheritances = null;
                for (ReflectiveType subInheritance : previouslyKnownSubInheritances) {
                    subInheritance.uninstall();
                }
            }
        }
    }
}

